; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes='require<domtree>,loop(loop-simplifycfg),gvn' -S %s | FileCheck %s

define i32 @test_pointer_phi_select_simp_1(ptr %a, ptr %b, i1 %cond)  {
; CHECK-LABEL: @test_pointer_phi_select_simp_1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[L_1:%.*]] = load i32, ptr [[A:%.*]], align 4
; CHECK-NEXT:    [[L_2:%.*]] = load i32, ptr [[B:%.*]], align 4
; CHECK-NEXT:    [[CMP_I_I_I:%.*]] = icmp ult i32 [[L_1]], [[L_2]]
; CHECK-NEXT:    [[TMP0:%.*]] = select i1 [[CMP_I_I_I]], i32 [[L_1]], i32 [[L_2]]
; CHECK-NEXT:    [[MIN_SELECT:%.*]] = select i1 [[CMP_I_I_I]], ptr [[A]], ptr [[B]]
; CHECK-NEXT:    br label [[EXIT:%.*]]
; CHECK:       else:
; CHECK-NEXT:    [[RES_2_PRE:%.*]] = load i32, ptr [[A]], align 4
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[RES_2:%.*]] = phi i32 [ [[TMP0]], [[THEN]] ], [ [[RES_2_PRE]], [[ELSE]] ]
; CHECK-NEXT:    [[P:%.*]] = phi ptr [ [[MIN_SELECT]], [[THEN]] ], [ [[A]], [[ELSE]] ]
; CHECK-NEXT:    ret i32 [[RES_2]]
;
entry:
  br i1 %cond, label %then, label %else

then:
  %l.1 = load i32, ptr %a, align 4
  %l.2 = load i32, ptr %b, align 4
  %cmp.i.i.i = icmp ult i32 %l.1, %l.2
  %min.select  = select i1 %cmp.i.i.i, ptr %a, ptr %b
  br label %exit

else:
  br label %exit

exit:
  %p = phi ptr [ %min.select, %then ], [ %a, %else ]
  %res.2 = load i32, ptr %p, align 4
  ret i32 %res.2
}

define i32 @test_pointer_phi_select_simp_non_local(ptr %a, ptr %b, ptr %c)  {
; CHECK-LABEL: @test_pointer_phi_select_simp_non_local(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[L_1:%.*]] = load i32, ptr [[A:%.*]], align 4
; CHECK-NEXT:    [[COND:%.*]] = icmp sgt i32 [[L_1]], 0
; CHECK-NEXT:    br i1 [[COND]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[L_2:%.*]] = load i32, ptr [[B:%.*]], align 4
; CHECK-NEXT:    [[CMP_I_I_I:%.*]] = icmp ult i32 [[L_1]], [[L_2]]
; CHECK-NEXT:    [[TMP0:%.*]] = select i1 [[CMP_I_I_I]], i32 [[L_1]], i32 [[L_2]]
; CHECK-NEXT:    [[MIN_SELECT:%.*]] = select i1 [[CMP_I_I_I]], ptr [[A]], ptr [[B]]
; CHECK-NEXT:    br label [[EXIT:%.*]]
; CHECK:       else:
; CHECK-NEXT:    [[RES_2_PRE:%.*]] = load i32, ptr [[C:%.*]], align 4
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[RES_2:%.*]] = phi i32 [ [[TMP0]], [[THEN]] ], [ [[RES_2_PRE]], [[ELSE]] ]
; CHECK-NEXT:    [[P:%.*]] = phi ptr [ [[MIN_SELECT]], [[THEN]] ], [ [[C]], [[ELSE]] ]
; CHECK-NEXT:    ret i32 [[RES_2]]
;
entry:
  %l.1 = load i32, ptr %a, align 4
  %cond = icmp sgt i32 %l.1, 0
  br i1 %cond, label %then, label %else

then:
  %l.2 = load i32, ptr %b, align 4
  %cmp.i.i.i = icmp ult i32 %l.1, %l.2
  %min.select  = select i1 %cmp.i.i.i, ptr %a, ptr %b
  br label %exit

else:
  br label %exit

exit:
  %p = phi ptr [ %min.select, %then ], [ %c, %else ]
  %res.2 = load i32, ptr %p, align 4
  ret i32 %res.2
}

define i32 @test_pointer_phi_select_simp_non_local_mismatched_type(ptr %a, ptr %b, ptr %c)  {
; CHECK-LABEL: @test_pointer_phi_select_simp_non_local_mismatched_type(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[L_1:%.*]] = load float, ptr [[A:%.*]], align 4
; CHECK-NEXT:    [[CONV:%.*]] = fptosi float [[L_1]] to i32
; CHECK-NEXT:    [[COND:%.*]] = icmp sgt i32 [[CONV]], 0
; CHECK-NEXT:    br i1 [[COND]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[L_2:%.*]] = load i32, ptr [[B:%.*]], align 4
; CHECK-NEXT:    [[CMP_I_I_I:%.*]] = icmp ult i32 [[CONV]], [[L_2]]
; CHECK-NEXT:    [[MIN_SELECT:%.*]] = select i1 [[CMP_I_I_I]], ptr [[A]], ptr [[B]]
; CHECK-NEXT:    br label [[EXIT:%.*]]
; CHECK:       else:
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[P:%.*]] = phi ptr [ [[MIN_SELECT]], [[THEN]] ], [ [[C:%.*]], [[ELSE]] ]
; CHECK-NEXT:    [[RES_2:%.*]] = load i32, ptr [[P]], align 4
; CHECK-NEXT:    ret i32 [[RES_2]]
;
entry:
  %l.1 = load float, ptr %a, align 4
  %conv = fptosi float %l.1 to i32
  %cond = icmp sgt i32 %conv, 0
  br i1 %cond, label %then, label %else

then:
  %l.2 = load i32, ptr %b, align 4
  %cmp.i.i.i = icmp ult i32 %conv, %l.2
  %min.select  = select i1 %cmp.i.i.i, ptr %a, ptr %b
  br label %exit

else:
  br label %exit

exit:
  %p = phi ptr [ %min.select, %then ], [ %c, %else ]
  %res.2 = load i32, ptr %p, align 4
  ret i32 %res.2
}

define i32 @test_pointer_phi_select_simp_no_load_for_select_op_1(ptr %a, ptr %b, ptr %c, i1 %cond)  {
; CHECK-LABEL: @test_pointer_phi_select_simp_no_load_for_select_op_1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[L_1:%.*]] = load i32, ptr [[C:%.*]], align 4
; CHECK-NEXT:    [[L_2:%.*]] = load i32, ptr [[B:%.*]], align 4
; CHECK-NEXT:    [[CMP_I_I_I:%.*]] = icmp ult i32 [[L_1]], [[L_2]]
; CHECK-NEXT:    [[MIN_SELECT:%.*]] = select i1 [[CMP_I_I_I]], ptr [[A:%.*]], ptr [[B]]
; CHECK-NEXT:    br label [[EXIT:%.*]]
; CHECK:       else:
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[P:%.*]] = phi ptr [ [[MIN_SELECT]], [[THEN]] ], [ [[A]], [[ELSE]] ]
; CHECK-NEXT:    [[RES_2:%.*]] = load i32, ptr [[P]], align 4
; CHECK-NEXT:    ret i32 [[RES_2]]
;
entry:
  br i1 %cond, label %then, label %else

then:
  %l.1 = load i32, ptr %c, align 4
  %l.2 = load i32, ptr %b, align 4
  %cmp.i.i.i = icmp ult i32 %l.1, %l.2
  %min.select  = select i1 %cmp.i.i.i, ptr %a, ptr %b
  br label %exit

else:
  br label %exit

exit:
  %p = phi ptr [ %min.select, %then ], [ %a, %else ]
  %res.2 = load i32, ptr %p, align 4
  ret i32 %res.2
}

define i32 @test_pointer_phi_select_simp_no_load_for_select_op_2(ptr %a, ptr %b, ptr %c, i1 %cond)  {
; CHECK-LABEL: @test_pointer_phi_select_simp_no_load_for_select_op_2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[L_1:%.*]] = load i32, ptr [[A:%.*]], align 4
; CHECK-NEXT:    [[L_2:%.*]] = load i32, ptr [[C:%.*]], align 4
; CHECK-NEXT:    [[CMP_I_I_I:%.*]] = icmp ult i32 [[L_1]], [[L_2]]
; CHECK-NEXT:    [[MIN_SELECT:%.*]] = select i1 [[CMP_I_I_I]], ptr [[A]], ptr [[B:%.*]]
; CHECK-NEXT:    br label [[EXIT:%.*]]
; CHECK:       else:
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[P:%.*]] = phi ptr [ [[MIN_SELECT]], [[THEN]] ], [ [[A]], [[ELSE]] ]
; CHECK-NEXT:    [[RES_2:%.*]] = load i32, ptr [[P]], align 4
; CHECK-NEXT:    ret i32 [[RES_2]]
;
entry:
  br i1 %cond, label %then, label %else

then:
  %l.1 = load i32, ptr %a, align 4
  %l.2 = load i32, ptr %c, align 4
  %cmp.i.i.i = icmp ult i32 %l.1, %l.2
  %min.select  = select i1 %cmp.i.i.i, ptr %a, ptr %b
  br label %exit

else:
  br label %exit

exit:
  %p = phi ptr [ %min.select, %then ], [ %a, %else ]
  %res.2 = load i32, ptr %p, align 4
  ret i32 %res.2
}

define i32 @test_pointer_phi_select_simp_store_noclobber(ptr %a, ptr %b, ptr noalias %c, i1 %cond)  {
; CHECK-LABEL: @test_pointer_phi_select_simp_store_noclobber(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[L_1:%.*]] = load i32, ptr [[A:%.*]], align 4
; CHECK-NEXT:    [[L_2:%.*]] = load i32, ptr [[B:%.*]], align 4
; CHECK-NEXT:    store i32 99, ptr [[C:%.*]], align 4
; CHECK-NEXT:    [[CMP_I_I_I:%.*]] = icmp ult i32 [[L_1]], [[L_2]]
; CHECK-NEXT:    [[TMP0:%.*]] = select i1 [[CMP_I_I_I]], i32 [[L_1]], i32 [[L_2]]
; CHECK-NEXT:    [[MIN_SELECT:%.*]] = select i1 [[CMP_I_I_I]], ptr [[A]], ptr [[B]]
; CHECK-NEXT:    br label [[EXIT:%.*]]
; CHECK:       else:
; CHECK-NEXT:    [[RES_2_PRE:%.*]] = load i32, ptr [[A]], align 4
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[RES_2:%.*]] = phi i32 [ [[TMP0]], [[THEN]] ], [ [[RES_2_PRE]], [[ELSE]] ]
; CHECK-NEXT:    [[P:%.*]] = phi ptr [ [[MIN_SELECT]], [[THEN]] ], [ [[A]], [[ELSE]] ]
; CHECK-NEXT:    ret i32 [[RES_2]]
;
entry:
  br i1 %cond, label %then, label %else

then:
  %l.1 = load i32, ptr %a, align 4
  %l.2 = load i32, ptr %b, align 4
  store i32 99, ptr %c
  %cmp.i.i.i = icmp ult i32 %l.1, %l.2
  %min.select  = select i1 %cmp.i.i.i, ptr %a, ptr %b
  br label %exit

else:
  br label %exit

exit:
  %p = phi ptr [ %min.select, %then ], [ %a, %else ]
  %res.2 = load i32, ptr %p, align 4
  ret i32 %res.2
}

define i32 @test_pointer_phi_select_simp_store_clobber_1(ptr %a, ptr %b, ptr %c, i1 %cond)  {
; CHECK-LABEL: @test_pointer_phi_select_simp_store_clobber_1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[L_1:%.*]] = load i32, ptr [[A:%.*]], align 4
; CHECK-NEXT:    [[L_2:%.*]] = load i32, ptr [[B:%.*]], align 4
; CHECK-NEXT:    store i32 99, ptr [[C:%.*]], align 4
; CHECK-NEXT:    [[CMP_I_I_I:%.*]] = icmp ult i32 [[L_1]], [[L_2]]
; CHECK-NEXT:    [[MIN_SELECT:%.*]] = select i1 [[CMP_I_I_I]], ptr [[A]], ptr [[B]]
; CHECK-NEXT:    br label [[EXIT:%.*]]
; CHECK:       else:
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[P:%.*]] = phi ptr [ [[MIN_SELECT]], [[THEN]] ], [ [[A]], [[ELSE]] ]
; CHECK-NEXT:    [[RES_2:%.*]] = load i32, ptr [[P]], align 4
; CHECK-NEXT:    ret i32 [[RES_2]]
;
entry:
  br i1 %cond, label %then, label %else

then:
  %l.1 = load i32, ptr %a, align 4
  %l.2 = load i32, ptr %b, align 4
  store i32 99, ptr %c
  %cmp.i.i.i = icmp ult i32 %l.1, %l.2
  %min.select  = select i1 %cmp.i.i.i, ptr %a, ptr %b
  br label %exit

else:
  br label %exit

exit:
  %p = phi ptr [ %min.select, %then ], [ %a, %else ]
  %res.2 = load i32, ptr %p, align 4
  ret i32 %res.2
}

define i32 @test_pointer_phi_select_simp_store_clobber_2(ptr %a, ptr %b, ptr %c, i1 %cond)  {
; CHECK-LABEL: @test_pointer_phi_select_simp_store_clobber_2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[L_1:%.*]] = load i32, ptr [[A:%.*]], align 4
; CHECK-NEXT:    store i32 99, ptr [[C:%.*]], align 4
; CHECK-NEXT:    [[L_2:%.*]] = load i32, ptr [[B:%.*]], align 4
; CHECK-NEXT:    [[CMP_I_I_I:%.*]] = icmp ult i32 [[L_1]], [[L_2]]
; CHECK-NEXT:    [[MIN_SELECT:%.*]] = select i1 [[CMP_I_I_I]], ptr [[A]], ptr [[B]]
; CHECK-NEXT:    br label [[EXIT:%.*]]
; CHECK:       else:
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[P:%.*]] = phi ptr [ [[MIN_SELECT]], [[THEN]] ], [ [[A]], [[ELSE]] ]
; CHECK-NEXT:    [[RES_2:%.*]] = load i32, ptr [[P]], align 4
; CHECK-NEXT:    ret i32 [[RES_2]]
;
entry:
  br i1 %cond, label %then, label %else

then:
  %l.1 = load i32, ptr %a, align 4
  store i32 99, ptr %c
  %l.2 = load i32, ptr %b, align 4
  %cmp.i.i.i = icmp ult i32 %l.1, %l.2
  %min.select  = select i1 %cmp.i.i.i, ptr %a, ptr %b
  br label %exit

else:
  br label %exit

exit:
  %p = phi ptr [ %min.select, %then ], [ %a, %else ]
  %res.2 = load i32, ptr %p, align 4
  ret i32 %res.2
}

define i32 @test_pointer_phi_select_simp_store_clobber_3(ptr %a, ptr %b, ptr %c, i1 %cond)  {
; CHECK-LABEL: @test_pointer_phi_select_simp_store_clobber_3(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    store i32 99, ptr [[C:%.*]], align 4
; CHECK-NEXT:    [[L_1:%.*]] = load i32, ptr [[A:%.*]], align 4
; CHECK-NEXT:    [[L_2:%.*]] = load i32, ptr [[B:%.*]], align 4
; CHECK-NEXT:    [[CMP_I_I_I:%.*]] = icmp ult i32 [[L_1]], [[L_2]]
; CHECK-NEXT:    [[TMP0:%.*]] = select i1 [[CMP_I_I_I]], i32 [[L_1]], i32 [[L_2]]
; CHECK-NEXT:    [[MIN_SELECT:%.*]] = select i1 [[CMP_I_I_I]], ptr [[A]], ptr [[B]]
; CHECK-NEXT:    br label [[EXIT:%.*]]
; CHECK:       else:
; CHECK-NEXT:    [[RES_2_PRE:%.*]] = load i32, ptr [[A]], align 4
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[RES_2:%.*]] = phi i32 [ [[TMP0]], [[THEN]] ], [ [[RES_2_PRE]], [[ELSE]] ]
; CHECK-NEXT:    [[P:%.*]] = phi ptr [ [[MIN_SELECT]], [[THEN]] ], [ [[A]], [[ELSE]] ]
; CHECK-NEXT:    ret i32 [[RES_2]]
;
entry:
  br i1 %cond, label %then, label %else

then:
  store i32 99, ptr %c
  %l.1 = load i32, ptr %a, align 4
  %l.2 = load i32, ptr %b, align 4
  %cmp.i.i.i = icmp ult i32 %l.1, %l.2
  %min.select  = select i1 %cmp.i.i.i, ptr %a, ptr %b
  br label %exit

else:
  br label %exit

exit:
  %p = phi ptr [ %min.select, %then ], [ %a, %else ]
  %res.2 = load i32, ptr %p, align 4
  ret i32 %res.2
}

define i32 @test_pointer_phi_select_simp_store_clobber_4(ptr %a, ptr %b, ptr %c, i1 %cond)  {
; CHECK-LABEL: @test_pointer_phi_select_simp_store_clobber_4(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[L_1:%.*]] = load i32, ptr [[A:%.*]], align 4
; CHECK-NEXT:    [[L_2:%.*]] = load i32, ptr [[B:%.*]], align 4
; CHECK-NEXT:    [[CMP_I_I_I:%.*]] = icmp ult i32 [[L_1]], [[L_2]]
; CHECK-NEXT:    [[MIN_SELECT:%.*]] = select i1 [[CMP_I_I_I]], ptr [[A]], ptr [[B]]
; CHECK-NEXT:    store i32 99, ptr [[C:%.*]], align 4
; CHECK-NEXT:    br label [[EXIT:%.*]]
; CHECK:       else:
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[P:%.*]] = phi ptr [ [[MIN_SELECT]], [[THEN]] ], [ [[A]], [[ELSE]] ]
; CHECK-NEXT:    [[RES_2:%.*]] = load i32, ptr [[P]], align 4
; CHECK-NEXT:    ret i32 [[RES_2]]
;
entry:
  br i1 %cond, label %then, label %else

then:
  %l.1 = load i32, ptr %a, align 4
  %l.2 = load i32, ptr %b, align 4
  %cmp.i.i.i = icmp ult i32 %l.1, %l.2
  %min.select  = select i1 %cmp.i.i.i, ptr %a, ptr %b
  store i32 99, ptr %c
  br label %exit

else:
  br label %exit

exit:
  %p = phi ptr [ %min.select, %then ], [ %a, %else ]
  %res.2 = load i32, ptr %p, align 4
  ret i32 %res.2
}

define i32 @test_pointer_phi_select_simp_store_clobber_5(ptr %a, ptr %b, ptr %c, i1 %cond)  {
; CHECK-LABEL: @test_pointer_phi_select_simp_store_clobber_5(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[L_1:%.*]] = load i32, ptr [[A:%.*]], align 4
; CHECK-NEXT:    [[L_2:%.*]] = load i32, ptr [[B:%.*]], align 4
; CHECK-NEXT:    [[CMP_I_I_I:%.*]] = icmp ult i32 [[L_1]], [[L_2]]
; CHECK-NEXT:    [[MIN_SELECT:%.*]] = select i1 [[CMP_I_I_I]], ptr [[A]], ptr [[B]]
; CHECK-NEXT:    br label [[EXIT:%.*]]
; CHECK:       else:
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[P:%.*]] = phi ptr [ [[MIN_SELECT]], [[THEN]] ], [ [[A]], [[ELSE]] ]
; CHECK-NEXT:    store i32 99, ptr [[C:%.*]], align 4
; CHECK-NEXT:    [[RES_2:%.*]] = load i32, ptr [[P]], align 4
; CHECK-NEXT:    ret i32 [[RES_2]]
;
entry:
  br i1 %cond, label %then, label %else

then:
  %l.1 = load i32, ptr %a, align 4
  %l.2 = load i32, ptr %b, align 4
  %cmp.i.i.i = icmp ult i32 %l.1, %l.2
  %min.select  = select i1 %cmp.i.i.i, ptr %a, ptr %b
  br label %exit

else:
  br label %exit

exit:
  %p = phi ptr [ %min.select, %then ], [ %a, %else ]
  store i32 99, ptr %c
  %res.2 = load i32, ptr %p, align 4
  ret i32 %res.2
}

define i32 @test_pointer_phi_select_simp_store_clobber_6(ptr %a, ptr %b, ptr %c, i1 %cond)  {
; CHECK-LABEL: @test_pointer_phi_select_simp_store_clobber_6(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[L_1:%.*]] = load i32, ptr [[A:%.*]], align 4
; CHECK-NEXT:    [[L_2:%.*]] = load i32, ptr [[B:%.*]], align 4
; CHECK-NEXT:    store i32 99, ptr [[C:%.*]], align 4
; CHECK-NEXT:    [[CMP_I_I_I:%.*]] = icmp ult i32 [[L_1]], [[L_2]]
; CHECK-NEXT:    [[MIN_SELECT:%.*]] = select i1 [[CMP_I_I_I]], ptr [[A]], ptr [[B]]
; CHECK-NEXT:    [[RES_0:%.*]] = load i32, ptr [[MIN_SELECT]], align 4
; CHECK-NEXT:    br label [[EXIT:%.*]]
; CHECK:       else:
; CHECK-NEXT:    [[RES_2_PRE:%.*]] = load i32, ptr [[A]], align 4
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[RES_2:%.*]] = phi i32 [ [[RES_0]], [[THEN]] ], [ [[RES_2_PRE]], [[ELSE]] ]
; CHECK-NEXT:    [[P:%.*]] = phi ptr [ [[MIN_SELECT]], [[THEN]] ], [ [[A]], [[ELSE]] ]
; CHECK-NEXT:    [[V:%.*]] = phi i32 [ [[RES_0]], [[THEN]] ], [ 10, [[ELSE]] ]
; CHECK-NEXT:    [[ADD:%.*]] = add i32 [[RES_2]], [[V]]
; CHECK-NEXT:    ret i32 [[RES_2]]
;
entry:
  br i1 %cond, label %then, label %else

then:
  %l.1 = load i32, ptr %a, align 4
  %l.2 = load i32, ptr %b, align 4
  store i32 99, ptr %c
  %cmp.i.i.i = icmp ult i32 %l.1, %l.2
  %min.select  = select i1 %cmp.i.i.i, ptr %a, ptr %b
  %res.0 = load i32, ptr %min.select, align 4
  br label %exit

else:
  br label %exit

exit:
  %p = phi ptr [ %min.select, %then ], [ %a, %else ]
  %v = phi i32 [ %res.0, %then ], [ 10, %else ]
  %res.2 = load i32, ptr %p, align 4
  %add = add i32 %res.2, %v
  ret i32 %res.2
}

define i32 @test_pointer_phi_select_simp_store_clobber_7(ptr %a, ptr %b, ptr %c, i1 %cond)  {
; CHECK-LABEL: @test_pointer_phi_select_simp_store_clobber_7(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[L_1:%.*]] = load i32, ptr [[A:%.*]], align 4
; CHECK-NEXT:    [[L_2:%.*]] = load i32, ptr [[B:%.*]], align 4
; CHECK-NEXT:    store i32 99, ptr [[C:%.*]], align 4
; CHECK-NEXT:    [[CMP_I_I_I:%.*]] = icmp ult i32 [[L_1]], [[L_2]]
; CHECK-NEXT:    [[MIN_SELECT:%.*]] = select i1 [[CMP_I_I_I]], ptr [[A]], ptr [[B]]
; CHECK-NEXT:    [[RES_0:%.*]] = load i32, ptr [[A]], align 4
; CHECK-NEXT:    br label [[EXIT:%.*]]
; CHECK:       else:
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[P:%.*]] = phi ptr [ [[MIN_SELECT]], [[THEN]] ], [ [[A]], [[ELSE]] ]
; CHECK-NEXT:    [[V:%.*]] = phi i32 [ [[RES_0]], [[THEN]] ], [ 10, [[ELSE]] ]
; CHECK-NEXT:    [[RES_2:%.*]] = load i32, ptr [[P]], align 4
; CHECK-NEXT:    [[ADD:%.*]] = add i32 [[RES_2]], [[V]]
; CHECK-NEXT:    ret i32 [[RES_2]]
;
entry:
  br i1 %cond, label %then, label %else

then:
  %l.1 = load i32, ptr %a, align 4
  %l.2 = load i32, ptr %b, align 4
  store i32 99, ptr %c
  %cmp.i.i.i = icmp ult i32 %l.1, %l.2
  %min.select  = select i1 %cmp.i.i.i, ptr %a, ptr %b
  %res.0 = load i32, ptr %a, align 4
  br label %exit

else:
  br label %exit

exit:
  %p = phi ptr [ %min.select, %then ], [ %a, %else ]
  %v = phi i32 [ %res.0, %then ], [ 10, %else ]
  %res.2 = load i32, ptr %p, align 4
  %add = add i32 %res.2, %v
  ret i32 %res.2
}

define i32 @test_pointer_phi_select_simp_store_clobber_8(ptr %a, ptr %b, ptr %c, i1 %cond)  {
; CHECK-LABEL: @test_pointer_phi_select_simp_store_clobber_8(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[L_1:%.*]] = load i32, ptr [[A:%.*]], align 4
; CHECK-NEXT:    [[L_2:%.*]] = load i32, ptr [[B:%.*]], align 4
; CHECK-NEXT:    store i32 99, ptr [[C:%.*]], align 4
; CHECK-NEXT:    [[CMP_I_I_I:%.*]] = icmp ult i32 [[L_1]], [[L_2]]
; CHECK-NEXT:    [[MIN_SELECT:%.*]] = select i1 [[CMP_I_I_I]], ptr [[A]], ptr [[B]]
; CHECK-NEXT:    [[RES_0:%.*]] = load i32, ptr [[B]], align 4
; CHECK-NEXT:    br label [[EXIT:%.*]]
; CHECK:       else:
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[P:%.*]] = phi ptr [ [[MIN_SELECT]], [[THEN]] ], [ [[A]], [[ELSE]] ]
; CHECK-NEXT:    [[V:%.*]] = phi i32 [ [[RES_0]], [[THEN]] ], [ 10, [[ELSE]] ]
; CHECK-NEXT:    [[RES_2:%.*]] = load i32, ptr [[P]], align 4
; CHECK-NEXT:    [[ADD:%.*]] = add i32 [[RES_2]], [[V]]
; CHECK-NEXT:    ret i32 [[RES_2]]
;
entry:
  br i1 %cond, label %then, label %else

then:
  %l.1 = load i32, ptr %a, align 4
  %l.2 = load i32, ptr %b, align 4
  store i32 99, ptr %c
  %cmp.i.i.i = icmp ult i32 %l.1, %l.2
  %min.select  = select i1 %cmp.i.i.i, ptr %a, ptr %b
  %res.0 = load i32, ptr %b, align 4
  br label %exit

else:
  br label %exit

exit:
  %p = phi ptr [ %min.select, %then ], [ %a, %else ]
  %v = phi i32 [ %res.0, %then ], [ 10, %else ]
  %res.2 = load i32, ptr %p, align 4
  %add = add i32 %res.2, %v
  ret i32 %res.2
}

define i32 @test_pointer_phi_select_simp_store_clobber_9(ptr %a, ptr %b, i1 %cond)  {
; CHECK-LABEL: @test_pointer_phi_select_simp_store_clobber_9(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[L_1:%.*]] = load i32, ptr [[A:%.*]], align 4
; CHECK-NEXT:    [[L_2:%.*]] = load i32, ptr [[B:%.*]], align 4
; CHECK-NEXT:    store i32 99, ptr [[A]], align 4
; CHECK-NEXT:    [[CMP_I_I_I:%.*]] = icmp ult i32 [[L_1]], [[L_2]]
; CHECK-NEXT:    [[MIN_SELECT:%.*]] = select i1 [[CMP_I_I_I]], ptr [[A]], ptr [[B]]
; CHECK-NEXT:    [[RES_0:%.*]] = load i32, ptr [[B]], align 4
; CHECK-NEXT:    br label [[EXIT:%.*]]
; CHECK:       else:
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[P:%.*]] = phi ptr [ [[MIN_SELECT]], [[THEN]] ], [ [[A]], [[ELSE]] ]
; CHECK-NEXT:    [[V:%.*]] = phi i32 [ [[RES_0]], [[THEN]] ], [ 10, [[ELSE]] ]
; CHECK-NEXT:    [[RES_2:%.*]] = load i32, ptr [[P]], align 4
; CHECK-NEXT:    [[ADD:%.*]] = add i32 [[RES_2]], [[V]]
; CHECK-NEXT:    ret i32 [[RES_2]]
;
entry:
  br i1 %cond, label %then, label %else

then:
  %l.1 = load i32, ptr %a, align 4
  %l.2 = load i32, ptr %b, align 4
  store i32 99, ptr %a
  %cmp.i.i.i = icmp ult i32 %l.1, %l.2
  %min.select  = select i1 %cmp.i.i.i, ptr %a, ptr %b
  %res.0 = load i32, ptr %b, align 4
  br label %exit

else:
  br label %exit

exit:
  %p = phi ptr [ %min.select, %then ], [ %a, %else ]
  %v = phi i32 [ %res.0, %then ], [ 10, %else ]
  %res.2 = load i32, ptr %p, align 4
  %add = add i32 %res.2, %v
  ret i32 %res.2
}

define i32 @test_pointer_phi_select_simp_store_clobber_10(ptr %a, ptr %b, i1 %cond)  {
; CHECK-LABEL: @test_pointer_phi_select_simp_store_clobber_10(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[L_1:%.*]] = load i32, ptr [[A:%.*]], align 4
; CHECK-NEXT:    store i32 99, ptr [[A]], align 4
; CHECK-NEXT:    [[L_2:%.*]] = load i32, ptr [[B:%.*]], align 4
; CHECK-NEXT:    [[CMP_I_I_I:%.*]] = icmp ult i32 [[L_1]], [[L_2]]
; CHECK-NEXT:    [[MIN_SELECT:%.*]] = select i1 [[CMP_I_I_I]], ptr [[A]], ptr [[B]]
; CHECK-NEXT:    br label [[EXIT:%.*]]
; CHECK:       else:
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[P:%.*]] = phi ptr [ [[MIN_SELECT]], [[THEN]] ], [ [[A]], [[ELSE]] ]
; CHECK-NEXT:    [[V:%.*]] = phi i32 [ [[L_2]], [[THEN]] ], [ 10, [[ELSE]] ]
; CHECK-NEXT:    [[RES_2:%.*]] = load i32, ptr [[P]], align 4
; CHECK-NEXT:    [[ADD:%.*]] = add i32 [[RES_2]], [[V]]
; CHECK-NEXT:    ret i32 [[RES_2]]
;
entry:
  br i1 %cond, label %then, label %else

then:
  %l.1 = load i32, ptr %a, align 4
  store i32 99, ptr %a
  %l.2 = load i32, ptr %b, align 4
  %cmp.i.i.i = icmp ult i32 %l.1, %l.2
  %min.select  = select i1 %cmp.i.i.i, ptr %a, ptr %b
  %res.0 = load i32, ptr %b, align 4
  br label %exit

else:
  br label %exit

exit:
  %p = phi ptr [ %min.select, %then ], [ %a, %else ]
  %v = phi i32 [ %res.0, %then ], [ 10, %else ]
  %res.2 = load i32, ptr %p, align 4
  %add = add i32 %res.2, %v
  ret i32 %res.2
}

define i32 @test_pointer_phi_select_simp_store_clobber_11(ptr %a, ptr %b, i1 %cond)  {
; CHECK-LABEL: @test_pointer_phi_select_simp_store_clobber_11(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[L_1:%.*]] = load i32, ptr [[A:%.*]], align 4
; CHECK-NEXT:    [[L_2:%.*]] = load i32, ptr [[B:%.*]], align 4
; CHECK-NEXT:    store i32 99, ptr [[B]], align 4
; CHECK-NEXT:    [[CMP_I_I_I:%.*]] = icmp ult i32 [[L_1]], [[L_2]]
; CHECK-NEXT:    [[MIN_SELECT:%.*]] = select i1 [[CMP_I_I_I]], ptr [[A]], ptr [[B]]
; CHECK-NEXT:    br label [[EXIT:%.*]]
; CHECK:       else:
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[P:%.*]] = phi ptr [ [[MIN_SELECT]], [[THEN]] ], [ [[A]], [[ELSE]] ]
; CHECK-NEXT:    [[V:%.*]] = phi i32 [ 99, [[THEN]] ], [ 10, [[ELSE]] ]
; CHECK-NEXT:    [[RES_2:%.*]] = load i32, ptr [[P]], align 4
; CHECK-NEXT:    [[ADD:%.*]] = add i32 [[RES_2]], [[V]]
; CHECK-NEXT:    ret i32 [[RES_2]]
;
entry:
  br i1 %cond, label %then, label %else

then:
  %l.1 = load i32, ptr %a, align 4
  %l.2 = load i32, ptr %b, align 4
  store i32 99, ptr %b
  %cmp.i.i.i = icmp ult i32 %l.1, %l.2
  %min.select  = select i1 %cmp.i.i.i, ptr %a, ptr %b
  %res.0 = load i32, ptr %b, align 4
  br label %exit

else:
  br label %exit

exit:
  %p = phi ptr [ %min.select, %then ], [ %a, %else ]
  %v = phi i32 [ %res.0, %then ], [ 10, %else ]
  %res.2 = load i32, ptr %p, align 4
  %add = add i32 %res.2, %v
  ret i32 %res.2
}

define i32 @test_pointer_phi_select_simp_store_clobber_12(ptr %a, ptr %b, i1 %cond)  {
; CHECK-LABEL: @test_pointer_phi_select_simp_store_clobber_12(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[L_1:%.*]] = load i32, ptr [[A:%.*]], align 4
; CHECK-NEXT:    store i32 99, ptr [[B:%.*]], align 4
; CHECK-NEXT:    [[CMP_I_I_I:%.*]] = icmp ult i32 [[L_1]], 99
; CHECK-NEXT:    [[MIN_SELECT:%.*]] = select i1 [[CMP_I_I_I]], ptr [[A]], ptr [[B]]
; CHECK-NEXT:    br label [[EXIT:%.*]]
; CHECK:       else:
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[P:%.*]] = phi ptr [ [[MIN_SELECT]], [[THEN]] ], [ [[A]], [[ELSE]] ]
; CHECK-NEXT:    [[V:%.*]] = phi i32 [ 99, [[THEN]] ], [ 10, [[ELSE]] ]
; CHECK-NEXT:    [[RES_2:%.*]] = load i32, ptr [[P]], align 4
; CHECK-NEXT:    [[ADD:%.*]] = add i32 [[RES_2]], [[V]]
; CHECK-NEXT:    ret i32 [[RES_2]]
;
entry:
  br i1 %cond, label %then, label %else

then:
  %l.1 = load i32, ptr %a, align 4
  store i32 99, ptr %b
  %l.2 = load i32, ptr %b, align 4
  %cmp.i.i.i = icmp ult i32 %l.1, %l.2
  %min.select  = select i1 %cmp.i.i.i, ptr %a, ptr %b
  %res.0 = load i32, ptr %b, align 4
  br label %exit

else:
  br label %exit

exit:
  %p = phi ptr [ %min.select, %then ], [ %a, %else ]
  %v = phi i32 [ %res.0, %then ], [ 10, %else ]
  %res.2 = load i32, ptr %p, align 4
  %add = add i32 %res.2, %v
  ret i32 %res.2
}

define i32 @test_pointer_phi_select_single_block_store(ptr %a, ptr %b)  {
; CHECK-LABEL: @test_pointer_phi_select_single_block_store(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[L_1:%.*]] = load i32, ptr [[A:%.*]], align 4
; CHECK-NEXT:    [[L_2:%.*]] = load i32, ptr [[B:%.*]], align 4
; CHECK-NEXT:    [[CMP_I_I_I:%.*]] = icmp ult i32 [[L_1]], [[L_2]]
; CHECK-NEXT:    [[TMP0:%.*]] = select i1 [[CMP_I_I_I]], i32 [[L_1]], i32 [[L_2]]
; CHECK-NEXT:    [[MIN_SELECT:%.*]] = select i1 [[CMP_I_I_I]], ptr [[A]], ptr [[B]]
; CHECK-NEXT:    ret i32 [[TMP0]]
;
entry:
  %l.1 = load i32, ptr %a, align 4
  %l.2 = load i32, ptr %b, align 4
  %cmp.i.i.i = icmp ult i32 %l.1, %l.2
  %min.select  = select i1 %cmp.i.i.i, ptr %a, ptr %b
  %res.0 = load i32, ptr %min.select, align 4
  ret i32 %res.0
}

define i32 @test_pointer_phi_select_single_block_store_clobber_1(ptr %a, ptr %b, ptr %c)  {
; CHECK-LABEL: @test_pointer_phi_select_single_block_store_clobber_1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[L_1:%.*]] = load i32, ptr [[A:%.*]], align 4
; CHECK-NEXT:    [[L_2:%.*]] = load i32, ptr [[B:%.*]], align 4
; CHECK-NEXT:    store i32 99, ptr [[C:%.*]], align 4
; CHECK-NEXT:    [[CMP_I_I_I:%.*]] = icmp ult i32 [[L_1]], [[L_2]]
; CHECK-NEXT:    [[MIN_SELECT:%.*]] = select i1 [[CMP_I_I_I]], ptr [[A]], ptr [[B]]
; CHECK-NEXT:    [[RES_0:%.*]] = load i32, ptr [[MIN_SELECT]], align 4
; CHECK-NEXT:    ret i32 [[RES_0]]
;
entry:
  %l.1 = load i32, ptr %a, align 4
  %l.2 = load i32, ptr %b, align 4
  store i32 99, ptr %c
  %cmp.i.i.i = icmp ult i32 %l.1, %l.2
  %min.select  = select i1 %cmp.i.i.i, ptr %a, ptr %b
  %res.0 = load i32, ptr %min.select, align 4
  ret i32 %res.0
}

define i32 @test_pointer_phi_select_single_block_store_clobber_2(ptr %a, ptr %b, ptr %c)  {
; CHECK-LABEL: @test_pointer_phi_select_single_block_store_clobber_2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[L_1:%.*]] = load i32, ptr [[A:%.*]], align 4
; CHECK-NEXT:    [[L_2:%.*]] = load i32, ptr [[B:%.*]], align 4
; CHECK-NEXT:    [[CMP_I_I_I:%.*]] = icmp ult i32 [[L_1]], [[L_2]]
; CHECK-NEXT:    [[MIN_SELECT:%.*]] = select i1 [[CMP_I_I_I]], ptr [[A]], ptr [[B]]
; CHECK-NEXT:    store i32 99, ptr [[C:%.*]], align 4
; CHECK-NEXT:    [[RES_0:%.*]] = load i32, ptr [[MIN_SELECT]], align 4
; CHECK-NEXT:    ret i32 [[RES_0]]
;
entry:
  %l.1 = load i32, ptr %a, align 4
  %l.2 = load i32, ptr %b, align 4
  %cmp.i.i.i = icmp ult i32 %l.1, %l.2
  %min.select  = select i1 %cmp.i.i.i, ptr %a, ptr %b
  store i32 99, ptr %c
  %res.0 = load i32, ptr %min.select, align 4
  ret i32 %res.0
}

define i32 @test_pointer_phi_select_single_block_store_clobber_3(ptr %a, ptr %b, ptr %c)  {
; CHECK-LABEL: @test_pointer_phi_select_single_block_store_clobber_3(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[L_1:%.*]] = load i32, ptr [[A:%.*]], align 4
; CHECK-NEXT:    store i32 99, ptr [[C:%.*]], align 4
; CHECK-NEXT:    [[L_2:%.*]] = load i32, ptr [[B:%.*]], align 4
; CHECK-NEXT:    [[CMP_I_I_I:%.*]] = icmp ult i32 [[L_1]], [[L_2]]
; CHECK-NEXT:    [[MIN_SELECT:%.*]] = select i1 [[CMP_I_I_I]], ptr [[A]], ptr [[B]]
; CHECK-NEXT:    [[RES_0:%.*]] = load i32, ptr [[MIN_SELECT]], align 4
; CHECK-NEXT:    ret i32 [[RES_0]]
;
entry:
  %l.1 = load i32, ptr %a, align 4
  store i32 99, ptr %c
  %l.2 = load i32, ptr %b, align 4
  %cmp.i.i.i = icmp ult i32 %l.1, %l.2
  %min.select  = select i1 %cmp.i.i.i, ptr %a, ptr %b
  %res.0 = load i32, ptr %min.select, align 4
  ret i32 %res.0
}

define i32 @test_pointer_phi_select_single_block_store_after(ptr %a, ptr %b, ptr %c)  {
; CHECK-LABEL: @test_pointer_phi_select_single_block_store_after(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[L_1:%.*]] = load i32, ptr [[A:%.*]], align 4
; CHECK-NEXT:    [[L_2:%.*]] = load i32, ptr [[B:%.*]], align 4
; CHECK-NEXT:    [[CMP_I_I_I:%.*]] = icmp ult i32 [[L_1]], [[L_2]]
; CHECK-NEXT:    [[TMP0:%.*]] = select i1 [[CMP_I_I_I]], i32 [[L_1]], i32 [[L_2]]
; CHECK-NEXT:    [[MIN_SELECT:%.*]] = select i1 [[CMP_I_I_I]], ptr [[A]], ptr [[B]]
; CHECK-NEXT:    store i32 99, ptr [[C:%.*]], align 4
; CHECK-NEXT:    ret i32 [[TMP0]]
;
entry:
  %l.1 = load i32, ptr %a, align 4
  %l.2 = load i32, ptr %b, align 4
  %cmp.i.i.i = icmp ult i32 %l.1, %l.2
  %min.select  = select i1 %cmp.i.i.i, ptr %a, ptr %b
  %res.0 = load i32, ptr %min.select, align 4
  store i32 99, ptr %c
  ret i32 %res.0
}

define i32 @test_phi_select_index_non_local(ptr %A, i32 %N, i32 %i)  {
; CHECK-LABEL: @test_phi_select_index_non_local(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i32 [[I:%.*]], [[N:%.*]]
; CHECK-NEXT:    br i1 [[CMP]], label [[LAND_LHS_TRUE:%.*]], label [[IF_END:%.*]]
; CHECK:       land.lhs.true:
; CHECK-NEXT:    [[IDXPROM:%.*]] = sext i32 [[I]] to i64
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, ptr [[A:%.*]], i64 [[IDXPROM]]
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i32 [[I]], 1
; CHECK-NEXT:    [[IDXPROM1:%.*]] = sext i32 [[ADD]] to i64
; CHECK-NEXT:    [[ARRAYIDX2:%.*]] = getelementptr inbounds i32, ptr [[A]], i64 [[IDXPROM1]]
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr [[ARRAYIDX2]], align 4
; CHECK-NEXT:    [[CMP3:%.*]] = icmp slt i32 [[TMP0]], [[TMP1]]
; CHECK-NEXT:    [[SPEC_SELECT:%.*]] = select i1 [[CMP3]], i32 [[ADD]], i32 [[I]]
; CHECK-NEXT:    br label [[IF_END]]
; CHECK:       if.end:
; CHECK-NEXT:    [[I_ADDR_0:%.*]] = phi i32 [ [[I]], [[ENTRY:%.*]] ], [ [[SPEC_SELECT]], [[LAND_LHS_TRUE]] ]
; CHECK-NEXT:    [[IDXPROM5:%.*]] = sext i32 [[I_ADDR_0]] to i64
; CHECK-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds i32, ptr [[A]], i64 [[IDXPROM5]]
; CHECK-NEXT:    [[TMP2:%.*]] = load i32, ptr [[ARRAYIDX6]], align 4
; CHECK-NEXT:    ret i32 [[TMP2]]
;
entry:
  %cmp = icmp slt i32 %i, %N
  br i1 %cmp, label %land.lhs.true, label %if.end

land.lhs.true:
  %idxprom = sext i32 %i to i64
  %arrayidx = getelementptr inbounds i32, ptr %A, i64 %idxprom
  %0 = load i32, ptr %arrayidx, align 4
  %add = add nsw i32 %i, 1
  %idxprom1 = sext i32 %add to i64
  %arrayidx2 = getelementptr inbounds i32, ptr %A, i64 %idxprom1
  %1 = load i32, ptr %arrayidx2, align 4
  %cmp3 = icmp slt i32 %0, %1
  %spec.select = select i1 %cmp3, i32 %add, i32 %i
  br label %if.end

if.end:
  %i.addr.0 = phi i32 [ %i, %entry ], [ %spec.select, %land.lhs.true ]
  %idxprom5 = sext i32 %i.addr.0 to i64
  %arrayidx6 = getelementptr inbounds i32, ptr %A, i64 %idxprom5
  %2 = load i32, ptr %arrayidx6, align 4
  ret i32 %2
}

define i32 @test_phi_select_index_loop(ptr %A, i32 %N)  {
; CHECK-LABEL: @test_phi_select_index_loop(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[N:%.*]], 1
; CHECK-NEXT:    br i1 [[CMP]], label [[FOR_BODY_PREHEADER:%.*]], label [[FOR_COND_CLEANUP:%.*]]
; CHECK:       for.body.preheader:
; CHECK-NEXT:    br label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[IDX:%.*]] = phi i32 [ [[IDX_NEXT:%.*]], [[FOR_BODY]] ], [ 1, [[FOR_BODY_PREHEADER]] ]
; CHECK-NEXT:    [[RES:%.*]] = phi i32 [ [[SPEC_SELECT:%.*]], [[FOR_BODY]] ], [ 0, [[FOR_BODY_PREHEADER]] ]
; CHECK-NEXT:    [[IDXPROM:%.*]] = sext i32 [[IDX]] to i64
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, ptr [[A:%.*]], i64 [[IDXPROM]]
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
; CHECK-NEXT:    [[IDXPROM1:%.*]] = sext i32 [[RES]] to i64
; CHECK-NEXT:    [[ARRAYIDX1:%.*]] = getelementptr inbounds i32, ptr [[A]], i64 [[IDXPROM1]]
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr [[ARRAYIDX1]], align 4
; CHECK-NEXT:    [[CMP1:%.*]] = icmp slt i32 [[TMP0]], [[TMP1]]
; CHECK-NEXT:    [[SPEC_SELECT]] = select i1 [[CMP1]], i32 [[IDX]], i32 [[RES]]
; CHECK-NEXT:    [[IDX_NEXT]] = add nsw i32 [[IDX]], 1
; CHECK-NEXT:    [[EXITCOND_NOT:%.*]] = icmp eq i32 [[IDX_NEXT]], [[N]]
; CHECK-NEXT:    br i1 [[EXITCOND_NOT]], label [[FOR_COND_CLEANUP_LOOPEXIT:%.*]], label [[FOR_BODY]]
; CHECK:       for.cond.cleanup.loopexit:
; CHECK-NEXT:    br label [[FOR_COND_CLEANUP]]
; CHECK:       for.cond.cleanup:
; CHECK-NEXT:    [[RES_0_LCSSA:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[SPEC_SELECT]], [[FOR_COND_CLEANUP_LOOPEXIT]] ]
; CHECK-NEXT:    ret i32 [[RES_0_LCSSA]]
;
entry:
  %cmp = icmp sgt i32 %N, 1
  br i1 %cmp, label %for.body, label %for.cond.cleanup

for.body:
  %idx = phi i32 [ 1, %entry ], [ %idx.next, %for.body ]
  %res = phi i32 [ 0, %entry ], [ %spec.select, %for.body ]
  %idxprom = sext i32 %idx to i64
  %arrayidx = getelementptr inbounds i32, ptr %A, i64 %idxprom
  %0 = load i32, ptr %arrayidx, align 4
  %idxprom1 = sext i32 %res to i64
  %arrayidx1 = getelementptr inbounds i32, ptr %A, i64 %idxprom1
  %1 = load i32, ptr %arrayidx1, align 4
  %cmp1 = icmp slt i32 %0, %1
  %spec.select = select i1 %cmp1, i32 %idx, i32 %res
  %idx.next = add nsw i32 %idx, 1
  %exitcond.not = icmp eq i32 %idx.next, %N
  br i1 %exitcond.not, label %for.cond.cleanup, label %for.body

  for.cond.cleanup:
  %res.0.lcssa = phi i32 [ 0, %entry ], [ %spec.select, %for.body ]
  ret i32 %res.0.lcssa
}
