; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -mtriple=nvptx -mcpu=sm_20 -verify-machineinstrs -trap-unreachable=false \
; RUN:     | FileCheck %s --check-prefixes=CHECK,NO-TRAP-UNREACHABLE
; RUN: llc < %s -mtriple=nvptx64 -mcpu=sm_20 -verify-machineinstrs -trap-unreachable=false \
; RUN:     | FileCheck %s --check-prefixes=CHECK,NO-TRAP-UNREACHABLE
; RUN: llc < %s -mtriple=nvptx -mcpu=sm_20 -verify-machineinstrs -trap-unreachable -no-trap-after-noreturn \
; RUN:     | FileCheck %s --check-prefixes=CHECK,NO-TRAP-AFTER-NORETURN
; RUN: llc < %s -mtriple=nvptx64 -mcpu=sm_20 -verify-machineinstrs -trap-unreachable -no-trap-after-noreturn \
; RUN:     | FileCheck %s --check-prefixes=CHECK,NO-TRAP-AFTER-NORETURN
; RUN: llc < %s -mtriple=nvptx -mcpu=sm_20 -verify-machineinstrs -trap-unreachable -no-trap-after-noreturn=false \
; RUN:     | FileCheck %s --check-prefixes=CHECK,TRAP
; RUN: llc < %s -mtriple=nvptx64 -mcpu=sm_20 -verify-machineinstrs -trap-unreachable -no-trap-after-noreturn=false \
; RUN:     | FileCheck %s --check-prefixes=CHECK,TRAP
; RUN: llc < %s -mtriple=nvptx64 -mcpu=sm_20 -verify-machineinstrs -trap-unreachable -mattr=+ptx83 \
; RUN:     | FileCheck %s --check-prefixes=BUG-FIXED
; RUN: %if ptxas && !ptxas-12.0 %{ llc < %s -mtriple=nvptx -mcpu=sm_20 -verify-machineinstrs | %ptxas-verify %}
; RUN: %if ptxas %{ llc < %s -mtriple=nvptx64 -mcpu=sm_20 -verify-machineinstrs | %ptxas-verify %}

target triple = "nvptx-unknown-cuda"

declare void @throw() #0
declare void @llvm.trap() #0

define ptx_kernel void @kernel_func() {
; NO-TRAP-UNREACHABLE-LABEL: kernel_func(
; NO-TRAP-UNREACHABLE:       {
; NO-TRAP-UNREACHABLE-EMPTY:
; NO-TRAP-UNREACHABLE-EMPTY:
; NO-TRAP-UNREACHABLE-NEXT:  // %bb.0:
; NO-TRAP-UNREACHABLE-NEXT:    { // callseq 0, 0
; NO-TRAP-UNREACHABLE-NEXT:    call.uni throw, ();
; NO-TRAP-UNREACHABLE-NEXT:    } // callseq 0
; NO-TRAP-UNREACHABLE-NEXT:    // begin inline asm
; NO-TRAP-UNREACHABLE-NEXT:    exit;
; NO-TRAP-UNREACHABLE-NEXT:    // end inline asm
;
; NO-TRAP-AFTER-NORETURN-LABEL: kernel_func(
; NO-TRAP-AFTER-NORETURN:       {
; NO-TRAP-AFTER-NORETURN-EMPTY:
; NO-TRAP-AFTER-NORETURN-EMPTY:
; NO-TRAP-AFTER-NORETURN-NEXT:  // %bb.0:
; NO-TRAP-AFTER-NORETURN-NEXT:    { // callseq 0, 0
; NO-TRAP-AFTER-NORETURN-NEXT:    call.uni throw, ();
; NO-TRAP-AFTER-NORETURN-NEXT:    } // callseq 0
; NO-TRAP-AFTER-NORETURN-NEXT:    // begin inline asm
; NO-TRAP-AFTER-NORETURN-NEXT:    exit;
; NO-TRAP-AFTER-NORETURN-NEXT:    // end inline asm
; NO-TRAP-AFTER-NORETURN-NEXT:    trap; exit;
;
; TRAP-LABEL: kernel_func(
; TRAP:       {
; TRAP-EMPTY:
; TRAP-EMPTY:
; TRAP-NEXT:  // %bb.0:
; TRAP-NEXT:    { // callseq 0, 0
; TRAP-NEXT:    call.uni throw, ();
; TRAP-NEXT:    } // callseq 0
; TRAP-NEXT:    trap; exit;
;
; BUG-FIXED-LABEL: kernel_func(
; BUG-FIXED:       {
; BUG-FIXED-EMPTY:
; BUG-FIXED-EMPTY:
; BUG-FIXED-NEXT:  // %bb.0:
; BUG-FIXED-NEXT:    { // callseq 0, 0
; BUG-FIXED-NEXT:    call.uni throw, ();
; BUG-FIXED-NEXT:    } // callseq 0
; BUG-FIXED-NEXT:    trap;
  call void @throw()
  unreachable
}

define void @kernel_func_2() {
; CHECK-LABEL: kernel_func_2(
; CHECK:       {
; CHECK-EMPTY:
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    trap; exit;
;
; BUG-FIXED-LABEL: kernel_func_2(
; BUG-FIXED:       {
; BUG-FIXED-EMPTY:
; BUG-FIXED-EMPTY:
; BUG-FIXED-NEXT:  // %bb.0:
; BUG-FIXED-NEXT:    trap;
  call void @llvm.trap()
; Make sure we avoid emitting two trap instructions.
  unreachable
}

attributes #0 = { noreturn }
