; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt -p instsimplify -S %s | FileCheck %s

@glob = external global [314 x i64]

define i1 @known_constexpr_add_eq() {
; CHECK-LABEL: define i1 @known_constexpr_add_eq() {
; CHECK-NEXT:    ret i1 false
;
  %cond = icmp eq ptr getelementptr inbounds nuw (i8, ptr @glob, i64 80), inttoptr (i64 add (i64 ptrtoint (ptr @glob to i64), i64 -80) to ptr)
  ret i1 %cond
}

define i1 @known_constexpr_add_eq_ops_swapped() {
; CHECK-LABEL: define i1 @known_constexpr_add_eq_ops_swapped() {
; CHECK-NEXT:    ret i1 false
;
  %cond = icmp eq ptr inttoptr (i64 add (i64 ptrtoint (ptr @glob to i64), i64 -80) to ptr), getelementptr inbounds nuw (i8, ptr @glob, i64 80)
  ret i1 %cond
}

define i1 @known_constexpr_add_ne() {
; CHECK-LABEL: define i1 @known_constexpr_add_ne() {
; CHECK-NEXT:    ret i1 true
;
  %cond = icmp ne ptr getelementptr inbounds nuw (i8, ptr @glob, i64 80), inttoptr (i64 add (i64 ptrtoint (ptr @glob to i64), i64 -80) to ptr)
  ret i1 %cond
}

define i1 @wrap_positive_to_negate() {
; CHECK-LABEL: define i1 @wrap_positive_to_negate() {
; CHECK-NEXT:    ret i1 false
;
  %cond = icmp eq ptr @glob, inttoptr (i64 add (i64 ptrtoint (ptr getelementptr nuw (i8, ptr @glob, i64 1)to i64), i64 9223372036854775808) to ptr)
  ret i1 %cond
}

; 9223372036854775808 = 2^63
define i1 @wrap_positive_to_zero() {
; CHECK-LABEL: define i1 @wrap_positive_to_zero() {
; CHECK-NEXT:    ret i1 true
;
  %cond = icmp eq ptr @glob, inttoptr (i64 add (i64 ptrtoint (ptr getelementptr nuw (i8, ptr @glob, i64 9223372036854775808)to i64), i64 9223372036854775808) to ptr)
  ret i1 %cond
}

define i1 @not_known_constexpr_add_sle() {
; CHECK-LABEL: define i1 @not_known_constexpr_add_sle() {
; CHECK-NEXT:    [[COND:%.*]] = icmp sle ptr @glob, inttoptr (i64 add (i64 ptrtoint (ptr @glob to i64), i64 -80) to ptr)
; CHECK-NEXT:    ret i1 [[COND]]
;
  %cond = icmp sle ptr @glob, inttoptr (i64 add (i64 ptrtoint (ptr @glob to i64), i64 -80) to ptr)
  ret i1 %cond
}

define i1 @not_known_constexpr_add_ule() {
; CHECK-LABEL: define i1 @not_known_constexpr_add_ule() {
; CHECK-NEXT:    [[COND:%.*]] = icmp ule ptr @glob, inttoptr (i64 add (i64 ptrtoint (ptr @glob to i64), i64 -80) to ptr)
; CHECK-NEXT:    ret i1 [[COND]]
;
  %cond = icmp ule ptr @glob, inttoptr (i64 add (i64 ptrtoint (ptr @glob to i64), i64 -80) to ptr)
  ret i1 %cond
}

define i1 @not_known_constexpr_add_sge() {
; CHECK-LABEL: define i1 @not_known_constexpr_add_sge() {
; CHECK-NEXT:    [[COND:%.*]] = icmp sge ptr @glob, inttoptr (i64 add (i64 ptrtoint (ptr @glob to i64), i64 -80) to ptr)
; CHECK-NEXT:    ret i1 [[COND]]
;
  %cond = icmp sge ptr @glob, inttoptr (i64 add (i64 ptrtoint (ptr @glob to i64), i64 -80) to ptr)
  ret i1 %cond
}

define i1 @not_known_constexpr_add_uge() {
; CHECK-LABEL: define i1 @not_known_constexpr_add_uge() {
; CHECK-NEXT:    [[COND:%.*]] = icmp uge ptr @glob, inttoptr (i64 add (i64 ptrtoint (ptr @glob to i64), i64 -80) to ptr)
; CHECK-NEXT:    ret i1 [[COND]]
;
  %cond = icmp uge ptr @glob, inttoptr (i64 add (i64 ptrtoint (ptr @glob to i64), i64 -80) to ptr)
  ret i1 %cond
}

define i1 @not_known_integer_width_does_not_match_pointer_index_width() {
; CHECK-LABEL: define i1 @not_known_integer_width_does_not_match_pointer_index_width() {
; CHECK-NEXT:    [[COND:%.*]] = icmp eq ptr getelementptr inbounds nuw (i8, ptr @glob, i64 80), inttoptr (i32 add (i32 ptrtoint (ptr @glob to i32), i32 -80) to ptr)
; CHECK-NEXT:    ret i1 [[COND]]
;
  %cond = icmp eq ptr getelementptr inbounds nuw (i8, ptr @glob, i64 80), inttoptr (i32 add (i32 ptrtoint (ptr @glob to i32), i32 -80) to ptr)
  ret i1 %cond
}

define ptr @return_inttoptr() {
; CHECK-LABEL: define ptr @return_inttoptr() {
; CHECK-NEXT:    ret ptr inttoptr (i64 add (i64 ptrtoint (ptr @glob to i64), i64 8) to ptr)
;
  ret ptr inttoptr (i64 add (i64 ptrtoint (ptr @glob to i64), i64 8) to ptr)
}

define i1 @known_constexpr_add_nested_1() {
; CHECK-LABEL: define i1 @known_constexpr_add_nested_1() {
; CHECK-NEXT:    ret i1 true
;
  %cond = icmp eq ptr @glob, inttoptr (i64 add (i64 ptrtoint (ptr getelementptr inbounds nuw (i8, ptr @glob, i64 80) to i64), i64 -80) to ptr)
  ret i1 %cond
}

define i1 @known_constexpr_add_nested_2() {
; CHECK-LABEL: define i1 @known_constexpr_add_nested_2() {
; CHECK-NEXT:    ret i1 true
;
  ;%cond = icmp eq ptr @glob, ptr getelementptr inbounds nuw (i8, ptr inttoptr (i64 add (i64 ptrtoint (ptr @glob to i64), i64 -80) to ptr), i64 80)
  %cond = icmp eq ptr @glob, getelementptr inbounds nuw (i8, ptr inttoptr (i64 add (i64 ptrtoint (ptr @glob to i64), i64 -80) to ptr), i64 80)
  ret i1 %cond
}
