; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s --data-layout "e" -passes=dse -enable-dse-partial-store-merging=true -S | FileCheck %s
; RUN: opt < %s --data-layout "E" -passes=dse -enable-dse-partial-store-merging=true -S | FileCheck %s

; This test used to hit an assertion (see PR41949).
;
; Better safe than sorry, do not assume anything about the padding for the
; i28 store that has 32 bits as store size.
define void @test1(ptr %p) {
; CHECK-LABEL: @test1(
; CHECK-NEXT:    [[A:%.*]] = alloca i32
; CHECK-NEXT:    [[C1:%.*]] = getelementptr inbounds { i16, i16 }, ptr [[A]], i32 0, i32 1
; CHECK-NEXT:    store i28 10, ptr [[A]]
; CHECK-NEXT:    store i16 20, ptr [[C1]]
; CHECK-NEXT:    call void @test1(ptr [[A]])
; CHECK-NEXT:    ret void
;
  %a = alloca i32
  %c1 = getelementptr inbounds { i16, i16 }, ptr %a, i32 0, i32 1
  store i28 10, ptr %a
  store i16 20, ptr %c1

  call void @test1(ptr %a)
  ret void
}


; This test used to mis-compile (see PR41949).
;
; Better safe than sorry, do not assume anything about the padding for the
; i12 store that has 16 bits as store size.
define void @test2(ptr %p) {
; CHECK-LABEL: @test2(
; CHECK-NEXT:    [[U:%.*]] = alloca i32
; CHECK-NEXT:    store i32 -1, ptr [[U]]
; CHECK-NEXT:    store i12 20, ptr [[U]]
; CHECK-NEXT:    call void @test2(ptr [[U]])
; CHECK-NEXT:    ret void
;
  %u = alloca i32
  store i32 -1, ptr %u
  store i12 20, ptr %u

  call void @test2(ptr %u)
  ret void
}

