; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instsimplify -S | FileCheck %s
target datalayout = "p:32:32-p1:64:64"

; This is a collection of tests checking whether we can prove pointers
; derived from two allocas as inequal *via offset checks*.  Note that
; instcombine has alternate approaches (one cmp rule, and compare
; bases of common offset) that also handles these, but with different
; logic.

; %a follows %b, derived equal
define i1 @adjacent_alloca() {
; CHECK-LABEL: @adjacent_alloca(
; CHECK-NEXT:    [[A:%.*]] = alloca i8, i32 4, align 1
; CHECK-NEXT:    [[B:%.*]] = alloca i8, i32 4, align 1
; CHECK-NEXT:    [[B_OFF:%.*]] = getelementptr i8, ptr [[B]], i64 4
; CHECK-NEXT:    [[RES:%.*]] = icmp ne ptr [[A]], [[B_OFF]]
; CHECK-NEXT:    ret i1 [[RES]]
;
  %a = alloca i8, i32 4
  %b = alloca i8, i32 4
  %b.off = getelementptr i8, ptr %b, i64 4
  %res = icmp ne ptr %a, %b.off
  ret i1 %res
}

; %b follows %a, derived equal
define i1 @adjacent_alloca2() 