; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt -passes="print<cost-model>" 2>&1 -disable-output -mtriple=riscv64 -mattr=+v,+f,+d,+zfh,+zvfh < %s | FileCheck %s
; Check that we don't crash querying costs when vectors are not enabled.
; RUN: opt -passes="print<cost-model>" 2>&1 -disable-output -mtriple=riscv64

define void @icmp_eq() {
; CHECK-LABEL: 'icmp_eq'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i8 = icmp eq <2 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i8 = icmp eq <4 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i8 = icmp eq <8 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i8 = icmp eq <16 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32i8 = icmp eq <32 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1i8 = icmp eq <vscale x 1 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i8 = icmp eq <vscale x 2 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4i8 = icmp eq <vscale x 4 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv8i8 = icmp eq <vscale x 8 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16i8 = icmp eq <vscale x 16 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv32i8 = icmp eq <vscale x 32 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i16 = icmp eq <2 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i16 = icmp eq <4 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i16 = icmp eq <8 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16i16 = icmp eq <16 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1i16 = icmp eq <vscale x 1 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i16 = icmp eq <vscale x 2 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4i16 = icmp eq <vscale x 4 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8i16 = icmp eq <vscale x 8 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv16i16 = icmp eq <vscale x 16 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i32 = icmp eq <2 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i32 = icmp eq <4 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8i32 = icmp eq <8 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v16i32 = icmp eq <16 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1i32 = icmp eq <vscale x 1 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i32 = icmp eq <vscale x 2 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4i32 = icmp eq <vscale x 4 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv8i32 = icmp eq <vscale x 8 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %nxv16i32 = icmp eq <vscale x 16 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i64 = icmp eq <2 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i64 = icmp eq <4 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v8i64 = icmp eq <8 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1i64 = icmp eq <vscale x 1 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2i64 = icmp eq <vscale x 2 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv4i64 = icmp eq <vscale x 4 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %nxv8i64 = icmp eq <vscale x 8 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  %v2i8 = icmp eq <2 x i8> undef, undef
  %v4i8 = icmp eq <4 x i8> undef, undef
  %v8i8 = icmp eq <8 x i8> undef, undef
  %v16i8 = icmp eq <16 x i8> undef, undef
  %v32i8 = icmp eq <32 x i8> undef, undef

  %nxv1i8 = icmp eq <vscale x 1 x i8> undef, undef
  %nxv2i8 = icmp eq <vscale x 2 x i8> undef, undef
  %nxv4i8 = icmp eq <vscale x 4 x i8> undef, undef
  %nxv8i8 = icmp eq <vscale x 8 x i8> undef, undef
  %nxv16i8 = icmp eq <vscale x 16 x i8> undef, undef
  %nxv32i8 = icmp eq <vscale x 32 x i8> undef, undef

  %v2i16 = icmp eq <2 x i16> undef, undef
  %v4i16 = icmp eq <4 x i16> undef, undef
  %v8i16 = icmp eq <8 x i16> undef, undef
  %v16i16 = icmp eq <16 x i16> undef, undef

  %nxv1i16 = icmp eq <vscale x 1 x i16> undef, undef
  %nxv2i16 = icmp eq <vscale x 2 x i16> undef, undef
  %nxv4i16 = icmp eq <vscale x 4 x i16> undef, undef
  %nxv8i16 = icmp eq <vscale x 8 x i16> undef, undef
  %nxv16i16 = icmp eq <vscale x 16 x i16> undef, undef

  %v2i32 = icmp eq <2 x i32> undef, undef
  %v4i32 = icmp eq <4 x i32> undef, undef
  %v8i32 = icmp eq <8 x i32> undef, undef
  %v16i32 = icmp eq <16 x i32> undef, undef

  %nxv1i32 = icmp eq <vscale x 1 x i32> undef, undef
  %nxv2i32 = icmp eq <vscale x 2 x i32> undef, undef
  %nxv4i32 = icmp eq <vscale x 4 x i32> undef, undef
  %nxv8i32 = icmp eq <vscale x 8 x i32> undef, undef
  %nxv16i32 = icmp eq <vscale x 16 x i32> undef, undef

  %v2i64 = icmp eq <2 x i64> undef, undef
  %v4i64 = icmp eq <4 x i64> undef, undef
  %v8i64 = icmp eq <8 x i64> undef, undef

  %nxv1i64 = icmp eq <vscale x 1 x i64> undef, undef
  %nxv2i64 = icmp eq <vscale x 2 x i64> undef, undef
  %nxv4i64 = icmp eq <vscale x 4 x i64> undef, undef
  %nxv8i64 = icmp eq <vscale x 8 x i64> undef, undef

  ret void
}

define void @icmp_ne() {
; CHECK-LABEL: 'icmp_ne'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i8 = icmp ne <2 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i8 = icmp ne <4 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i8 = icmp ne <8 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i8 = icmp ne <16 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32i8 = icmp ne <32 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1i8 = icmp ne <vscale x 1 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i8 = icmp ne <vscale x 2 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4i8 = icmp ne <vscale x 4 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv8i8 = icmp ne <vscale x 8 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16i8 = icmp ne <vscale x 16 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv32i8 = icmp ne <vscale x 32 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i16 = icmp ne <2 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i16 = icmp ne <4 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i16 = icmp ne <8 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16i16 = icmp ne <16 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1i16 = icmp ne <vscale x 1 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i16 = icmp ne <vscale x 2 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4i16 = icmp ne <vscale x 4 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8i16 = icmp ne <vscale x 8 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv16i16 = icmp ne <vscale x 16 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i32 = icmp ne <2 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i32 = icmp ne <4 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8i32 = icmp ne <8 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v16i32 = icmp ne <16 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1i32 = icmp ne <vscale x 1 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i32 = icmp ne <vscale x 2 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4i32 = icmp ne <vscale x 4 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv8i32 = icmp ne <vscale x 8 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %nxv16i32 = icmp ne <vscale x 16 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i64 = icmp ne <2 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i64 = icmp ne <4 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v8i64 = icmp ne <8 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1i64 = icmp ne <vscale x 1 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2i64 = icmp ne <vscale x 2 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv4i64 = icmp ne <vscale x 4 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %nxv8i64 = icmp ne <vscale x 8 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  %v2i8 = icmp ne <2 x i8> undef, undef
  %v4i8 = icmp ne <4 x i8> undef, undef
  %v8i8 = icmp ne <8 x i8> undef, undef
  %v16i8 = icmp ne <16 x i8> undef, undef
  %v32i8 = icmp ne <32 x i8> undef, undef

  %nxv1i8 = icmp ne <vscale x 1 x i8> undef, undef
  %nxv2i8 = icmp ne <vscale x 2 x i8> undef, undef
  %nxv4i8 = icmp ne <vscale x 4 x i8> undef, undef
  %nxv8i8 = icmp ne <vscale x 8 x i8> undef, undef
  %nxv16i8 = icmp ne <vscale x 16 x i8> undef, undef
  %nxv32i8 = icmp ne <vscale x 32 x i8> undef, undef

  %v2i16 = icmp ne <2 x i16> undef, undef
  %v4i16 = icmp ne <4 x i16> undef, undef
  %v8i16 = icmp ne <8 x i16> undef, undef
  %v16i16 = icmp ne <16 x i16> undef, undef

  %nxv1i16 = icmp ne <vscale x 1 x i16> undef, undef
  %nxv2i16 = icmp ne <vscale x 2 x i16> undef, undef
  %nxv4i16 = icmp ne <vscale x 4 x i16> undef, undef
  %nxv8i16 = icmp ne <vscale x 8 x i16> undef, undef
  %nxv16i16 = icmp ne <vscale x 16 x i16> undef, undef

  %v2i32 = icmp ne <2 x i32> undef, undef
  %v4i32 = icmp ne <4 x i32> undef, undef
  %v8i32 = icmp ne <8 x i32> undef, undef
  %v16i32 = icmp ne <16 x i32> undef, undef

  %nxv1i32 = icmp ne <vscale x 1 x i32> undef, undef
  %nxv2i32 = icmp ne <vscale x 2 x i32> undef, undef
  %nxv4i32 = icmp ne <vscale x 4 x i32> undef, undef
  %nxv8i32 = icmp ne <vscale x 8 x i32> undef, undef
  %nxv16i32 = icmp ne <vscale x 16 x i32> undef, undef

  %v2i64 = icmp ne <2 x i64> undef, undef
  %v4i64 = icmp ne <4 x i64> undef, undef
  %v8i64 = icmp ne <8 x i64> undef, undef

  %nxv1i64 = icmp ne <vscale x 1 x i64> undef, undef
  %nxv2i64 = icmp ne <vscale x 2 x i64> undef, undef
  %nxv4i64 = icmp ne <vscale x 4 x i64> undef, undef
  %nxv8i64 = icmp ne <vscale x 8 x i64> undef, undef

  ret void
}

define void @icmp_ugt() {
; CHECK-LABEL: 'icmp_ugt'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i8 = icmp ugt <2 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i8 = icmp ugt <4 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i8 = icmp ugt <8 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i8 = icmp ugt <16 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32i8 = icmp ugt <32 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1i8 = icmp ugt <vscale x 1 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i8 = icmp ugt <vscale x 2 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4i8 = icmp ugt <vscale x 4 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv8i8 = icmp ugt <vscale x 8 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16i8 = icmp ugt <vscale x 16 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv32i8 = icmp ugt <vscale x 32 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i16 = icmp ugt <2 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i16 = icmp ugt <4 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i16 = icmp ugt <8 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16i16 = icmp ugt <16 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1i16 = icmp ugt <vscale x 1 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i16 = icmp ugt <vscale x 2 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4i16 = icmp ugt <vscale x 4 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8i16 = icmp ugt <vscale x 8 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv16i16 = icmp ugt <vscale x 16 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i32 = icmp ugt <2 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i32 = icmp ugt <4 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8i32 = icmp ugt <8 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v16i32 = icmp ugt <16 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1i32 = icmp ugt <vscale x 1 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i32 = icmp ugt <vscale x 2 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4i32 = icmp ugt <vscale x 4 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv8i32 = icmp ugt <vscale x 8 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %nxv16i32 = icmp ugt <vscale x 16 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i64 = icmp ugt <2 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i64 = icmp ugt <4 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v8i64 = icmp ugt <8 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1i64 = icmp ugt <vscale x 1 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2i64 = icmp ugt <vscale x 2 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv4i64 = icmp ugt <vscale x 4 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %nxv8i64 = icmp ugt <vscale x 8 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  %v2i8 = icmp ugt <2 x i8> undef, undef
  %v4i8 = icmp ugt <4 x i8> undef, undef
  %v8i8 = icmp ugt <8 x i8> undef, undef
  %v16i8 = icmp ugt <16 x i8> undef, undef
  %v32i8 = icmp ugt <32 x i8> undef, undef

  %nxv1i8 = icmp ugt <vscale x 1 x i8> undef, undef
  %nxv2i8 = icmp ugt <vscale x 2 x i8> undef, undef
  %nxv4i8 = icmp ugt <vscale x 4 x i8> undef, undef
  %nxv8i8 = icmp ugt <vscale x 8 x i8> undef, undef
  %nxv16i8 = icmp ugt <vscale x 16 x i8> undef, undef
  %nxv32i8 = icmp ugt <vscale x 32 x i8> undef, undef

  %v2i16 = icmp ugt <2 x i16> undef, undef
  %v4i16 = icmp ugt <4 x i16> undef, undef
  %v8i16 = icmp ugt <8 x i16> undef, undef
  %v16i16 = icmp ugt <16 x i16> undef, undef

  %nxv1i16 = icmp ugt <vscale x 1 x i16> undef, undef
  %nxv2i16 = icmp ugt <vscale x 2 x i16> undef, undef
  %nxv4i16 = icmp ugt <vscale x 4 x i16> undef, undef
  %nxv8i16 = icmp ugt <vscale x 8 x i16> undef, undef
  %nxv16i16 = icmp ugt <vscale x 16 x i16> undef, undef

  %v2i32 = icmp ugt <2 x i32> undef, undef
  %v4i32 = icmp ugt <4 x i32> undef, undef
  %v8i32 = icmp ugt <8 x i32> undef, undef
  %v16i32 = icmp ugt <16 x i32> undef, undef

  %nxv1i32 = icmp ugt <vscale x 1 x i32> undef, undef
  %nxv2i32 = icmp ugt <vscale x 2 x i32> undef, undef
  %nxv4i32 = icmp ugt <vscale x 4 x i32> undef, undef
  %nxv8i32 = icmp ugt <vscale x 8 x i32> undef, undef
  %nxv16i32 = icmp ugt <vscale x 16 x i32> undef, undef

  %v2i64 = icmp ugt <2 x i64> undef, undef
  %v4i64 = icmp ugt <4 x i64> undef, undef
  %v8i64 = icmp ugt <8 x i64> undef, undef

  %nxv1i64 = icmp ugt <vscale x 1 x i64> undef, undef
  %nxv2i64 = icmp ugt <vscale x 2 x i64> undef, undef
  %nxv4i64 = icmp ugt <vscale x 4 x i64> undef, undef
  %nxv8i64 = icmp ugt <vscale x 8 x i64> undef, undef

  ret void
}

define void @icmp_uge() {
; CHECK-LABEL: 'icmp_uge'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i8 = icmp uge <2 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i8 = icmp uge <4 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i8 = icmp uge <8 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i8 = icmp uge <16 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32i8 = icmp uge <32 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1i8 = icmp uge <vscale x 1 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i8 = icmp uge <vscale x 2 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4i8 = icmp uge <vscale x 4 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv8i8 = icmp uge <vscale x 8 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16i8 = icmp uge <vscale x 16 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv32i8 = icmp uge <vscale x 32 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i16 = icmp uge <2 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i16 = icmp uge <4 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i16 = icmp uge <8 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16i16 = icmp uge <16 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1i16 = icmp uge <vscale x 1 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i16 = icmp uge <vscale x 2 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4i16 = icmp uge <vscale x 4 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8i16 = icmp uge <vscale x 8 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv16i16 = icmp uge <vscale x 16 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i32 = icmp uge <2 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i32 = icmp uge <4 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8i32 = icmp uge <8 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v16i32 = icmp uge <16 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1i32 = icmp uge <vscale x 1 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i32 = icmp uge <vscale x 2 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4i32 = icmp uge <vscale x 4 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv8i32 = icmp uge <vscale x 8 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %nxv16i32 = icmp uge <vscale x 16 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i64 = icmp uge <2 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i64 = icmp uge <4 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v8i64 = icmp uge <8 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1i64 = icmp uge <vscale x 1 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2i64 = icmp uge <vscale x 2 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv4i64 = icmp uge <vscale x 4 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %nxv8i64 = icmp uge <vscale x 8 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  %v2i8 = icmp uge <2 x i8> undef, undef
  %v4i8 = icmp uge <4 x i8> undef, undef
  %v8i8 = icmp uge <8 x i8> undef, undef
  %v16i8 = icmp uge <16 x i8> undef, undef
  %v32i8 = icmp uge <32 x i8> undef, undef

  %nxv1i8 = icmp uge <vscale x 1 x i8> undef, undef
  %nxv2i8 = icmp uge <vscale x 2 x i8> undef, undef
  %nxv4i8 = icmp uge <vscale x 4 x i8> undef, undef
  %nxv8i8 = icmp uge <vscale x 8 x i8> undef, undef
  %nxv16i8 = icmp uge <vscale x 16 x i8> undef, undef
  %nxv32i8 = icmp uge <vscale x 32 x i8> undef, undef

  %v2i16 = icmp uge <2 x i16> undef, undef
  %v4i16 = icmp uge <4 x i16> undef, undef
  %v8i16 = icmp uge <8 x i16> undef, undef
  %v16i16 = icmp uge <16 x i16> undef, undef

  %nxv1i16 = icmp uge <vscale x 1 x i16> undef, undef
  %nxv2i16 = icmp uge <vscale x 2 x i16> undef, undef
  %nxv4i16 = icmp uge <vscale x 4 x i16> undef, undef
  %nxv8i16 = icmp uge <vscale x 8 x i16> undef, undef
  %nxv16i16 = icmp uge <vscale x 16 x i16> undef, undef

  %v2i32 = icmp uge <2 x i32> undef, undef
  %v4i32 = icmp uge <4 x i32> undef, undef
  %v8i32 = icmp uge <8 x i32> undef, undef
  %v16i32 = icmp uge <16 x i32> undef, undef

  %nxv1i32 = icmp uge <vscale x 1 x i32> undef, undef
  %nxv2i32 = icmp uge <vscale x 2 x i32> undef, undef
  %nxv4i32 = icmp uge <vscale x 4 x i32> undef, undef
  %nxv8i32 = icmp uge <vscale x 8 x i32> undef, undef
  %nxv16i32 = icmp uge <vscale x 16 x i32> undef, undef

  %v2i64 = icmp uge <2 x i64> undef, undef
  %v4i64 = icmp uge <4 x i64> undef, undef
  %v8i64 = icmp uge <8 x i64> undef, undef

  %nxv1i64 = icmp uge <vscale x 1 x i64> undef, undef
  %nxv2i64 = icmp uge <vscale x 2 x i64> undef, undef
  %nxv4i64 = icmp uge <vscale x 4 x i64> undef, undef
  %nxv8i64 = icmp uge <vscale x 8 x i64> undef, undef

  ret void
}

define void @icmp_ult() {
; CHECK-LABEL: 'icmp_ult'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i8 = icmp ult <2 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i8 = icmp ult <4 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i8 = icmp ult <8 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i8 = icmp ult <16 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32i8 = icmp ult <32 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1i8 = icmp ult <vscale x 1 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i8 = icmp ult <vscale x 2 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4i8 = icmp ult <vscale x 4 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv8i8 = icmp ult <vscale x 8 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16i8 = icmp ult <vscale x 16 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv32i8 = icmp ult <vscale x 32 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i16 = icmp ult <2 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i16 = icmp ult <4 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i16 = icmp ult <8 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16i16 = icmp ult <16 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1i16 = icmp ult <vscale x 1 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i16 = icmp ult <vscale x 2 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4i16 = icmp ult <vscale x 4 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8i16 = icmp ult <vscale x 8 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv16i16 = icmp ult <vscale x 16 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i32 = icmp ult <2 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i32 = icmp ult <4 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8i32 = icmp ult <8 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v16i32 = icmp ult <16 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1i32 = icmp ult <vscale x 1 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i32 = icmp ult <vscale x 2 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4i32 = icmp ult <vscale x 4 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv8i32 = icmp ult <vscale x 8 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %nxv16i32 = icmp ult <vscale x 16 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i64 = icmp ult <2 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i64 = icmp ult <4 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v8i64 = icmp ult <8 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1i64 = icmp ult <vscale x 1 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2i64 = icmp ult <vscale x 2 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv4i64 = icmp ult <vscale x 4 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %nxv8i64 = icmp ult <vscale x 8 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  %v2i8 = icmp ult <2 x i8> undef, undef
  %v4i8 = icmp ult <4 x i8> undef, undef
  %v8i8 = icmp ult <8 x i8> undef, undef
  %v16i8 = icmp ult <16 x i8> undef, undef
  %v32i8 = icmp ult <32 x i8> undef, undef

  %nxv1i8 = icmp ult <vscale x 1 x i8> undef, undef
  %nxv2i8 = icmp ult <vscale x 2 x i8> undef, undef
  %nxv4i8 = icmp ult <vscale x 4 x i8> undef, undef
  %nxv8i8 = icmp ult <vscale x 8 x i8> undef, undef
  %nxv16i8 = icmp ult <vscale x 16 x i8> undef, undef
  %nxv32i8 = icmp ult <vscale x 32 x i8> undef, undef

  %v2i16 = icmp ult <2 x i16> undef, undef
  %v4i16 = icmp ult <4 x i16> undef, undef
  %v8i16 = icmp ult <8 x i16> undef, undef
  %v16i16 = icmp ult <16 x i16> undef, undef

  %nxv1i16 = icmp ult <vscale x 1 x i16> undef, undef
  %nxv2i16 = icmp ult <vscale x 2 x i16> undef, undef
  %nxv4i16 = icmp ult <vscale x 4 x i16> undef, undef
  %nxv8i16 = icmp ult <vscale x 8 x i16> undef, undef
  %nxv16i16 = icmp ult <vscale x 16 x i16> undef, undef

  %v2i32 = icmp ult <2 x i32> undef, undef
  %v4i32 = icmp ult <4 x i32> undef, undef
  %v8i32 = icmp ult <8 x i32> undef, undef
  %v16i32 = icmp ult <16 x i32> undef, undef

  %nxv1i32 = icmp ult <vscale x 1 x i32> undef, undef
  %nxv2i32 = icmp ult <vscale x 2 x i32> undef, undef
  %nxv4i32 = icmp ult <vscale x 4 x i32> undef, undef
  %nxv8i32 = icmp ult <vscale x 8 x i32> undef, undef
  %nxv16i32 = icmp ult <vscale x 16 x i32> undef, undef

  %v2i64 = icmp ult <2 x i64> undef, undef
  %v4i64 = icmp ult <4 x i64> undef, undef
  %v8i64 = icmp ult <8 x i64> undef, undef

  %nxv1i64 = icmp ult <vscale x 1 x i64> undef, undef
  %nxv2i64 = icmp ult <vscale x 2 x i64> undef, undef
  %nxv4i64 = icmp ult <vscale x 4 x i64> undef, undef
  %nxv8i64 = icmp ult <vscale x 8 x i64> undef, undef

  ret void
}

define void @icmp_ule() {
; CHECK-LABEL: 'icmp_ule'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i8 = icmp ule <2 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i8 = icmp ule <4 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i8 = icmp ule <8 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i8 = icmp ule <16 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32i8 = icmp ule <32 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1i8 = icmp ule <vscale x 1 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i8 = icmp ule <vscale x 2 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4i8 = icmp ule <vscale x 4 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv8i8 = icmp ule <vscale x 8 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16i8 = icmp ule <vscale x 16 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv32i8 = icmp ule <vscale x 32 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i16 = icmp ule <2 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i16 = icmp ule <4 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i16 = icmp ule <8 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16i16 = icmp ule <16 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1i16 = icmp ule <vscale x 1 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i16 = icmp ule <vscale x 2 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4i16 = icmp ule <vscale x 4 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8i16 = icmp ule <vscale x 8 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv16i16 = icmp ule <vscale x 16 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i32 = icmp ule <2 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i32 = icmp ule <4 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8i32 = icmp ule <8 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v16i32 = icmp ule <16 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1i32 = icmp ule <vscale x 1 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i32 = icmp ule <vscale x 2 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4i32 = icmp ule <vscale x 4 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv8i32 = icmp ule <vscale x 8 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %nxv16i32 = icmp ule <vscale x 16 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i64 = icmp ule <2 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i64 = icmp ule <4 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v8i64 = icmp ule <8 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1i64 = icmp ule <vscale x 1 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2i64 = icmp ule <vscale x 2 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv4i64 = icmp ule <vscale x 4 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %nxv8i64 = icmp ule <vscale x 8 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  %v2i8 = icmp ule <2 x i8> undef, undef
  %v4i8 = icmp ule <4 x i8> undef, undef
  %v8i8 = icmp ule <8 x i8> undef, undef
  %v16i8 = icmp ule <16 x i8> undef, undef
  %v32i8 = icmp ule <32 x i8> undef, undef

  %nxv1i8 = icmp ule <vscale x 1 x i8> undef, undef
  %nxv2i8 = icmp ule <vscale x 2 x i8> undef, undef
  %nxv4i8 = icmp ule <vscale x 4 x i8> undef, undef
  %nxv8i8 = icmp ule <vscale x 8 x i8> undef, undef
  %nxv16i8 = icmp ule <vscale x 16 x i8> undef, undef
  %nxv32i8 = icmp ule <vscale x 32 x i8> undef, undef

  %v2i16 = icmp ule <2 x i16> undef, undef
  %v4i16 = icmp ule <4 x i16> undef, undef
  %v8i16 = icmp ule <8 x i16> undef, undef
  %v16i16 = icmp ule <16 x i16> undef, undef

  %nxv1i16 = icmp ule <vscale x 1 x i16> undef, undef
  %nxv2i16 = icmp ule <vscale x 2 x i16> undef, undef
  %nxv4i16 = icmp ule <vscale x 4 x i16> undef, undef
  %nxv8i16 = icmp ule <vscale x 8 x i16> undef, undef
  %nxv16i16 = icmp ule <vscale x 16 x i16> undef, undef

  %v2i32 = icmp ule <2 x i32> undef, undef
  %v4i32 = icmp ule <4 x i32> undef, undef
  %v8i32 = icmp ule <8 x i32> undef, undef
  %v16i32 = icmp ule <16 x i32> undef, undef

  %nxv1i32 = icmp ule <vscale x 1 x i32> undef, undef
  %nxv2i32 = icmp ule <vscale x 2 x i32> undef, undef
  %nxv4i32 = icmp ule <vscale x 4 x i32> undef, undef
  %nxv8i32 = icmp ule <vscale x 8 x i32> undef, undef
  %nxv16i32 = icmp ule <vscale x 16 x i32> undef, undef

  %v2i64 = icmp ule <2 x i64> undef, undef
  %v4i64 = icmp ule <4 x i64> undef, undef
  %v8i64 = icmp ule <8 x i64> undef, undef

  %nxv1i64 = icmp ule <vscale x 1 x i64> undef, undef
  %nxv2i64 = icmp ule <vscale x 2 x i64> undef, undef
  %nxv4i64 = icmp ule <vscale x 4 x i64> undef, undef
  %nxv8i64 = icmp ule <vscale x 8 x i64> undef, undef

  ret void
}

define void @icmp_sgt() {
; CHECK-LABEL: 'icmp_sgt'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i8 = icmp sgt <2 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i8 = icmp sgt <4 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i8 = icmp sgt <8 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i8 = icmp sgt <16 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32i8 = icmp sgt <32 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1i8 = icmp sgt <vscale x 1 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i8 = icmp sgt <vscale x 2 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4i8 = icmp sgt <vscale x 4 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv8i8 = icmp sgt <vscale x 8 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16i8 = icmp sgt <vscale x 16 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv32i8 = icmp sgt <vscale x 32 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i16 = icmp sgt <2 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i16 = icmp sgt <4 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i16 = icmp sgt <8 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16i16 = icmp sgt <16 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1i16 = icmp sgt <vscale x 1 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i16 = icmp sgt <vscale x 2 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4i16 = icmp sgt <vscale x 4 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8i16 = icmp sgt <vscale x 8 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv16i16 = icmp sgt <vscale x 16 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i32 = icmp sgt <2 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i32 = icmp sgt <4 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8i32 = icmp sgt <8 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v16i32 = icmp sgt <16 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1i32 = icmp sgt <vscale x 1 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i32 = icmp sgt <vscale x 2 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4i32 = icmp sgt <vscale x 4 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv8i32 = icmp sgt <vscale x 8 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %nxv16i32 = icmp sgt <vscale x 16 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i64 = icmp sgt <2 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i64 = icmp sgt <4 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v8i64 = icmp sgt <8 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1i64 = icmp sgt <vscale x 1 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2i64 = icmp sgt <vscale x 2 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv4i64 = icmp sgt <vscale x 4 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %nxv8i64 = icmp sgt <vscale x 8 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  %v2i8 = icmp sgt <2 x i8> undef, undef
  %v4i8 = icmp sgt <4 x i8> undef, undef
  %v8i8 = icmp sgt <8 x i8> undef, undef
  %v16i8 = icmp sgt <16 x i8> undef, undef
  %v32i8 = icmp sgt <32 x i8> undef, undef

  %nxv1i8 = icmp sgt <vscale x 1 x i8> undef, undef
  %nxv2i8 = icmp sgt <vscale x 2 x i8> undef, undef
  %nxv4i8 = icmp sgt <vscale x 4 x i8> undef, undef
  %nxv8i8 = icmp sgt <vscale x 8 x i8> undef, undef
  %nxv16i8 = icmp sgt <vscale x 16 x i8> undef, undef
  %nxv32i8 = icmp sgt <vscale x 32 x i8> undef, undef

  %v2i16 = icmp sgt <2 x i16> undef, undef
  %v4i16 = icmp sgt <4 x i16> undef, undef
  %v8i16 = icmp sgt <8 x i16> undef, undef
  %v16i16 = icmp sgt <16 x i16> undef, undef

  %nxv1i16 = icmp sgt <vscale x 1 x i16> undef, undef
  %nxv2i16 = icmp sgt <vscale x 2 x i16> undef, undef
  %nxv4i16 = icmp sgt <vscale x 4 x i16> undef, undef
  %nxv8i16 = icmp sgt <vscale x 8 x i16> undef, undef
  %nxv16i16 = icmp sgt <vscale x 16 x i16> undef, undef

  %v2i32 = icmp sgt <2 x i32> undef, undef
  %v4i32 = icmp sgt <4 x i32> undef, undef
  %v8i32 = icmp sgt <8 x i32> undef, undef
  %v16i32 = icmp sgt <16 x i32> undef, undef

  %nxv1i32 = icmp sgt <vscale x 1 x i32> undef, undef
  %nxv2i32 = icmp sgt <vscale x 2 x i32> undef, undef
  %nxv4i32 = icmp sgt <vscale x 4 x i32> undef, undef
  %nxv8i32 = icmp sgt <vscale x 8 x i32> undef, undef
  %nxv16i32 = icmp sgt <vscale x 16 x i32> undef, undef

  %v2i64 = icmp sgt <2 x i64> undef, undef
  %v4i64 = icmp sgt <4 x i64> undef, undef
  %v8i64 = icmp sgt <8 x i64> undef, undef

  %nxv1i64 = icmp sgt <vscale x 1 x i64> undef, undef
  %nxv2i64 = icmp sgt <vscale x 2 x i64> undef, undef
  %nxv4i64 = icmp sgt <vscale x 4 x i64> undef, undef
  %nxv8i64 = icmp sgt <vscale x 8 x i64> undef, undef

  ret void
}

define void @icmp_sge() {
; CHECK-LABEL: 'icmp_sge'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i8 = icmp sge <2 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i8 = icmp sge <4 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i8 = icmp sge <8 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i8 = icmp sge <16 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32i8 = icmp sge <32 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1i8 = icmp sge <vscale x 1 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i8 = icmp sge <vscale x 2 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4i8 = icmp sge <vscale x 4 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv8i8 = icmp sge <vscale x 8 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16i8 = icmp sge <vscale x 16 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv32i8 = icmp sge <vscale x 32 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i16 = icmp sge <2 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i16 = icmp sge <4 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i16 = icmp sge <8 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16i16 = icmp sge <16 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1i16 = icmp sge <vscale x 1 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i16 = icmp sge <vscale x 2 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4i16 = icmp sge <vscale x 4 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8i16 = icmp sge <vscale x 8 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv16i16 = icmp sge <vscale x 16 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i32 = icmp sge <2 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i32 = icmp sge <4 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8i32 = icmp sge <8 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v16i32 = icmp sge <16 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1i32 = icmp sge <vscale x 1 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i32 = icmp sge <vscale x 2 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4i32 = icmp sge <vscale x 4 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv8i32 = icmp sge <vscale x 8 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %nxv16i32 = icmp sge <vscale x 16 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i64 = icmp sge <2 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i64 = icmp sge <4 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v8i64 = icmp sge <8 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1i64 = icmp sge <vscale x 1 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2i64 = icmp sge <vscale x 2 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv4i64 = icmp sge <vscale x 4 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %nxv8i64 = icmp sge <vscale x 8 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  %v2i8 = icmp sge <2 x i8> undef, undef
  %v4i8 = icmp sge <4 x i8> undef, undef
  %v8i8 = icmp sge <8 x i8> undef, undef
  %v16i8 = icmp sge <16 x i8> undef, undef
  %v32i8 = icmp sge <32 x i8> undef, undef

  %nxv1i8 = icmp sge <vscale x 1 x i8> undef, undef
  %nxv2i8 = icmp sge <vscale x 2 x i8> undef, undef
  %nxv4i8 = icmp sge <vscale x 4 x i8> undef, undef
  %nxv8i8 = icmp sge <vscale x 8 x i8> undef, undef
  %nxv16i8 = icmp sge <vscale x 16 x i8> undef, undef
  %nxv32i8 = icmp sge <vscale x 32 x i8> undef, undef

  %v2i16 = icmp sge <2 x i16> undef, undef
  %v4i16 = icmp sge <4 x i16> undef, undef
  %v8i16 = icmp sge <8 x i16> undef, undef
  %v16i16 = icmp sge <16 x i16> undef, undef

  %nxv1i16 = icmp sge <vscale x 1 x i16> undef, undef
  %nxv2i16 = icmp sge <vscale x 2 x i16> undef, undef
  %nxv4i16 = icmp sge <vscale x 4 x i16> undef, undef
  %nxv8i16 = icmp sge <vscale x 8 x i16> undef, undef
  %nxv16i16 = icmp sge <vscale x 16 x i16> undef, undef

  %v2i32 = icmp sge <2 x i32> undef, undef
  %v4i32 = icmp sge <4 x i32> undef, undef
  %v8i32 = icmp sge <8 x i32> undef, undef
  %v16i32 = icmp sge <16 x i32> undef, undef

  %nxv1i32 = icmp sge <vscale x 1 x i32> undef, undef
  %nxv2i32 = icmp sge <vscale x 2 x i32> undef, undef
  %nxv4i32 = icmp sge <vscale x 4 x i32> undef, undef
  %nxv8i32 = icmp sge <vscale x 8 x i32> undef, undef
  %nxv16i32 = icmp sge <vscale x 16 x i32> undef, undef

  %v2i64 = icmp sge <2 x i64> undef, undef
  %v4i64 = icmp sge <4 x i64> undef, undef
  %v8i64 = icmp sge <8 x i64> undef, undef

  %nxv1i64 = icmp sge <vscale x 1 x i64> undef, undef
  %nxv2i64 = icmp sge <vscale x 2 x i64> undef, undef
  %nxv4i64 = icmp sge <vscale x 4 x i64> undef, undef
  %nxv8i64 = icmp sge <vscale x 8 x i64> undef, undef

  ret void
}

define void @icmp_slt() {
; CHECK-LABEL: 'icmp_slt'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i8 = icmp slt <2 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i8 = icmp slt <4 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i8 = icmp slt <8 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i8 = icmp slt <16 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32i8 = icmp slt <32 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1i8 = icmp slt <vscale x 1 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i8 = icmp slt <vscale x 2 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4i8 = icmp slt <vscale x 4 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv8i8 = icmp slt <vscale x 8 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16i8 = icmp slt <vscale x 16 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv32i8 = icmp slt <vscale x 32 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i16 = icmp slt <2 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i16 = icmp slt <4 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i16 = icmp slt <8 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16i16 = icmp slt <16 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1i16 = icmp slt <vscale x 1 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i16 = icmp slt <vscale x 2 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4i16 = icmp slt <vscale x 4 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8i16 = icmp slt <vscale x 8 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv16i16 = icmp slt <vscale x 16 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i32 = icmp slt <2 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i32 = icmp slt <4 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8i32 = icmp slt <8 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v16i32 = icmp slt <16 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1i32 = icmp slt <vscale x 1 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i32 = icmp slt <vscale x 2 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4i32 = icmp slt <vscale x 4 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv8i32 = icmp slt <vscale x 8 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %nxv16i32 = icmp slt <vscale x 16 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i64 = icmp slt <2 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i64 = icmp slt <4 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v8i64 = icmp slt <8 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1i64 = icmp slt <vscale x 1 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2i64 = icmp slt <vscale x 2 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv4i64 = icmp slt <vscale x 4 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %nxv8i64 = icmp slt <vscale x 8 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  %v2i8 = icmp slt <2 x i8> undef, undef
  %v4i8 = icmp slt <4 x i8> undef, undef
  %v8i8 = icmp slt <8 x i8> undef, undef
  %v16i8 = icmp slt <16 x i8> undef, undef
  %v32i8 = icmp slt <32 x i8> undef, undef

  %nxv1i8 = icmp slt <vscale x 1 x i8> undef, undef
  %nxv2i8 = icmp slt <vscale x 2 x i8> undef, undef
  %nxv4i8 = icmp slt <vscale x 4 x i8> undef, undef
  %nxv8i8 = icmp slt <vscale x 8 x i8> undef, undef
  %nxv16i8 = icmp slt <vscale x 16 x i8> undef, undef
  %nxv32i8 = icmp slt <vscale x 32 x i8> undef, undef

  %v2i16 = icmp slt <2 x i16> undef, undef
  %v4i16 = icmp slt <4 x i16> undef, undef
  %v8i16 = icmp slt <8 x i16> undef, undef
  %v16i16 = icmp slt <16 x i16> undef, undef

  %nxv1i16 = icmp slt <vscale x 1 x i16> undef, undef
  %nxv2i16 = icmp slt <vscale x 2 x i16> undef, undef
  %nxv4i16 = icmp slt <vscale x 4 x i16> undef, undef
  %nxv8i16 = icmp slt <vscale x 8 x i16> undef, undef
  %nxv16i16 = icmp slt <vscale x 16 x i16> undef, undef

  %v2i32 = icmp slt <2 x i32> undef, undef
  %v4i32 = icmp slt <4 x i32> undef, undef
  %v8i32 = icmp slt <8 x i32> undef, undef
  %v16i32 = icmp slt <16 x i32> undef, undef

  %nxv1i32 = icmp slt <vscale x 1 x i32> undef, undef
  %nxv2i32 = icmp slt <vscale x 2 x i32> undef, undef
  %nxv4i32 = icmp slt <vscale x 4 x i32> undef, undef
  %nxv8i32 = icmp slt <vscale x 8 x i32> undef, undef
  %nxv16i32 = icmp slt <vscale x 16 x i32> undef, undef

  %v2i64 = icmp slt <2 x i64> undef, undef
  %v4i64 = icmp slt <4 x i64> undef, undef
  %v8i64 = icmp slt <8 x i64> undef, undef

  %nxv1i64 = icmp slt <vscale x 1 x i64> undef, undef
  %nxv2i64 = icmp slt <vscale x 2 x i64> undef, undef
  %nxv4i64 = icmp slt <vscale x 4 x i64> undef, undef
  %nxv8i64 = icmp slt <vscale x 8 x i64> undef, undef

  ret void
}

define void @icmp_sle() {
; CHECK-LABEL: 'icmp_sle'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i8 = icmp sle <2 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i8 = icmp sle <4 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i8 = icmp sle <8 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i8 = icmp sle <16 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32i8 = icmp sle <32 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1i8 = icmp sle <vscale x 1 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i8 = icmp sle <vscale x 2 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4i8 = icmp sle <vscale x 4 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv8i8 = icmp sle <vscale x 8 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16i8 = icmp sle <vscale x 16 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv32i8 = icmp sle <vscale x 32 x i8> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i16 = icmp sle <2 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i16 = icmp sle <4 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i16 = icmp sle <8 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16i16 = icmp sle <16 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1i16 = icmp sle <vscale x 1 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i16 = icmp sle <vscale x 2 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4i16 = icmp sle <vscale x 4 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8i16 = icmp sle <vscale x 8 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv16i16 = icmp sle <vscale x 16 x i16> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i32 = icmp sle <2 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i32 = icmp sle <4 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8i32 = icmp sle <8 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v16i32 = icmp sle <16 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1i32 = icmp sle <vscale x 1 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i32 = icmp sle <vscale x 2 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4i32 = icmp sle <vscale x 4 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv8i32 = icmp sle <vscale x 8 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %nxv16i32 = icmp sle <vscale x 16 x i32> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i64 = icmp sle <2 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i64 = icmp sle <4 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v8i64 = icmp sle <8 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1i64 = icmp sle <vscale x 1 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2i64 = icmp sle <vscale x 2 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv4i64 = icmp sle <vscale x 4 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %nxv8i64 = icmp sle <vscale x 8 x i64> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  %v2i8 = icmp sle <2 x i8> undef, undef
  %v4i8 = icmp sle <4 x i8> undef, undef
  %v8i8 = icmp sle <8 x i8> undef, undef
  %v16i8 = icmp sle <16 x i8> undef, undef
  %v32i8 = icmp sle <32 x i8> undef, undef

  %nxv1i8 = icmp sle <vscale x 1 x i8> undef, undef
  %nxv2i8 = icmp sle <vscale x 2 x i8> undef, undef
  %nxv4i8 = icmp sle <vscale x 4 x i8> undef, undef
  %nxv8i8 = icmp sle <vscale x 8 x i8> undef, undef
  %nxv16i8 = icmp sle <vscale x 16 x i8> undef, undef
  %nxv32i8 = icmp sle <vscale x 32 x i8> undef, undef

  %v2i16 = icmp sle <2 x i16> undef, undef
  %v4i16 = icmp sle <4 x i16> undef, undef
  %v8i16 = icmp sle <8 x i16> undef, undef
  %v16i16 = icmp sle <16 x i16> undef, undef

  %nxv1i16 = icmp sle <vscale x 1 x i16> undef, undef
  %nxv2i16 = icmp sle <vscale x 2 x i16> undef, undef
  %nxv4i16 = icmp sle <vscale x 4 x i16> undef, undef
  %nxv8i16 = icmp sle <vscale x 8 x i16> undef, undef
  %nxv16i16 = icmp sle <vscale x 16 x i16> undef, undef

  %v2i32 = icmp sle <2 x i32> undef, undef
  %v4i32 = icmp sle <4 x i32> undef, undef
  %v8i32 = icmp sle <8 x i32> undef, undef
  %v16i32 = icmp sle <16 x i32> undef, undef

  %nxv1i32 = icmp sle <vscale x 1 x i32> undef, undef
  %nxv2i32 = icmp sle <vscale x 2 x i32> undef, undef
  %nxv4i32 = icmp sle <vscale x 4 x i32> undef, undef
  %nxv8i32 = icmp sle <vscale x 8 x i32> undef, undef
  %nxv16i32 = icmp sle <vscale x 16 x i32> undef, undef

  %v2i64 = icmp sle <2 x i64> undef, undef
  %v4i64 = icmp sle <4 x i64> undef, undef
  %v8i64 = icmp sle <8 x i64> undef, undef

  %nxv1i64 = icmp sle <vscale x 1 x i64> undef, undef
  %nxv2i64 = icmp sle <vscale x 2 x i64> undef, undef
  %nxv4i64 = icmp sle <vscale x 4 x i64> undef, undef
  %nxv8i64 = icmp sle <vscale x 8 x i64> undef, undef

  ret void
}

define void @fcmp_oeq() {
; CHECK-LABEL: 'fcmp_oeq'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2f32 = fcmp oeq <2 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4f32 = fcmp oeq <4 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8f32 = fcmp oeq <8 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v16f32 = fcmp oeq <16 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1f32 = fcmp oeq <vscale x 1 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2f32 = fcmp oeq <vscale x 2 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4f32 = fcmp oeq <vscale x 4 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv8f32 = fcmp oeq <vscale x 8 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %nxv16f32 = fcmp oeq <vscale x 16 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2f64 = fcmp oeq <2 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4f64 = fcmp oeq <4 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v8f64 = fcmp oeq <8 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1f64 = fcmp oeq <vscale x 1 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2f64 = fcmp oeq <vscale x 2 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv4f64 = fcmp oeq <vscale x 4 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %nxv8f64 = fcmp oeq <vscale x 8 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;


  %v2f32 = fcmp oeq <2 x float> undef, undef
  %v4f32 = fcmp oeq <4 x float> undef, undef
  %v8f32 = fcmp oeq <8 x float> undef, undef
  %v16f32 = fcmp oeq <16 x float> undef, undef

  %nxv1f32 = fcmp oeq <vscale x 1 x float> undef, undef
  %nxv2f32 = fcmp oeq <vscale x 2 x float> undef, undef
  %nxv4f32 = fcmp oeq <vscale x 4 x float> undef, undef
  %nxv8f32 = fcmp oeq <vscale x 8 x float> undef, undef
  %nxv16f32 = fcmp oeq <vscale x 16 x float> undef, undef

  %v2f64 = fcmp oeq <2 x double> undef, undef
  %v4f64 = fcmp oeq <4 x double> undef, undef
  %v8f64 = fcmp oeq <8 x double> undef, undef

  %nxv1f64 = fcmp oeq <vscale x 1 x double> undef, undef
  %nxv2f64 = fcmp oeq <vscale x 2 x double> undef, undef
  %nxv4f64 = fcmp oeq <vscale x 4 x double> undef, undef
  %nxv8f64 = fcmp oeq <vscale x 8 x double> undef, undef

  ret void
}

define void @fcmp_one() {
; CHECK-LABEL: 'fcmp_one'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v2f32 = fcmp one <2 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v4f32 = fcmp one <4 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v8f32 = fcmp one <8 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %v16f32 = fcmp one <16 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv1f32 = fcmp one <vscale x 1 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv2f32 = fcmp one <vscale x 2 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %nxv4f32 = fcmp one <vscale x 4 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %nxv8f32 = fcmp one <vscale x 8 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %nxv16f32 = fcmp one <vscale x 16 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v2f64 = fcmp one <2 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v4f64 = fcmp one <4 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %v8f64 = fcmp one <8 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv1f64 = fcmp one <vscale x 1 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %nxv2f64 = fcmp one <vscale x 2 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %nxv4f64 = fcmp one <vscale x 4 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %nxv8f64 = fcmp one <vscale x 8 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;


  %v2f32 = fcmp one <2 x float> undef, undef
  %v4f32 = fcmp one <4 x float> undef, undef
  %v8f32 = fcmp one <8 x float> undef, undef
  %v16f32 = fcmp one <16 x float> undef, undef

  %nxv1f32 = fcmp one <vscale x 1 x float> undef, undef
  %nxv2f32 = fcmp one <vscale x 2 x float> undef, undef
  %nxv4f32 = fcmp one <vscale x 4 x float> undef, undef
  %nxv8f32 = fcmp one <vscale x 8 x float> undef, undef
  %nxv16f32 = fcmp one <vscale x 16 x float> undef, undef

  %v2f64 = fcmp one <2 x double> undef, undef
  %v4f64 = fcmp one <4 x double> undef, undef
  %v8f64 = fcmp one <8 x double> undef, undef

  %nxv1f64 = fcmp one <vscale x 1 x double> undef, undef
  %nxv2f64 = fcmp one <vscale x 2 x double> undef, undef
  %nxv4f64 = fcmp one <vscale x 4 x double> undef, undef
  %nxv8f64 = fcmp one <vscale x 8 x double> undef, undef

  ret void
}

define void @fcmp_olt() {
; CHECK-LABEL: 'fcmp_olt'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2f32 = fcmp olt <2 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4f32 = fcmp olt <4 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8f32 = fcmp olt <8 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v16f32 = fcmp olt <16 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1f32 = fcmp olt <vscale x 1 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2f32 = fcmp olt <vscale x 2 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4f32 = fcmp olt <vscale x 4 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv8f32 = fcmp olt <vscale x 8 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %nxv16f32 = fcmp olt <vscale x 16 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2f64 = fcmp olt <2 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4f64 = fcmp olt <4 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v8f64 = fcmp olt <8 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1f64 = fcmp olt <vscale x 1 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2f64 = fcmp olt <vscale x 2 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv4f64 = fcmp olt <vscale x 4 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %nxv8f64 = fcmp olt <vscale x 8 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;


  %v2f32 = fcmp olt <2 x float> undef, undef
  %v4f32 = fcmp olt <4 x float> undef, undef
  %v8f32 = fcmp olt <8 x float> undef, undef
  %v16f32 = fcmp olt <16 x float> undef, undef

  %nxv1f32 = fcmp olt <vscale x 1 x float> undef, undef
  %nxv2f32 = fcmp olt <vscale x 2 x float> undef, undef
  %nxv4f32 = fcmp olt <vscale x 4 x float> undef, undef
  %nxv8f32 = fcmp olt <vscale x 8 x float> undef, undef
  %nxv16f32 = fcmp olt <vscale x 16 x float> undef, undef

  %v2f64 = fcmp olt <2 x double> undef, undef
  %v4f64 = fcmp olt <4 x double> undef, undef
  %v8f64 = fcmp olt <8 x double> undef, undef

  %nxv1f64 = fcmp olt <vscale x 1 x double> undef, undef
  %nxv2f64 = fcmp olt <vscale x 2 x double> undef, undef
  %nxv4f64 = fcmp olt <vscale x 4 x double> undef, undef
  %nxv8f64 = fcmp olt <vscale x 8 x double> undef, undef

  ret void
}

define void @fcmp_ole() {
; CHECK-LABEL: 'fcmp_ole'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2f32 = fcmp ole <2 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4f32 = fcmp ole <4 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8f32 = fcmp ole <8 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v16f32 = fcmp ole <16 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1f32 = fcmp ole <vscale x 1 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2f32 = fcmp ole <vscale x 2 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4f32 = fcmp ole <vscale x 4 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv8f32 = fcmp ole <vscale x 8 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %nxv16f32 = fcmp ole <vscale x 16 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2f64 = fcmp ole <2 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4f64 = fcmp ole <4 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v8f64 = fcmp ole <8 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1f64 = fcmp ole <vscale x 1 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2f64 = fcmp ole <vscale x 2 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv4f64 = fcmp ole <vscale x 4 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %nxv8f64 = fcmp ole <vscale x 8 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;


  %v2f32 = fcmp ole <2 x float> undef, undef
  %v4f32 = fcmp ole <4 x float> undef, undef
  %v8f32 = fcmp ole <8 x float> undef, undef
  %v16f32 = fcmp ole <16 x float> undef, undef

  %nxv1f32 = fcmp ole <vscale x 1 x float> undef, undef
  %nxv2f32 = fcmp ole <vscale x 2 x float> undef, undef
  %nxv4f32 = fcmp ole <vscale x 4 x float> undef, undef
  %nxv8f32 = fcmp ole <vscale x 8 x float> undef, undef
  %nxv16f32 = fcmp ole <vscale x 16 x float> undef, undef

  %v2f64 = fcmp ole <2 x double> undef, undef
  %v4f64 = fcmp ole <4 x double> undef, undef
  %v8f64 = fcmp ole <8 x double> undef, undef

  %nxv1f64 = fcmp ole <vscale x 1 x double> undef, undef
  %nxv2f64 = fcmp ole <vscale x 2 x double> undef, undef
  %nxv4f64 = fcmp ole <vscale x 4 x double> undef, undef
  %nxv8f64 = fcmp ole <vscale x 8 x double> undef, undef

  ret void
}

define void @fcmp_ogt() {
; CHECK-LABEL: 'fcmp_ogt'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2f32 = fcmp ogt <2 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4f32 = fcmp ogt <4 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8f32 = fcmp ogt <8 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v16f32 = fcmp ogt <16 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1f32 = fcmp ogt <vscale x 1 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2f32 = fcmp ogt <vscale x 2 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4f32 = fcmp ogt <vscale x 4 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv8f32 = fcmp ogt <vscale x 8 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %nxv16f32 = fcmp ogt <vscale x 16 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2f64 = fcmp ogt <2 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4f64 = fcmp ogt <4 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v8f64 = fcmp ogt <8 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1f64 = fcmp ogt <vscale x 1 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2f64 = fcmp ogt <vscale x 2 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv4f64 = fcmp ogt <vscale x 4 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %nxv8f64 = fcmp ogt <vscale x 8 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;


  %v2f32 = fcmp ogt <2 x float> undef, undef
  %v4f32 = fcmp ogt <4 x float> undef, undef
  %v8f32 = fcmp ogt <8 x float> undef, undef
  %v16f32 = fcmp ogt <16 x float> undef, undef

  %nxv1f32 = fcmp ogt <vscale x 1 x float> undef, undef
  %nxv2f32 = fcmp ogt <vscale x 2 x float> undef, undef
  %nxv4f32 = fcmp ogt <vscale x 4 x float> undef, undef
  %nxv8f32 = fcmp ogt <vscale x 8 x float> undef, undef
  %nxv16f32 = fcmp ogt <vscale x 16 x float> undef, undef

  %v2f64 = fcmp ogt <2 x double> undef, undef
  %v4f64 = fcmp ogt <4 x double> undef, undef
  %v8f64 = fcmp ogt <8 x double> undef, undef

  %nxv1f64 = fcmp ogt <vscale x 1 x double> undef, undef
  %nxv2f64 = fcmp ogt <vscale x 2 x double> undef, undef
  %nxv4f64 = fcmp ogt <vscale x 4 x double> undef, undef
  %nxv8f64 = fcmp ogt <vscale x 8 x double> undef, undef

  ret void
}

define void @fcmp_oge() {
; CHECK-LABEL: 'fcmp_oge'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2f32 = fcmp oge <2 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4f32 = fcmp oge <4 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8f32 = fcmp oge <8 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v16f32 = fcmp oge <16 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1f32 = fcmp oge <vscale x 1 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2f32 = fcmp oge <vscale x 2 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4f32 = fcmp oge <vscale x 4 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv8f32 = fcmp oge <vscale x 8 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %nxv16f32 = fcmp oge <vscale x 16 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2f64 = fcmp oge <2 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4f64 = fcmp oge <4 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v8f64 = fcmp oge <8 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1f64 = fcmp oge <vscale x 1 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2f64 = fcmp oge <vscale x 2 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv4f64 = fcmp oge <vscale x 4 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %nxv8f64 = fcmp oge <vscale x 8 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;


  %v2f32 = fcmp oge <2 x float> undef, undef
  %v4f32 = fcmp oge <4 x float> undef, undef
  %v8f32 = fcmp oge <8 x float> undef, undef
  %v16f32 = fcmp oge <16 x float> undef, undef

  %nxv1f32 = fcmp oge <vscale x 1 x float> undef, undef
  %nxv2f32 = fcmp oge <vscale x 2 x float> undef, undef
  %nxv4f32 = fcmp oge <vscale x 4 x float> undef, undef
  %nxv8f32 = fcmp oge <vscale x 8 x float> undef, undef
  %nxv16f32 = fcmp oge <vscale x 16 x float> undef, undef

  %v2f64 = fcmp oge <2 x double> undef, undef
  %v4f64 = fcmp oge <4 x double> undef, undef
  %v8f64 = fcmp oge <8 x double> undef, undef

  %nxv1f64 = fcmp oge <vscale x 1 x double> undef, undef
  %nxv2f64 = fcmp oge <vscale x 2 x double> undef, undef
  %nxv4f64 = fcmp oge <vscale x 4 x double> undef, undef
  %nxv8f64 = fcmp oge <vscale x 8 x double> undef, undef

  ret void
}

define void @fcmp_ueq() {
; CHECK-LABEL: 'fcmp_ueq'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v2f32 = fcmp ueq <2 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v4f32 = fcmp ueq <4 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v8f32 = fcmp ueq <8 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %v16f32 = fcmp ueq <16 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv1f32 = fcmp ueq <vscale x 1 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv2f32 = fcmp ueq <vscale x 2 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %nxv4f32 = fcmp ueq <vscale x 4 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %nxv8f32 = fcmp ueq <vscale x 8 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %nxv16f32 = fcmp ueq <vscale x 16 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v2f64 = fcmp ueq <2 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v4f64 = fcmp ueq <4 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %v8f64 = fcmp ueq <8 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv1f64 = fcmp ueq <vscale x 1 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %nxv2f64 = fcmp ueq <vscale x 2 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %nxv4f64 = fcmp ueq <vscale x 4 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %nxv8f64 = fcmp ueq <vscale x 8 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;


  %v2f32 = fcmp ueq <2 x float> undef, undef
  %v4f32 = fcmp ueq <4 x float> undef, undef
  %v8f32 = fcmp ueq <8 x float> undef, undef
  %v16f32 = fcmp ueq <16 x float> undef, undef

  %nxv1f32 = fcmp ueq <vscale x 1 x float> undef, undef
  %nxv2f32 = fcmp ueq <vscale x 2 x float> undef, undef
  %nxv4f32 = fcmp ueq <vscale x 4 x float> undef, undef
  %nxv8f32 = fcmp ueq <vscale x 8 x float> undef, undef
  %nxv16f32 = fcmp ueq <vscale x 16 x float> undef, undef

  %v2f64 = fcmp ueq <2 x double> undef, undef
  %v4f64 = fcmp ueq <4 x double> undef, undef
  %v8f64 = fcmp ueq <8 x double> undef, undef

  %nxv1f64 = fcmp ueq <vscale x 1 x double> undef, undef
  %nxv2f64 = fcmp ueq <vscale x 2 x double> undef, undef
  %nxv4f64 = fcmp ueq <vscale x 4 x double> undef, undef
  %nxv8f64 = fcmp ueq <vscale x 8 x double> undef, undef

  ret void
}

define void @fcmp_une() {
; CHECK-LABEL: 'fcmp_une'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2f32 = fcmp une <2 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4f32 = fcmp une <4 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8f32 = fcmp une <8 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v16f32 = fcmp une <16 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1f32 = fcmp une <vscale x 1 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2f32 = fcmp une <vscale x 2 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4f32 = fcmp une <vscale x 4 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv8f32 = fcmp une <vscale x 8 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %nxv16f32 = fcmp une <vscale x 16 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2f64 = fcmp une <2 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4f64 = fcmp une <4 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v8f64 = fcmp une <8 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1f64 = fcmp une <vscale x 1 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2f64 = fcmp une <vscale x 2 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv4f64 = fcmp une <vscale x 4 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %nxv8f64 = fcmp une <vscale x 8 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;


  %v2f32 = fcmp une <2 x float> undef, undef
  %v4f32 = fcmp une <4 x float> undef, undef
  %v8f32 = fcmp une <8 x float> undef, undef
  %v16f32 = fcmp une <16 x float> undef, undef

  %nxv1f32 = fcmp une <vscale x 1 x float> undef, undef
  %nxv2f32 = fcmp une <vscale x 2 x float> undef, undef
  %nxv4f32 = fcmp une <vscale x 4 x float> undef, undef
  %nxv8f32 = fcmp une <vscale x 8 x float> undef, undef
  %nxv16f32 = fcmp une <vscale x 16 x float> undef, undef

  %v2f64 = fcmp une <2 x double> undef, undef
  %v4f64 = fcmp une <4 x double> undef, undef
  %v8f64 = fcmp une <8 x double> undef, undef

  %nxv1f64 = fcmp une <vscale x 1 x double> undef, undef
  %nxv2f64 = fcmp une <vscale x 2 x double> undef, undef
  %nxv4f64 = fcmp une <vscale x 4 x double> undef, undef
  %nxv8f64 = fcmp une <vscale x 8 x double> undef, undef

  ret void
}

define void @fcmp_ult() {
; CHECK-LABEL: 'fcmp_ult'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2f32 = fcmp ult <2 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4f32 = fcmp ult <4 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v8f32 = fcmp ult <8 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v16f32 = fcmp ult <16 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv1f32 = fcmp ult <vscale x 1 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2f32 = fcmp ult <vscale x 2 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv4f32 = fcmp ult <vscale x 4 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %nxv8f32 = fcmp ult <vscale x 8 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %nxv16f32 = fcmp ult <vscale x 16 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2f64 = fcmp ult <2 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v4f64 = fcmp ult <4 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v8f64 = fcmp ult <8 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv1f64 = fcmp ult <vscale x 1 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv2f64 = fcmp ult <vscale x 2 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %nxv4f64 = fcmp ult <vscale x 4 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %nxv8f64 = fcmp ult <vscale x 8 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;


  %v2f32 = fcmp ult <2 x float> undef, undef
  %v4f32 = fcmp ult <4 x float> undef, undef
  %v8f32 = fcmp ult <8 x float> undef, undef
  %v16f32 = fcmp ult <16 x float> undef, undef

  %nxv1f32 = fcmp ult <vscale x 1 x float> undef, undef
  %nxv2f32 = fcmp ult <vscale x 2 x float> undef, undef
  %nxv4f32 = fcmp ult <vscale x 4 x float> undef, undef
  %nxv8f32 = fcmp ult <vscale x 8 x float> undef, undef
  %nxv16f32 = fcmp ult <vscale x 16 x float> undef, undef

  %v2f64 = fcmp ult <2 x double> undef, undef
  %v4f64 = fcmp ult <4 x double> undef, undef
  %v8f64 = fcmp ult <8 x double> undef, undef

  %nxv1f64 = fcmp ult <vscale x 1 x double> undef, undef
  %nxv2f64 = fcmp ult <vscale x 2 x double> undef, undef
  %nxv4f64 = fcmp ult <vscale x 4 x double> undef, undef
  %nxv8f64 = fcmp ult <vscale x 8 x double> undef, undef

  ret void
}

define void @fcmp_ule() {
; CHECK-LABEL: 'fcmp_ule'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2f32 = fcmp ule <2 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4f32 = fcmp ule <4 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v8f32 = fcmp ule <8 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v16f32 = fcmp ule <16 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv1f32 = fcmp ule <vscale x 1 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2f32 = fcmp ule <vscale x 2 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv4f32 = fcmp ule <vscale x 4 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %nxv8f32 = fcmp ule <vscale x 8 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %nxv16f32 = fcmp ule <vscale x 16 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2f64 = fcmp ule <2 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v4f64 = fcmp ule <4 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v8f64 = fcmp ule <8 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv1f64 = fcmp ule <vscale x 1 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv2f64 = fcmp ule <vscale x 2 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %nxv4f64 = fcmp ule <vscale x 4 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %nxv8f64 = fcmp ule <vscale x 8 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;


  %v2f32 = fcmp ule <2 x float> undef, undef
  %v4f32 = fcmp ule <4 x float> undef, undef
  %v8f32 = fcmp ule <8 x float> undef, undef
  %v16f32 = fcmp ule <16 x float> undef, undef

  %nxv1f32 = fcmp ule <vscale x 1 x float> undef, undef
  %nxv2f32 = fcmp ule <vscale x 2 x float> undef, undef
  %nxv4f32 = fcmp ule <vscale x 4 x float> undef, undef
  %nxv8f32 = fcmp ule <vscale x 8 x float> undef, undef
  %nxv16f32 = fcmp ule <vscale x 16 x float> undef, undef

  %v2f64 = fcmp ule <2 x double> undef, undef
  %v4f64 = fcmp ule <4 x double> undef, undef
  %v8f64 = fcmp ule <8 x double> undef, undef

  %nxv1f64 = fcmp ule <vscale x 1 x double> undef, undef
  %nxv2f64 = fcmp ule <vscale x 2 x double> undef, undef
  %nxv4f64 = fcmp ule <vscale x 4 x double> undef, undef
  %nxv8f64 = fcmp ule <vscale x 8 x double> undef, undef

  ret void
}

define void @fcmp_ugt() {
; CHECK-LABEL: 'fcmp_ugt'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2f32 = fcmp ugt <2 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4f32 = fcmp ugt <4 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v8f32 = fcmp ugt <8 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v16f32 = fcmp ugt <16 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv1f32 = fcmp ugt <vscale x 1 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2f32 = fcmp ugt <vscale x 2 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv4f32 = fcmp ugt <vscale x 4 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %nxv8f32 = fcmp ugt <vscale x 8 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %nxv16f32 = fcmp ugt <vscale x 16 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2f64 = fcmp ugt <2 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v4f64 = fcmp ugt <4 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v8f64 = fcmp ugt <8 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv1f64 = fcmp ugt <vscale x 1 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv2f64 = fcmp ugt <vscale x 2 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %nxv4f64 = fcmp ugt <vscale x 4 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %nxv8f64 = fcmp ugt <vscale x 8 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;


  %v2f32 = fcmp ugt <2 x float> undef, undef
  %v4f32 = fcmp ugt <4 x float> undef, undef
  %v8f32 = fcmp ugt <8 x float> undef, undef
  %v16f32 = fcmp ugt <16 x float> undef, undef

  %nxv1f32 = fcmp ugt <vscale x 1 x float> undef, undef
  %nxv2f32 = fcmp ugt <vscale x 2 x float> undef, undef
  %nxv4f32 = fcmp ugt <vscale x 4 x float> undef, undef
  %nxv8f32 = fcmp ugt <vscale x 8 x float> undef, undef
  %nxv16f32 = fcmp ugt <vscale x 16 x float> undef, undef

  %v2f64 = fcmp ugt <2 x double> undef, undef
  %v4f64 = fcmp ugt <4 x double> undef, undef
  %v8f64 = fcmp ugt <8 x double> undef, undef

  %nxv1f64 = fcmp ugt <vscale x 1 x double> undef, undef
  %nxv2f64 = fcmp ugt <vscale x 2 x double> undef, undef
  %nxv4f64 = fcmp ugt <vscale x 4 x double> undef, undef
  %nxv8f64 = fcmp ugt <vscale x 8 x double> undef, undef

  ret void
}

define void @fcmp_uge() {
; CHECK-LABEL: 'fcmp_uge'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2f32 = fcmp uge <2 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4f32 = fcmp uge <4 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v8f32 = fcmp uge <8 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v16f32 = fcmp uge <16 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv1f32 = fcmp uge <vscale x 1 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2f32 = fcmp uge <vscale x 2 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv4f32 = fcmp uge <vscale x 4 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %nxv8f32 = fcmp uge <vscale x 8 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %nxv16f32 = fcmp uge <vscale x 16 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2f64 = fcmp uge <2 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v4f64 = fcmp uge <4 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v8f64 = fcmp uge <8 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv1f64 = fcmp uge <vscale x 1 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv2f64 = fcmp uge <vscale x 2 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %nxv4f64 = fcmp uge <vscale x 4 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %nxv8f64 = fcmp uge <vscale x 8 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;


  %v2f32 = fcmp uge <2 x float> undef, undef
  %v4f32 = fcmp uge <4 x float> undef, undef
  %v8f32 = fcmp uge <8 x float> undef, undef
  %v16f32 = fcmp uge <16 x float> undef, undef

  %nxv1f32 = fcmp uge <vscale x 1 x float> undef, undef
  %nxv2f32 = fcmp uge <vscale x 2 x float> undef, undef
  %nxv4f32 = fcmp uge <vscale x 4 x float> undef, undef
  %nxv8f32 = fcmp uge <vscale x 8 x float> undef, undef
  %nxv16f32 = fcmp uge <vscale x 16 x float> undef, undef

  %v2f64 = fcmp uge <2 x double> undef, undef
  %v4f64 = fcmp uge <4 x double> undef, undef
  %v8f64 = fcmp uge <8 x double> undef, undef

  %nxv1f64 = fcmp uge <vscale x 1 x double> undef, undef
  %nxv2f64 = fcmp uge <vscale x 2 x double> undef, undef
  %nxv4f64 = fcmp uge <vscale x 4 x double> undef, undef
  %nxv8f64 = fcmp uge <vscale x 8 x double> undef, undef

  ret void
}

define void @fcmp_true() {
; CHECK-LABEL: 'fcmp_true'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2f32 = fcmp true <2 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4f32 = fcmp true <4 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8f32 = fcmp true <8 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16f32 = fcmp true <16 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1f32 = fcmp true <vscale x 1 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2f32 = fcmp true <vscale x 2 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4f32 = fcmp true <vscale x 4 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv8f32 = fcmp true <vscale x 8 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv16f32 = fcmp true <vscale x 16 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2f64 = fcmp true <2 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4f64 = fcmp true <4 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8f64 = fcmp true <8 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1f64 = fcmp true <vscale x 1 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2f64 = fcmp true <vscale x 2 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4f64 = fcmp true <vscale x 4 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv8f64 = fcmp true <vscale x 8 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;


  %v2f32 = fcmp true <2 x float> undef, undef
  %v4f32 = fcmp true <4 x float> undef, undef
  %v8f32 = fcmp true <8 x float> undef, undef
  %v16f32 = fcmp true <16 x float> undef, undef

  %nxv1f32 = fcmp true <vscale x 1 x float> undef, undef
  %nxv2f32 = fcmp true <vscale x 2 x float> undef, undef
  %nxv4f32 = fcmp true <vscale x 4 x float> undef, undef
  %nxv8f32 = fcmp true <vscale x 8 x float> undef, undef
  %nxv16f32 = fcmp true <vscale x 16 x float> undef, undef

  %v2f64 = fcmp true <2 x double> undef, undef
  %v4f64 = fcmp true <4 x double> undef, undef
  %v8f64 = fcmp true <8 x double> undef, undef

  %nxv1f64 = fcmp true <vscale x 1 x double> undef, undef
  %nxv2f64 = fcmp true <vscale x 2 x double> undef, undef
  %nxv4f64 = fcmp true <vscale x 4 x double> undef, undef
  %nxv8f64 = fcmp true <vscale x 8 x double> undef, undef

  ret void
}

define void @fcmp_false() {
; CHECK-LABEL: 'fcmp_false'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2f32 = fcmp false <2 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4f32 = fcmp false <4 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8f32 = fcmp false <8 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16f32 = fcmp false <16 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1f32 = fcmp false <vscale x 1 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2f32 = fcmp false <vscale x 2 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4f32 = fcmp false <vscale x 4 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv8f32 = fcmp false <vscale x 8 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv16f32 = fcmp false <vscale x 16 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2f64 = fcmp false <2 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4f64 = fcmp false <4 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8f64 = fcmp false <8 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1f64 = fcmp false <vscale x 1 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2f64 = fcmp false <vscale x 2 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4f64 = fcmp false <vscale x 4 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv8f64 = fcmp false <vscale x 8 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;


  %v2f32 = fcmp false <2 x float> undef, undef
  %v4f32 = fcmp false <4 x float> undef, undef
  %v8f32 = fcmp false <8 x float> undef, undef
  %v16f32 = fcmp false <16 x float> undef, undef

  %nxv1f32 = fcmp false <vscale x 1 x float> undef, undef
  %nxv2f32 = fcmp false <vscale x 2 x float> undef, undef
  %nxv4f32 = fcmp false <vscale x 4 x float> undef, undef
  %nxv8f32 = fcmp false <vscale x 8 x float> undef, undef
  %nxv16f32 = fcmp false <vscale x 16 x float> undef, undef

  %v2f64 = fcmp false <2 x double> undef, undef
  %v4f64 = fcmp false <4 x double> undef, undef
  %v8f64 = fcmp false <8 x double> undef, undef

  %nxv1f64 = fcmp false <vscale x 1 x double> undef, undef
  %nxv2f64 = fcmp false <vscale x 2 x double> undef, undef
  %nxv4f64 = fcmp false <vscale x 4 x double> undef, undef
  %nxv8f64 = fcmp false <vscale x 8 x double> undef, undef

  ret void
}
