\name{PimpleImageBase}
\alias{PimpleImageBase}
\title{PimpleImageBase}
\Rdversion{1.1}
\docType{class}
\description{
Private implementation idiom image base class.
PimpleImageBase}
\details{
We utilize the private implementation ( or PImpl) programming idiom to
modify the behavior of the simple image class based on the different
image types.
This class is designed to utilize the trivial copy, and assignment
operators
PimpleImageBase}
%C++ includes: sitkPimpleImageBase.h
\section{Methods}{
\describe{
\item{std::unique_ptr<  DeepCopy() const =0:}{}
\item{std::vector< double > EvaluateAtContinuousIndex(const std::vector< double > &index, InterpolatorEnum interp) const =0:}{}
\item{const double * GetBufferAsDouble() const =0:}{}
\item{double * GetBufferAsDouble()=0:}{}
\item{const float * GetBufferAsFloat() const =0:}{}
\item{float * GetBufferAsFloat()=0:}{}
\item{const int16_t * GetBufferAsInt16() const =0:}{}
\item{int16_t * GetBufferAsInt16()=0:}{}
\item{const int32_t * GetBufferAsInt32() const =0:}{}
\item{int32_t * GetBufferAsInt32()=0:}{}
\item{const int64_t * GetBufferAsInt64() const =0:}{}
\item{int64_t * GetBufferAsInt64()=0:}{}
\item{const int8_t * GetBufferAsInt8() const =0:}{}
\item{int8_t * GetBufferAsInt8()=0:}{}
\item{const uint16_t * GetBufferAsUInt16() const =0:}{}
\item{uint16_t * GetBufferAsUInt16()=0:}{}
\item{const uint32_t * GetBufferAsUInt32() const =0:}{}
\item{uint32_t * GetBufferAsUInt32()=0:}{}
\item{const uint64_t * GetBufferAsUInt64() const =0:}{}
\item{uint64_t * GetBufferAsUInt64()=0:}{}
\item{const uint8_t * GetBufferAsUInt8() const =0:}{}
\item{uint8_t * GetBufferAsUInt8()=0:}{}
\item{const void * GetBufferAsVoid() const =0:}{}
\item{void * GetBufferAsVoid()=0:}{}
\item{const  GetDataBase() const =0:}{}
\item{itk::DataObject GetDataBase()=0:}{}
\item{unsigned int GetDepth() const:}{}
\item{unsigned int GetDimension() const =0:}{}
\item{std::vector< double > GetDirection() const =0:}{}
\item{unsigned int GetHeight() const:}{}
\item{unsigned int GetNumberOfComponentsPerPixel() const =0:}{}
\item{uint64_t GetNumberOfPixels() const =0:}{}
\item{std::vector< double > GetOrigin() const =0:}{}
\item{std::complex< float > GetPixelAsComplexFloat32(const std::vector< uint32_t > &idx) const =0:}{}
\item{std::complex< double > GetPixelAsComplexFloat64(const std::vector< uint32_t > &idx) const =0:}{}
\item{double GetPixelAsDouble(const std::vector< uint32_t > &idx) const =0:}{}
\item{float GetPixelAsFloat(const std::vector< uint32_t > &idx) const =0:}{}
\item{int16_t GetPixelAsInt16(const std::vector< uint32_t > &idx) const =0:}{}
\item{int32_t GetPixelAsInt32(const std::vector< uint32_t > &idx) const =0:}{}
\item{int64_t GetPixelAsInt64(const std::vector< uint32_t > &idx) const =0:}{}
\item{int8_t GetPixelAsInt8(const std::vector< uint32_t > &idx) const =0:}{}
\item{uint16_t GetPixelAsUInt16(const std::vector< uint32_t > &idx) const =0:}{}
\item{uint32_t GetPixelAsUInt32(const std::vector< uint32_t > &idx) const =0:}{}
\item{uint64_t GetPixelAsUInt64(const std::vector< uint32_t > &idx) const =0:}{}
\item{uint8_t GetPixelAsUInt8(const std::vector< uint32_t > &idx) const =0:}{}
\item{std::vector< float > GetPixelAsVectorFloat32(const std::vector< uint32_t > &idx) const =0:}{}
\item{std::vector< double > GetPixelAsVectorFloat64(const std::vector< uint32_t > &idx) const =0:}{}
\item{std::vector< int16_t > GetPixelAsVectorInt16(const std::vector< uint32_t > &idx) const =0:}{}
\item{std::vector< int32_t > GetPixelAsVectorInt32(const std::vector< uint32_t > &idx) const =0:}{}
\item{std::vector< int64_t > GetPixelAsVectorInt64(const std::vector< uint32_t > &idx) const =0:}{}
\item{std::vector< int8_t > GetPixelAsVectorInt8(const std::vector< uint32_t > &idx) const =0:}{}
\item{std::vector< uint16_t > GetPixelAsVectorUInt16(const std::vector< uint32_t > &idx) const =0:}{}
\item{std::vector< uint32_t > GetPixelAsVectorUInt32(const std::vector< uint32_t > &idx) const =0:}{}
\item{std::vector< uint64_t > GetPixelAsVectorUInt64(const std::vector< uint32_t > &idx) const =0:}{}
\item{std::vector< uint8_t > GetPixelAsVectorUInt8(const std::vector< uint32_t > &idx) const =0:}{}
\item{PixelIDValueEnum GetPixelID() const =0:}{}
\item{int GetReferenceCountOfImage() const =0:}{}
\item{std::vector< unsigned int > GetSize() const =0:}{}
\item{unsigned int GetSize(unsigned int dimension) const =0:}{}
\item{std::vector< double > GetSpacing() const =0:}{}
\item{unsigned int GetWidth() const:}{}
\item{std::unique_ptr<  ProxyCopy()=0:}{}
\item{void SetDirection(const std::vector< double > &direction)=0:}{}
\item{void SetOrigin(const std::vector< double > &orgn)=0:}{}
\item{void SetPixelAsComplexFloat32(const std::vector< uint32_t > &idx, const std::complex< float > v)=0:}{}
\item{void SetPixelAsComplexFloat64(const std::vector< uint32_t > &idx, const std::complex< double > v)=0:}{}
\item{void SetPixelAsDouble(const std::vector< uint32_t > &idx, double v)=0:}{}
\item{void SetPixelAsFloat(const std::vector< uint32_t > &idx, float v)=0:}{}
\item{void SetPixelAsInt16(const std::vector< uint32_t > &idx, int16_t v)=0:}{}
\item{void SetPixelAsInt32(const std::vector< uint32_t > &idx, int32_t v)=0:}{}
\item{void SetPixelAsInt64(const std::vector< uint32_t > &idx, int64_t v)=0:}{}
\item{void SetPixelAsInt8(const std::vector< uint32_t > &idx, int8_t v)=0:}{}
\item{void SetPixelAsUInt16(const std::vector< uint32_t > &idx, uint16_t v)=0:}{}
\item{void SetPixelAsUInt32(const std::vector< uint32_t > &idx, uint32_t v)=0:}{}
\item{void SetPixelAsUInt64(const std::vector< uint32_t > &idx, uint64_t v)=0:}{}
\item{void SetPixelAsUInt8(const std::vector< uint32_t > &idx, uint8_t v)=0:}{}
\item{void SetPixelAsVectorFloat32(const std::vector< uint32_t > &idx, const std::vector< float > &v)=0:}{}
\item{void SetPixelAsVectorFloat64(const std::vector< uint32_t > &idx, const std::vector< double > &v)=0:}{}
\item{void SetPixelAsVectorInt16(const std::vector< uint32_t > &idx, const std::vector< int16_t > &v)=0:}{}
\item{void SetPixelAsVectorInt32(const std::vector< uint32_t > &idx, const std::vector< int32_t > &v)=0:}{}
\item{void SetPixelAsVectorInt64(const std::vector< uint32_t > &idx, const std::vector< int64_t > &v)=0:}{}
\item{void SetPixelAsVectorInt8(const std::vector< uint32_t > &idx, const std::vector< int8_t > &v)=0:}{}
\item{void SetPixelAsVectorUInt16(const std::vector< uint32_t > &idx, const std::vector< uint16_t > &v)=0:}{}
\item{void SetPixelAsVectorUInt32(const std::vector< uint32_t > &idx, const std::vector< uint32_t > &v)=0:}{}
\item{void SetPixelAsVectorUInt64(const std::vector< uint32_t > &idx, const std::vector< uint64_t > &v)=0:}{}
\item{void SetPixelAsVectorUInt8(const std::vector< uint32_t > &idx, const std::vector< uint8_t > &v)=0:}{}
\item{void SetSpacing(const std::vector< double > &spc)=0:}{}
\item{std::unique_ptr<  ShallowCopy() const =0:}{}
\item{std::string ToString() const =0:}{}
\item{std::vector< double > TransformContinuousIndexToPhysicalPoint(const std::vector< double > &idx) const =0:}{}
\item{std::vector< double > TransformIndexToPhysicalPoint(const std::vector< int64_t > &idx) const =0:}{}
\item{std::vector< double > TransformPhysicalPointToContinuousIndex(const std::vector< double > &pt) const =0:}{}
\item{std::vector< int64_t > TransformPhysicalPointToIndex(const std::vector< double > &pt) const =0:}{}
\item{ ~PimpleImageBase()=default:}{}
}
}
