\name{MorphologicalWatershedFromMarkersImageFilter}
\alias{MorphologicalWatershedFromMarkersImageFilter}
\title{MorphologicalWatershedFromMarkersImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Morphological watershed transform from markers.
MorphologicalWatershedFromMarkersImageFilter}
\details{
The watershed transform is a tool for image segmentation that is fast
and flexible and potentially fairly parameter free. It was originally
derived from a geophysical model of rain falling on a terrain and a
variety of more formal definitions have been devised to allow
development of practical algorithms. If an image is considered as a
terrain and divided into catchment basins then the hope is that each
catchment basin would contain an object of interest.
The output is a label image. A label image, sometimes referred to as a
categorical image, has unique values for each region. For example, if
a watershed produces 2 regions, all pixels belonging to one region
would have value A, and all belonging to the other might have value B.
Unassigned pixels, such as watershed lines, might have the background
value (0 by convention).
The simplest way of using the watershed is to preprocess the image we
want to segment so that the boundaries of our objects are bright (e.g
apply an edge detector) and compute the watershed transform of the
edge image. Watershed lines will correspond to the boundaries and our
problem will be solved. This is rarely useful in practice because
there are always more regional minima than there are objects, either
due to noise or natural variations in the object surfaces. Therefore,
while many watershed lines do lie on significant boundaries, there are
many that don't. Various methods can be used to reduce the number of
minima in the image, like thresholding the smallest values, filtering
the minima and/or smoothing the image.
This filter use another approach to avoid the problem of over
segmentation: it let the user provide a marker image which mark the
minima in the input image and give them a label. The minima are
imposed in the input image by the markers. The labels of the output
image are the label of the marker image.
The morphological watershed transform algorithm is described in
Chapter 9.2 of Pierre Soille's book "Morphological Image Analysis:
Principles and Applications", Second Edition, Springer, 2003.
This code was contributed in the Insight Journal paper: "The
watershed transform in ITK - discussion and new developments" by
Beare R., Lehmann G. https://www.insight-journal.org/browse/publication/92
Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.
Richard Beare. Department of Medicine, Monash University, Melbourne,
Australia.
See:
WatershedImageFilter , MorphologicalWatershedImageFilter
MorphologicalWatershedFromMarkers for the procedural interface
itk::MorphologicalWatershedFromMarkersImageFilter for the Doxygen on the original ITK class.
MorphologicalWatershedFromMarkersImageFilter}
%C++ includes: sitkMorphologicalWatershedFromMarkersImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image, const Image &markerImage):}{
Execute the filter on the input image
}
\item{Self FullyConnectedOff():}{}
\item{Self FullyConnectedOn():}{
Set the value of FullyConnected to true or false respectfully.
}
\item{bool GetFullyConnected() const:}{
Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.
}
\item{bool GetMarkWatershedLine() const:}{
Set/Get whether the watershed pixel must be marked or not. Default is
true. Set it to false do not only avoid writing watershed pixels, it
also decrease algorithm complexity.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{Self MarkWatershedLineOff():}{}
\item{Self MarkWatershedLineOn():}{
Set the value of MarkWatershedLine to true or false respectfully.
}
\item{ MorphologicalWatershedFromMarkersImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self SetFullyConnected(bool FullyConnected):}{
Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.
}
\item{Self SetMarkWatershedLine(bool MarkWatershedLine):}{
Set/Get whether the watershed pixel must be marked or not. Default is
true. Set it to false do not only avoid writing watershed pixels, it
also decrease algorithm complexity.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~MorphologicalWatershedFromMarkersImageFilter():}{
Destructor
}
}
}
