\name{LabelMapToBinaryImageFilter}
\alias{LabelMapToBinaryImageFilter}
\title{LabelMapToBinaryImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Convert a LabelMap to a binary image.
LabelMapToBinaryImageFilter}
\details{
LabelMapToBinaryImageFilter to a binary image. All the objects in the image are used as
foreground. The background values of the original binary image can be
restored by passing this image to the filter with the
SetBackgroundImage() method.
This implementation was taken from the Insight Journal paper: https://www.insight-journal.org/browse/publication/176
Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.
See:
LabelMapToLabelImageFilter , LabelMapMaskImageFilter
LabelMapToBinary for the procedural interface
itk::LabelMapToBinaryImageFilter for the Doxygen on the original ITK class.
LabelMapToBinaryImageFilter}
%C++ includes: sitkLabelMapToBinaryImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{double GetBackgroundValue() const:}{
Set/Get the value used as "background" in the output image. Defaults
to NumericTraits<PixelType>::NonpositiveMin() .
}
\item{double GetForegroundValue() const:}{
Set/Get the value used as "foreground" in the output image. Defaults
to NumericTraits<PixelType>::max() .
}
\item{std::string GetName() const:}{
Name of this class
}
\item{ LabelMapToBinaryImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self SetBackgroundValue(double BackgroundValue):}{
Set/Get the value used as "background" in the output image. Defaults
to NumericTraits<PixelType>::NonpositiveMin() .
}
\item{Self SetForegroundValue(double ForegroundValue):}{
Set/Get the value used as "foreground" in the output image. Defaults
to NumericTraits<PixelType>::max() .
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~LabelMapToBinaryImageFilter():}{
Destructor
}
}
}
