\name{HMaximaImageFilter}
\alias{HMaximaImageFilter}
\title{HMaximaImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Suppress local maxima whose height above the baseline is less than h.
HMaximaImageFilter}
\details{
HMaximaImageFilter suppresses local maxima that are less than h intensity units above
the (local) background. This has the effect of smoothing over the
"high" parts of the noise in the image without smoothing over large
changes in intensity (region boundaries). See the HMinimaImageFilter to suppress the local minima whose depth is less than h intensity
units below the (local) background.
If the output of HMaximaImageFilter is subtracted from the original image, the significant "peaks" in
the image can be identified. This is what the HConvexImageFilter provides.
This filter uses the ReconstructionByDilationImageFilter . It provides its own input as the "mask" input to the geodesic
dilation. The "marker" image for the geodesic dilation is the input
image minus the height parameter h.
Geodesic morphology and the H-Maxima algorithm is described in Chapter
6 of Pierre Soille's book "Morphological Image Analysis: Principles
and Applications", Second Edition, Springer, 2003.
The height parameter is set using SetHeight.
See:
ReconstructionByDilationImageFilter , HMinimaImageFilter , HConvexImageFilter
MorphologyImageFilter , GrayscaleDilateImageFilter , GrayscaleFunctionDilateImageFilter , BinaryDilateImageFilter
HMaxima for the procedural interface
itk::HMaximaImageFilter for the Doxygen on the original ITK class.
HMaximaImageFilter}
%C++ includes: sitkHMaximaImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{double GetHeight() const:}{
Set/Get the height that a local maximum must be above the local
background (local contrast) in order to survive the processing. Local
maxima below this value are replaced with an estimate of the local
background.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{ HMaximaImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self SetHeight(double Height):}{
Set/Get the height that a local maximum must be above the local
background (local contrast) in order to survive the processing. Local
maxima below this value are replaced with an estimate of the local
background.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~HMaximaImageFilter():}{
Destructor
}
}
}
