\name{GreaterImageFilter}
\alias{GreaterImageFilter}
\title{GreaterImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Implements pixel-wise generic operation of two images, or of an image
and a constant.
GreaterImageFilter}
\details{
This class is parameterized over the types of the two input images and
the type of the output image. It is also parameterized by the
operation to be applied. A Functor style is used.
The constant must be of the same type than the pixel type of the
corresponding image. It is wrapped in a SimpleDataObjectDecorator so it can be updated through the pipeline. The SetConstant() and
GetConstant() methods are provided as shortcuts to set or get the
constant value without manipulating the decorator.
See:
BinaryGeneratorImagFilter
UnaryFunctorImageFilter TernaryFunctorImageFilter
Greater for the procedural interface
itk::BinaryFunctorImageFilter for the Doxygen on the original ITK class.
GreaterImageFilter}
%C++ includes: sitkGreaterImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1, const Image &image2):}{}
\item{Image Execute(const Image &image1, double constant):}{
Execute the filter with an image and a constant
}
\item{Image Execute(const Image &image1, double constant, uint8_t backgroundValue, uint8_t foregroundValue):}{
Execute the filter on an image and a constant with the given
parameters
}
\item{Image Execute(double constant, const Image &image2):}{}
\item{Image Execute(double constant, const Image &image2, uint8_t backgroundValue, uint8_t foregroundValue):}{}
\item{Image Execute(Image &&image1, const Image &image2):}{
Execute the filter on the input images
}
\item{Image Execute(Image &&image1, double constant):}{}
\item{uint8_t GetBackgroundValue() const:}{
Set/Get the value used to mark the false pixels of the operator.
}
\item{uint8_t GetForegroundValue() const:}{
Set/Get the value used to mark the true pixels of the operator.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{ GreaterImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self SetBackgroundValue(uint8_t BackgroundValue):}{
Set/Get the value used to mark the false pixels of the operator.
}
\item{Self SetForegroundValue(uint8_t ForegroundValue):}{
Set/Get the value used to mark the true pixels of the operator.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~GreaterImageFilter():}{
Destructor
}
}
}
