\name{GrayscaleMorphologicalClosingImageFilter}
\alias{GrayscaleMorphologicalClosingImageFilter}
\title{GrayscaleMorphologicalClosingImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Grayscale closing of an image.
GrayscaleMorphologicalClosingImageFilter}
\details{
Close an image using grayscale morphology.
The structuring element is assumed to be composed of binary values
(zero or one). Only elements of the structuring element having values
> 0 are candidates for affecting the center pixel.
See:
MorphologyImageFilter , GrayscaleFunctionErodeImageFilter , BinaryErodeImageFilter
GrayscaleMorphologicalClosing for the procedural interface
itk::GrayscaleMorphologicalClosingImageFilter for the Doxygen on the original ITK class.
GrayscaleMorphologicalClosingImageFilter}
%C++ includes: sitkGrayscaleMorphologicalClosingImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{std::vector< unsigned int > GetKernelRadius() const:}{
Get the radius of the kernel structuring element.
}
\item{KernelEnum GetKernelType() const:}{
Get the kernel or structuring element used for the morphology.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{bool GetSafeBorder() const:}{
A safe border is added to input image to avoid borders effects and
remove it once the closing is done
}
\item{ GrayscaleMorphologicalClosingImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self SafeBorderOff():}{}
\item{Self SafeBorderOn():}{
Set the value of SafeBorder to true or false respectfully.
}
\item{Self SetKernelRadius(std::vector< unsigned int > KernelRadius):}{
Set the radius of the kernel structuring element.
}
\item{Self SetKernelRadius(unsigned int value):}{
Set the values of the KernelRadius vector all to value
}
\item{Self SetKernelType(KernelEnum KernelType):}{
Set the kernel or structuring element used for the morphology.
}
\item{Self SetSafeBorder(bool SafeBorder):}{
A safe border is added to input image to avoid borders effects and
remove it once the closing is done
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~GrayscaleMorphologicalClosingImageFilter():}{
Destructor
}
}
}
