/*
 * Decompiled with CFR 0.152.
 */
package org.a11y.brlapi;

import java.util.LinkedList;
import java.util.List;

public class OperandUsage {
    private final String operandDescription;
    private Integer rangeMinimum = null;
    private Integer rangeMaximum = null;
    private String rangeUnits = null;
    private String rangeComment = null;
    private final List<WordEntry> wordList = new LinkedList<WordEntry>();
    private String defaultWord = null;
    private Integer defaultValue = null;

    public OperandUsage(String string) {
        this.operandDescription = string;
    }

    public final String getOperandDescription() {
        return this.operandDescription;
    }

    public final OperandUsage setRangeMinimum(int n) {
        this.rangeMinimum = n;
        return this;
    }

    public final OperandUsage setRangeMaximum(int n) {
        this.rangeMaximum = n;
        return this;
    }

    public final OperandUsage setRange(int n, int n2) {
        return this.setRangeMinimum(n).setRangeMaximum(n2);
    }

    public final OperandUsage setRangeUnits(String string) {
        this.rangeUnits = string;
        return this;
    }

    public final OperandUsage setRangeComment(String string) {
        this.rangeComment = string;
        return this;
    }

    public final OperandUsage addWord(String string, Integer n, String string2) {
        this.wordList.add(new WordEntry(string, n, string2));
        return this;
    }

    public final OperandUsage addWord(String string, String string2) {
        return this.addWord(string, null, string2);
    }

    public final OperandUsage addWord(String string, int n) {
        return this.addWord(string, n, null);
    }

    public final OperandUsage addWord(String string) {
        return this.addWord(string, null, null);
    }

    public final OperandUsage setDefault(String string) {
        this.defaultWord = string;
        this.defaultValue = null;
        return this;
    }

    public final OperandUsage setDefault(int n) {
        this.defaultWord = null;
        this.defaultValue = n;
        return this;
    }

    public final String getDefaultWord() {
        if (this.defaultWord != null) {
            return this.defaultWord;
        }
        if (this.defaultValue == null) {
            return null;
        }
        for (WordEntry wordEntry : this.wordList) {
            if (wordEntry.value != this.defaultValue) continue;
            this.defaultWord = wordEntry.word;
            return this.defaultWord;
        }
        return this.defaultValue.toString();
    }

    public final Integer getDefaultValue() {
        if (this.defaultValue != null) {
            return this.defaultValue;
        }
        if (this.defaultWord == null) {
            return null;
        }
        for (WordEntry wordEntry : this.wordList) {
            if (!wordEntry.word.equals(this.defaultWord)) continue;
            this.defaultValue = wordEntry.value;
            return this.defaultValue;
        }
        return null;
    }

    public final StringBuilder appendTo(StringBuilder stringBuilder) {
        boolean bl;
        stringBuilder.append('\n').append("The ").append(this.operandDescription).append(" operand must be");
        boolean bl2 = this.rangeMinimum != null;
        boolean bl3 = this.rangeMaximum != null;
        boolean bl4 = bl = bl2 || bl3;
        if (bl) {
            String string;
            if (this.rangeUnits != null) {
                stringBuilder.append(" a number of ").append(this.rangeUnits);
            } else {
                stringBuilder.append(" an integer");
            }
            if (bl2) {
                string = bl3 ? "within the range" : "greater than or equal to";
                stringBuilder.append(' ').append(string).append(' ').append(this.rangeMinimum);
            }
            if (bl3) {
                string = bl2 ? "through" : "less than or equal to";
                stringBuilder.append(' ').append(string).append(' ').append(this.rangeMaximum);
            }
            if (this.rangeComment != null) {
                stringBuilder.append(" (").append(this.rangeComment).append(')');
            }
        }
        if (!this.wordList.isEmpty()) {
            int n;
            if (bl) {
                stringBuilder.append(", or");
            }
            if ((n = this.wordList.size()) > 1) {
                stringBuilder.append(" any of");
            }
            int n2 = 0;
            for (WordEntry wordEntry : this.wordList) {
                if (++n2 > 1) {
                    if (n > 2) {
                        stringBuilder.append(',');
                    }
                    if (n2 == n) {
                        stringBuilder.append(" or");
                    }
                }
                stringBuilder.append(' ').append(wordEntry.word);
                String string = wordEntry.comment;
                if (string == null) continue;
                stringBuilder.append(" (").append(string).append(')');
            }
        }
        stringBuilder.append(". ");
        String string = this.getDefaultWord();
        if (string != null) {
            stringBuilder.append("If not specified, ").append(string).append(" is assumed. ");
        }
        return stringBuilder;
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    private static class WordEntry {
        public final String word;
        public final Integer value;
        public final String comment;

        public WordEntry(String string, Integer n, String string2) {
            this.word = string;
            this.value = n;
            this.comment = string2;
        }
    }
}

