// Copyright Contributors to the Open Shading Language project.
// SPDX-License-Identifier: BSD-3-Clause
// https://github.com/AcademySoftwareFoundation/OpenShadingLanguage


// This file contains "declarations" for all the strings that might get used in
// JITed shader code or in renderer code. But the declaration itself is
// dependent on the STRDECL macro, which should be declared by the outer file
// prior to including this file. Thus, this list may be repurposed and included
// multiple times, with different STRDECL definitions.


#ifndef STRDECL
#    error Do not include this file unless STRDECL is defined
#endif

// avoid naming conflict with MSVC macro
#ifdef RGB
#    undef RGB
#endif

STRDECL("", _emptystring_)
STRDECL("camera", camera)
STRDECL("common", common)
STRDECL("object", object)
STRDECL("shader", shader)
STRDECL("screen", screen)
STRDECL("NDC", NDC)
STRDECL("rgb", rgb)
STRDECL("RGB", RGB)
STRDECL("hsv", hsv)
STRDECL("hsl", hsl)
STRDECL("YIQ", YIQ)
STRDECL("XYZ", XYZ)
STRDECL("xyz", xyz)
STRDECL("xyY", xyY)
STRDECL("null", null)
STRDECL("default", default_)
STRDECL("label", label)
STRDECL("sidedness", sidedness)
STRDECL("front", front)
STRDECL("back", back)
STRDECL("both", both)
STRDECL("P", P)
STRDECL("I", I)
STRDECL("N", N)
STRDECL("Ng", Ng)
STRDECL("dPdu", dPdu)
STRDECL("dPdv", dPdv)
STRDECL("u", u)
STRDECL("v", v)
STRDECL("Ps", Ps)
STRDECL("time", time)
STRDECL("dtime", dtime)
STRDECL("dPdtime", dPdtime)
STRDECL("Ci", Ci)
STRDECL("width", width)
STRDECL("swidth", swidth)
STRDECL("twidth", twidth)
STRDECL("rwidth", rwidth)
STRDECL("blur", blur)
STRDECL("sblur", sblur)
STRDECL("tblur", tblur)
STRDECL("rblur", rblur)
STRDECL("wrap", wrap)
STRDECL("swrap", swrap)
STRDECL("twrap", twrap)
STRDECL("rwrap", rwrap)
STRDECL("black", black)
STRDECL("clamp", clamp)
STRDECL("periodic", periodic)
STRDECL("mirror", mirror)
STRDECL("firstchannel", firstchannel)
STRDECL("fill", fill)
STRDECL("alpha", alpha)
STRDECL("error", error)
STRDECL("errormessage", errormessage)
STRDECL("trace", trace)
STRDECL("mindist", mindist)
STRDECL("maxdist", maxdist)
STRDECL("shade", shade)
STRDECL("traceset", traceset)
STRDECL("interp", interp)
STRDECL("closest", closest)
STRDECL("linear", linear)
STRDECL("cubic", cubic)
STRDECL("catmull-rom", catmullrom)
STRDECL("bezier", bezier)
STRDECL("bspline", bspline)
STRDECL("hermite", hermite)
STRDECL("constant", constant)
STRDECL("smartcubic", smartcubic)
STRDECL("perlin", perlin)
STRDECL("uperlin", uperlin)
STRDECL("noise", noise)
STRDECL("snoise", snoise)
STRDECL("cell", cell)
STRDECL("cellnoise", cellnoise)
STRDECL("pcellnoise", pcellnoise)
STRDECL("hash", hash)
STRDECL("hashnoise", hashnoise)
STRDECL("phashnoise", phashnoise)
STRDECL("pnoise", pnoise)
STRDECL("psnoise", psnoise)
STRDECL("genericnoise", genericnoise)
STRDECL("genericpnoise", genericpnoise)
STRDECL("gabor", gabor)
STRDECL("gabornoise", gabornoise)
STRDECL("gaborpnoise", gaborpnoise)
STRDECL("simplex", simplex)
STRDECL("usimplex", usimplex)
STRDECL("simplexnoise", simplexnoise)
STRDECL("usimplexnoise", usimplexnoise)
STRDECL("anisotropic", anisotropic)
STRDECL("direction", direction)
STRDECL("do_filter", do_filter)
STRDECL("bandwidth", bandwidth)
STRDECL("impulses", impulses)
STRDECL("dowhile", op_dowhile)
STRDECL("for", op_for)
STRDECL("while", op_while)
STRDECL("exit", op_exit)
STRDECL("subimage", subimage)
STRDECL("subimagename", subimagename)
STRDECL("missingcolor", missingcolor)
STRDECL("missingalpha", missingalpha)
STRDECL("end", end)
STRDECL("useparam", useparam)
STRDECL("!!!uninitialized!!!", uninitialized_string)
STRDECL("unull", unull)
STRDECL("raytype", raytype)
STRDECL("color", color)
STRDECL("point", point)
STRDECL("vector", vector)
STRDECL("normal", normal)
STRDECL("matrix", matrix)
STRDECL("Rec709", Rec709)
STRDECL("sRGB", sRGB)
STRDECL("NTSC", NTSC)
STRDECL("EBU", EBU)
STRDECL("PAL", PAL)
STRDECL("SECAM", SECAM)
STRDECL("SMPTE", SMPTE)
STRDECL("HDTV", HDTV)
STRDECL("CIE", CIE)
STRDECL("AdobeRGB", AdobeRGB)
STRDECL("ACES2065-1", ACES2065_1)
STRDECL("ACEScg", ACEScg)
STRDECL("colorspace", colorspace)
STRDECL("colorsystem", colorsystem)
STRDECL("arraylength", arraylength)
STRDECL("unknown", unknown)
STRDECL("ERROR: Unknown color space transformation \"%s\" -> \"%s\"\n",
        ErrorColorTransform)
STRDECL("world", world)
