/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockruntime.model;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.awscore.eventstream.EventStreamResponseHandler;
import software.amazon.awssdk.services.bedrockruntime.model.ContentBlockDeltaEvent;
import software.amazon.awssdk.services.bedrockruntime.model.ContentBlockStartEvent;
import software.amazon.awssdk.services.bedrockruntime.model.ContentBlockStopEvent;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseStreamMetadataEvent;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseStreamOutput;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseStreamResponse;
import software.amazon.awssdk.services.bedrockruntime.model.DefaultConverseStreamResponseHandlerBuilder;
import software.amazon.awssdk.services.bedrockruntime.model.DefaultConverseStreamVisitorBuilder;
import software.amazon.awssdk.services.bedrockruntime.model.MessageStartEvent;
import software.amazon.awssdk.services.bedrockruntime.model.MessageStopEvent;

@SdkPublicApi
public interface ConverseStreamResponseHandler
extends EventStreamResponseHandler<ConverseStreamResponse, ConverseStreamOutput> {
    public static Builder builder() {
        return new DefaultConverseStreamResponseHandlerBuilder();
    }

    public static interface Visitor {
        public static Builder builder() {
            return new DefaultConverseStreamVisitorBuilder();
        }

        default public void visitDefault(ConverseStreamOutput event) {
        }

        default public void visitMessageStart(MessageStartEvent event) {
            this.visitDefault(event);
        }

        default public void visitContentBlockStart(ContentBlockStartEvent event) {
            this.visitDefault(event);
        }

        default public void visitContentBlockDelta(ContentBlockDeltaEvent event) {
            this.visitDefault(event);
        }

        default public void visitContentBlockStop(ContentBlockStopEvent event) {
            this.visitDefault(event);
        }

        default public void visitMessageStop(MessageStopEvent event) {
            this.visitDefault(event);
        }

        default public void visitMetadata(ConverseStreamMetadataEvent event) {
            this.visitDefault(event);
        }

        public static interface Builder {
            public Builder onDefault(Consumer<ConverseStreamOutput> var1);

            public Visitor build();

            public Builder onMessageStart(Consumer<MessageStartEvent> var1);

            public Builder onContentBlockStart(Consumer<ContentBlockStartEvent> var1);

            public Builder onContentBlockDelta(Consumer<ContentBlockDeltaEvent> var1);

            public Builder onContentBlockStop(Consumer<ContentBlockStopEvent> var1);

            public Builder onMessageStop(Consumer<MessageStopEvent> var1);

            public Builder onMetadata(Consumer<ConverseStreamMetadataEvent> var1);
        }
    }

    public static interface Builder
    extends EventStreamResponseHandler.Builder<ConverseStreamResponse, ConverseStreamOutput, Builder> {
        public Builder subscriber(Visitor var1);

        public ConverseStreamResponseHandler build();
    }
}

