/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.data.columnar;

import org.tribuo.Feature;

public class ColumnarFeature
extends Feature {
    private static final long serialVersionUID = 1L;
    public static final String CONJUNCTION = "CONJ";
    public static final String JOINER = "@";
    private final String fieldName;
    private final String firstFieldName;
    private final String secondFieldName;
    private final String columnEntry;

    public ColumnarFeature(String fieldName, double value) {
        super(fieldName, value);
        this.fieldName = fieldName;
        this.columnEntry = "";
        this.firstFieldName = "";
        this.secondFieldName = "";
    }

    public ColumnarFeature(String fieldName, String columnEntry, double value) {
        super(ColumnarFeature.generateFeatureName(fieldName, columnEntry), value);
        this.fieldName = fieldName;
        this.columnEntry = columnEntry;
        this.firstFieldName = "";
        this.secondFieldName = "";
    }

    public ColumnarFeature(String firstFieldName, String secondFieldName, String columnEntry, double value) {
        super(ColumnarFeature.generateFeatureName(firstFieldName, secondFieldName, columnEntry), value);
        this.fieldName = CONJUNCTION;
        this.columnEntry = columnEntry;
        this.firstFieldName = firstFieldName;
        this.secondFieldName = secondFieldName;
    }

    public static String generateFeatureName(String fieldName, String name) {
        return fieldName + JOINER + name;
    }

    public static String generateFeatureName(String firstFieldName, String secondFieldName, String name) {
        return "CONJ[" + firstFieldName + "," + secondFieldName + "]" + JOINER + name;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getFirstFieldName() {
        return this.firstFieldName;
    }

    public String getSecondFieldName() {
        return this.secondFieldName;
    }

    public String getColumnEntry() {
        return this.columnEntry;
    }
}

