/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.internal.pkcs12;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivateKey;
import oracle.security.pki.internal.asn1.ASN1GenericConstructed;
import oracle.security.pki.internal.asn1.ASN1Object;
import oracle.security.pki.internal.asn1.ASN1ObjectID;
import oracle.security.pki.internal.asn1.ASN1Sequence;
import oracle.security.pki.internal.asn1.ASN1Utils;
import oracle.security.pki.internal.pkcs12.PKCS12Bag;
import oracle.security.pki.internal.pkcs12.PKCS12Safe;
import oracle.security.pki.util.CryptoUtils;
import oracle.security.pki.util.StreamableInputException;
import oracle.security.pki.util.Utils;

public class PKCS12KeyBag
extends PKCS12Bag {
    private PKCS12Safe c;
    private PrivateKey d;
    private ASN1Sequence e;

    public PKCS12KeyBag() {
    }

    public PKCS12KeyBag(PKCS12Safe pKCS12Safe) {
        this.c = pKCS12Safe;
    }

    public PKCS12KeyBag(PKCS12Safe pKCS12Safe, PrivateKey privateKey) {
        this(pKCS12Safe);
        this.d = privateKey;
    }

    public PKCS12KeyBag(PKCS12Safe pKCS12Safe, InputStream inputStream) throws IOException {
        this(pKCS12Safe);
        this.input(inputStream);
    }

    public PKCS12KeyBag(PKCS12Safe pKCS12Safe, ASN1Sequence aSN1Sequence) throws IOException {
        this(pKCS12Safe);
        this.a(aSN1Sequence);
    }

    @Override
    void a() {
        this.e = null;
        if (this.c != null) {
            this.c.a();
        }
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        this.a(new ASN1Sequence(inputStream));
    }

    public void a(ASN1Sequence aSN1Sequence) throws IOException {
        this.a();
        ASN1GenericConstructed aSN1GenericConstructed = (ASN1GenericConstructed)aSN1Sequence.a(1);
        ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1GenericConstructed.a(0);
        this.d = CryptoUtils.inputPrivateKey(Utils.toStream(aSN1Sequence2));
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.g().output(outputStream);
    }

    private ASN1Sequence g() {
        if (this.e == null) {
            Object object;
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            aSN1Sequence.a(new ASN1ObjectID(ASN1Utils.e, 12, 10, 1, 1));
            try {
                object = new ByteArrayInputStream(this.d.getEncoded());
                aSN1Sequence.a(new ASN1GenericConstructed(ASN1Utils.a((InputStream)object), 0));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return null;
            }
            object = this.d();
            if (object != null) {
                aSN1Sequence.a((ASN1Object)object);
            }
            this.e = aSN1Sequence;
        }
        return this.e;
    }

    @Override
    public int length() {
        return this.g().length();
    }

    public PrivateKey e() {
        return this.d;
    }

    public ASN1Sequence f() {
        try {
            return new ASN1Sequence(new ByteArrayInputStream(this.d.getEncoded()));
        }
        catch (IOException iOException) {
            throw new StreamableInputException(iOException.toString());
        }
    }

    public void a(PrivateKey privateKey) {
        this.d = privateKey;
        this.a();
    }

    public String toString() {
        String string = "";
        if (this.a != null) {
            string = string + "friendlyName = \"" + this.a + "\", ";
        }
        if (this.b != null) {
            string = string + "localKeyID = " + Utils.toHexString(this.b) + ", ";
        }
        return string + this.d.toString();
    }
}

