/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool.dns;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import mediathek.config.Config;
import mediathek.tool.dns.IPvPreferenceMode;
import okhttp3.Dns;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lmediathek/tool/dns/DnsSelector;", "Lokhttp3/Dns;", "<init>", "()V", "lookup", "", "Ljava/net/InetAddress;", "hostname", "", "Companion", "MediathekView"})
@SourceDebugExtension(value={"SMAP\nDnsSelector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DnsSelector.kt\nmediathek/tool/dns/DnsSelector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,37:1\n1056#2:38\n1056#2:39\n774#2:40\n865#2,2:41\n774#2:43\n865#2,2:44\n*S KotlinDebug\n*F\n+ 1 DnsSelector.kt\nmediathek/tool/dns/DnsSelector\n*L\n18#1:38\n19#1:39\n20#1:40\n20#1:41,2\n21#1:43\n21#1:44,2\n*E\n"})
public final class DnsSelector
implements Dns {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger logger = LogManager.getLogger((String)DnsSelector.class.getName());

    @NotNull
    public List<InetAddress> lookup(@NotNull String hostname) {
        Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
        List addresses = Dns.SYSTEM.lookup(hostname);
        IPvPreferenceMode iPvPreferenceMode = Config.getDnsIpPreferenceMode();
        addresses = switch (iPvPreferenceMode == null ? -1 : WhenMappings.$EnumSwitchMapping$0[iPvPreferenceMode.ordinal()]) {
            case 1 -> {
                Iterable $this$sortedBy$iv = addresses;
                boolean $i$f$sortedBy = false;
                yield CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        InetAddress it = (InetAddress)a;
                        boolean bl = false;
                        Comparable comparable = Boolean.valueOf(Inet4Address.class.isInstance(it));
                        it = (InetAddress)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Boolean.valueOf(Inet4Address.class.isInstance(it)));
                    }
                });
            }
            case 2 -> {
                Iterable $this$sortedBy$iv = addresses;
                boolean $i$f$sortedBy = false;
                yield CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        InetAddress it = (InetAddress)a;
                        boolean bl = false;
                        Comparable comparable = Boolean.valueOf(Inet6Address.class.isInstance(it));
                        it = (InetAddress)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Boolean.valueOf(Inet6Address.class.isInstance(it)));
                    }
                });
            }
            case 3 -> {
                InetAddress it;
                Iterable $this$filterTo$iv$iv;
                Iterable $this$filter$iv = addresses;
                boolean $i$f$filter = false;
                Iterable var5_5 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (InetAddress)element$iv$iv;
                    boolean $i$a$-filter-DnsSelector$lookup$3 = false;
                    if (!Inet6Address.class.isInstance(it)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                yield (List)destination$iv$iv;
            }
            case 4 -> {
                InetAddress it;
                Iterable $this$filter$iv = addresses;
                boolean $i$f$filter = false;
                Iterable $this$filterTo$iv$iv = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (InetAddress)element$iv$iv;
                    boolean $i$a$-filter-DnsSelector$lookup$4 = false;
                    if (!Inet4Address.class.isInstance(it)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                yield (List)destination$iv$iv;
            }
            case 5 -> addresses;
            default -> {
                logger.error("IP Preference Mode was null, returning SYSTEM adresses");
                yield addresses;
            }
        };
        logger.trace("Dns (" + hostname + "): " + CollectionsKt.joinToString$default((Iterable)addresses, (CharSequence)", ", null, null, (int)0, null, DnsSelector::lookup$lambda$4, (int)30, null));
        return addresses;
    }

    private static final CharSequence lookup$lambda$4(InetAddress it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lmediathek/tool/dns/DnsSelector$Companion;", "", "<init>", "()V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "MediathekView"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IPvPreferenceMode.values().length];
            try {
                nArray[IPvPreferenceMode.IPV6_FIRST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IPvPreferenceMode.IPV4_FIRST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IPvPreferenceMode.IPV6_ONLY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IPvPreferenceMode.IPV4_ONLY.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IPvPreferenceMode.SYSTEM.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

