/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.events;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.cache.infinispan.RealmCacheManager;
import org.keycloak.models.cache.infinispan.events.BaseClientEvent;

@ProtoTypeId(value=65577)
public class ClientRemovedEvent
extends BaseClientEvent {
    @ProtoField(value=3)
    final String clientId;
    @ProtoField(value=4)
    final Map<String, String> clientRoles;

    @ProtoFactory
    ClientRemovedEvent(String id, String realmId, String clientId, Map<String, String> clientRoles) {
        super(id, realmId);
        this.clientId = Objects.requireNonNull(clientId);
        this.clientRoles = Objects.requireNonNull(clientRoles);
    }

    public static ClientRemovedEvent create(ClientModel client) {
        Map<String, String> clientRoles = client.getRolesStream().collect(Collectors.toMap(RoleModel::getId, RoleModel::getName));
        return new ClientRemovedEvent(client.getId(), client.getRealm().getId(), client.getClientId(), clientRoles);
    }

    @Override
    public String toString() {
        return String.format("ClientRemovedEvent [ realmId=%s, clientUuid=%s, clientId=%s, clientRoleIds=%s ]", this.realmId, this.getId(), this.clientId, this.clientRoles);
    }

    @Override
    public void addInvalidations(RealmCacheManager realmCache, Set<String> invalidations) {
        realmCache.clientRemoval(this.realmId, this.getId(), this.clientId, invalidations);
        for (Map.Entry<String, String> clientRole : this.clientRoles.entrySet()) {
            String roleId = clientRole.getKey();
            String roleName = clientRole.getValue();
            realmCache.roleRemoval(roleId, roleName, this.getId(), invalidations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClientRemovedEvent that = (ClientRemovedEvent)o;
        return this.clientId.equals(that.clientId) && this.clientRoles.equals(that.clientRoles);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.clientId.hashCode();
        result = 31 * result + this.clientRoles.hashCode();
        return result;
    }
}

