/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.CSSStylableElement;
import io.sf.carte.echosvg.css.engine.StyleMap;
import io.sf.carte.echosvg.css.engine.value.CSSProxyValueException;
import io.sf.carte.echosvg.css.engine.value.FloatValue;
import io.sf.carte.echosvg.css.engine.value.LengthManager;
import io.sf.carte.echosvg.css.engine.value.Messages;
import io.sf.carte.echosvg.css.engine.value.RectValue;
import io.sf.carte.echosvg.css.engine.value.RevertValue;
import io.sf.carte.echosvg.css.engine.value.UnsetValue;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.ValueConstants;
import org.w3c.dom.DOMException;

public abstract class RectManager
extends LengthManager {
    protected int orientation;

    @Override
    public Value createValue(LexicalUnit lunit, CSSEngine engine) throws DOMException {
        switch (lunit.getLexicalUnitType()) {
            case RECT_FUNCTION: {
                LexicalUnit lu = lunit.getParameters();
                try {
                    Value top = this.createRectComponent(lu);
                    lu = lu.getNextLexicalUnit();
                    if (lu == null || lu.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                        throw this.createMalformedRectDOMException();
                    }
                    lu = lu.getNextLexicalUnit();
                    Value right = this.createRectComponent(lu);
                    if ((lu = lu.getNextLexicalUnit()) == null || lu.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                        throw this.createMalformedRectDOMException();
                    }
                    lu = lu.getNextLexicalUnit();
                    Value bottom = this.createRectComponent(lu);
                    if ((lu = lu.getNextLexicalUnit()) == null || lu.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                        throw this.createMalformedRectDOMException();
                    }
                    lu = lu.getNextLexicalUnit();
                    Value left = this.createRectComponent(lu);
                    return new RectValue(top, right, bottom, left);
                }
                catch (CSSProxyValueException e) {
                    return this.createLexicalValue(lunit);
                }
            }
            case UNSET: {
                return UnsetValue.getInstance();
            }
            case REVERT: {
                return RevertValue.getInstance();
            }
            case INITIAL: {
                return this.getDefaultValue();
            }
            case VAR: 
            case ATTR: {
                return this.createLexicalValue(lunit);
            }
        }
        throw this.createMalformedRectDOMException();
    }

    private Value createRectComponent(LexicalUnit lu) throws DOMException {
        switch (lu.getLexicalUnitType()) {
            case IDENT: {
                if (!lu.getStringValue().equalsIgnoreCase("auto")) break;
                return ValueConstants.AUTO_VALUE;
            }
            case DIMENSION: {
                return this.createLength(lu);
            }
            case INTEGER: {
                return new FloatValue(0, lu.getIntegerValue());
            }
            case REAL: {
                return new FloatValue(0, lu.getFloatValue());
            }
            case PERCENTAGE: {
                return new FloatValue(2, lu.getFloatValue());
            }
            case VAR: 
            case ATTR: {
                throw new CSSProxyValueException();
            }
            case CALC: {
                return this.createCalc(lu);
            }
            case MATH_FUNCTION: {
                Value v;
                try {
                    v = this.createMathFunction(lu, "<length-percentage>");
                }
                catch (Exception e) {
                    DOMException mrd = this.createMalformedRectDOMException();
                    mrd.initCause(e);
                    throw mrd;
                }
                return v;
            }
        }
        throw this.createMalformedRectDOMException();
    }

    @Override
    public Value computeValue(CSSStylableElement elt, String pseudo, CSSEngine engine, int idx, StyleMap sm, Value value) {
        if (value.getPrimitiveType() != CSSValue.Type.RECT) {
            return value;
        }
        RectValue rect = value.getRectValue();
        this.orientation = 1;
        Value top = super.computeValue(elt, pseudo, engine, idx, sm, rect.getTop());
        Value bottom = super.computeValue(elt, pseudo, engine, idx, sm, rect.getBottom());
        this.orientation = 0;
        Value left = super.computeValue(elt, pseudo, engine, idx, sm, rect.getLeft());
        Value right = super.computeValue(elt, pseudo, engine, idx, sm, rect.getRight());
        if (top != rect.getTop() || right != rect.getRight() || bottom != rect.getBottom() || left != rect.getLeft()) {
            return new RectValue(top, right, bottom, left);
        }
        return value;
    }

    @Override
    protected int getOrientation() {
        return this.orientation;
    }

    private DOMException createMalformedRectDOMException() {
        Object[] p = new Object[]{this.getPropertyName()};
        String s = Messages.formatMessage("malformed.rect", p);
        return new DOMException(12, s);
    }
}

