﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/panorama/PanoramaRequest.h>
#include <aws/panorama/Panorama_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Http {
class URI;
}  // namespace Http
namespace Panorama {
namespace Model {

/**
 */
class DescribePackageVersionRequest : public PanoramaRequest {
 public:
  AWS_PANORAMA_API DescribePackageVersionRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DescribePackageVersion"; }

  AWS_PANORAMA_API Aws::String SerializePayload() const override;

  AWS_PANORAMA_API void AddQueryStringParameters(Aws::Http::URI& uri) const override;

  ///@{
  /**
   * <p>The version's owner account.</p>
   */
  inline const Aws::String& GetOwnerAccount() const { return m_ownerAccount; }
  inline bool OwnerAccountHasBeenSet() const { return m_ownerAccountHasBeenSet; }
  template <typename OwnerAccountT = Aws::String>
  void SetOwnerAccount(OwnerAccountT&& value) {
    m_ownerAccountHasBeenSet = true;
    m_ownerAccount = std::forward<OwnerAccountT>(value);
  }
  template <typename OwnerAccountT = Aws::String>
  DescribePackageVersionRequest& WithOwnerAccount(OwnerAccountT&& value) {
    SetOwnerAccount(std::forward<OwnerAccountT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The version's ID.</p>
   */
  inline const Aws::String& GetPackageId() const { return m_packageId; }
  inline bool PackageIdHasBeenSet() const { return m_packageIdHasBeenSet; }
  template <typename PackageIdT = Aws::String>
  void SetPackageId(PackageIdT&& value) {
    m_packageIdHasBeenSet = true;
    m_packageId = std::forward<PackageIdT>(value);
  }
  template <typename PackageIdT = Aws::String>
  DescribePackageVersionRequest& WithPackageId(PackageIdT&& value) {
    SetPackageId(std::forward<PackageIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The version's version.</p>
   */
  inline const Aws::String& GetPackageVersion() const { return m_packageVersion; }
  inline bool PackageVersionHasBeenSet() const { return m_packageVersionHasBeenSet; }
  template <typename PackageVersionT = Aws::String>
  void SetPackageVersion(PackageVersionT&& value) {
    m_packageVersionHasBeenSet = true;
    m_packageVersion = std::forward<PackageVersionT>(value);
  }
  template <typename PackageVersionT = Aws::String>
  DescribePackageVersionRequest& WithPackageVersion(PackageVersionT&& value) {
    SetPackageVersion(std::forward<PackageVersionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The version's patch version.</p>
   */
  inline const Aws::String& GetPatchVersion() const { return m_patchVersion; }
  inline bool PatchVersionHasBeenSet() const { return m_patchVersionHasBeenSet; }
  template <typename PatchVersionT = Aws::String>
  void SetPatchVersion(PatchVersionT&& value) {
    m_patchVersionHasBeenSet = true;
    m_patchVersion = std::forward<PatchVersionT>(value);
  }
  template <typename PatchVersionT = Aws::String>
  DescribePackageVersionRequest& WithPatchVersion(PatchVersionT&& value) {
    SetPatchVersion(std::forward<PatchVersionT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_ownerAccount;

  Aws::String m_packageId;

  Aws::String m_packageVersion;

  Aws::String m_patchVersion;
  bool m_ownerAccountHasBeenSet = false;
  bool m_packageIdHasBeenSet = false;
  bool m_packageVersionHasBeenSet = false;
  bool m_patchVersionHasBeenSet = false;
};

}  // namespace Model
}  // namespace Panorama
}  // namespace Aws
