﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/osis/OSIS_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace OSIS {
namespace Model {

/**
 * <p>Information about a pipeline's current status.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/PipelineStatusReason">AWS
 * API Reference</a></p>
 */
class PipelineStatusReason {
 public:
  AWS_OSIS_API PipelineStatusReason() = default;
  AWS_OSIS_API PipelineStatusReason(Aws::Utils::Json::JsonView jsonValue);
  AWS_OSIS_API PipelineStatusReason& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_OSIS_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>A description of why a pipeline has a certain status.</p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  inline bool DescriptionHasBeenSet() const { return m_descriptionHasBeenSet; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  PipelineStatusReason& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_description;
  bool m_descriptionHasBeenSet = false;
};

}  // namespace Model
}  // namespace OSIS
}  // namespace Aws
