﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/dynamodb/DynamoDB_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace DynamoDB {
namespace Model {

/**
 * <p>Specifies the action to remove a witness Region from a MRSC global table. You
 * cannot delete a single witness from a MRSC global table - you must delete both a
 * replica and the witness together. The deletion of both a witness and replica
 * converts the remaining replica to a single-Region DynamoDB table. </p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DeleteGlobalTableWitnessGroupMemberAction">AWS
 * API Reference</a></p>
 */
class DeleteGlobalTableWitnessGroupMemberAction {
 public:
  AWS_DYNAMODB_API DeleteGlobalTableWitnessGroupMemberAction() = default;
  AWS_DYNAMODB_API DeleteGlobalTableWitnessGroupMemberAction(Aws::Utils::Json::JsonView jsonValue);
  AWS_DYNAMODB_API DeleteGlobalTableWitnessGroupMemberAction& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_DYNAMODB_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The witness Region name to be removed from the MRSC global table.</p>
   */
  inline const Aws::String& GetRegionName() const { return m_regionName; }
  inline bool RegionNameHasBeenSet() const { return m_regionNameHasBeenSet; }
  template <typename RegionNameT = Aws::String>
  void SetRegionName(RegionNameT&& value) {
    m_regionNameHasBeenSet = true;
    m_regionName = std::forward<RegionNameT>(value);
  }
  template <typename RegionNameT = Aws::String>
  DeleteGlobalTableWitnessGroupMemberAction& WithRegionName(RegionNameT&& value) {
    SetRegionName(std::forward<RegionNameT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_regionName;
  bool m_regionNameHasBeenSet = false;
};

}  // namespace Model
}  // namespace DynamoDB
}  // namespace Aws
