/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jandex;

import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;

public final class ArrayType
extends Type {
    private final Type constituent;
    private final int dimensions;
    private int hash;

    public static ArrayType create(Type constituent, int dimensions) {
        return new ArrayType(constituent, dimensions);
    }

    public static Builder builder(Type constituent, int dimensions) {
        return new Builder(constituent, dimensions);
    }

    ArrayType(Type constituent, int dimensions) {
        this(constituent, dimensions, null);
    }

    ArrayType(Type constituent, int dimensions, AnnotationInstance[] annotations) {
        super(DotName.OBJECT_NAME, annotations);
        this.dimensions = dimensions;
        this.constituent = constituent;
        if (dimensions < 1) {
            throw new IllegalArgumentException("Number of dimensions of an array type must be >= 1");
        }
    }

    @Deprecated
    public Type component() {
        return this.constituent;
    }

    public Type constituent() {
        return this.constituent;
    }

    public Type elementType() {
        Type element = this.constituent;
        while (element.kind() == Type.Kind.ARRAY) {
            element = element.asArrayType().constituent;
        }
        return element;
    }

    public Type componentType() {
        if (this.dimensions == 1) {
            return this.constituent;
        }
        return new ArrayType(this.constituent, this.dimensions - 1);
    }

    public int dimensions() {
        return this.dimensions;
    }

    public int deepDimensions() {
        int result = this.dimensions;
        Type constituent = this.constituent;
        while (constituent.kind() == Type.Kind.ARRAY) {
            result += constituent.asArrayType().dimensions;
            constituent = constituent.asArrayType().constituent;
        }
        return result;
    }

    @Override
    public DotName name() {
        StringBuilder builder = new StringBuilder();
        Type type = this;
        while (((Type)type).kind() == Type.Kind.ARRAY) {
            int dimensions = ((Type)type).asArrayType().dimensions;
            while (dimensions-- > 0) {
                builder.append('[');
            }
            type = ((Type)type).asArrayType().constituent;
        }
        if (((Type)type).kind() == Type.Kind.PRIMITIVE) {
            builder.append(type.asPrimitiveType().toCode());
        } else {
            builder.append('L').append(((Type)type).name().toString()).append(';');
        }
        return DotName.createSimple(builder.toString());
    }

    @Override
    public Type.Kind kind() {
        return Type.Kind.ARRAY;
    }

    @Override
    public ArrayType asArrayType() {
        return this;
    }

    @Override
    Type copyType(AnnotationInstance[] newAnnotations) {
        return new ArrayType(this.constituent, this.dimensions, newAnnotations);
    }

    Type copyType(Type component, int dimensions) {
        return new ArrayType(component, dimensions, this.annotationArray());
    }

    @Override
    String toString(boolean simple) {
        StringBuilder builder = new StringBuilder();
        this.appendRootComponent(builder, true);
        this.appendArraySyntax(builder);
        return builder.toString();
    }

    private void appendRootComponent(StringBuilder builder, boolean simple) {
        if (this.constituent.kind() == Type.Kind.ARRAY) {
            this.constituent.asArrayType().appendRootComponent(builder, simple);
        } else {
            builder.append(this.constituent.toString(simple));
        }
    }

    private void appendArraySyntax(StringBuilder builder) {
        if (this.annotationArray().length > 0) {
            builder.append(' ');
            this.appendAnnotations(builder);
        }
        for (int i = 0; i < this.dimensions; ++i) {
            builder.append("[]");
        }
        if (this.constituent.kind() == Type.Kind.ARRAY) {
            this.constituent.asArrayType().appendArraySyntax(builder);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArrayType)) {
            return false;
        }
        ArrayType arrayType = (ArrayType)o;
        return super.equals(o) && this.dimensions == arrayType.dimensions && this.constituent.equals(arrayType.constituent);
    }

    @Override
    public int hashCode() {
        int hash = this.hash;
        if (hash != 0) {
            return hash;
        }
        hash = super.hashCode();
        hash = 31 * hash + this.constituent.hashCode();
        this.hash = hash = 31 * hash + this.dimensions;
        return this.hash;
    }

    @Override
    boolean internEquals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArrayType)) {
            return false;
        }
        ArrayType arrayType = (ArrayType)o;
        return super.internEquals(o) && this.dimensions == arrayType.dimensions && this.constituent.internEquals(arrayType.constituent);
    }

    @Override
    int internHashCode() {
        int hash = super.internHashCode();
        hash = 31 * hash + this.constituent.internHashCode();
        hash = 31 * hash + this.dimensions;
        return hash;
    }

    public static final class Builder
    extends Type.Builder<Builder> {
        private final Type constituent;
        private final int dimensions;

        Builder(Type constituent, int dimensions) {
            super(DotName.OBJECT_NAME);
            this.constituent = constituent;
            this.dimensions = dimensions;
        }

        public ArrayType build() {
            return new ArrayType(this.constituent, this.dimensions, this.annotationsArray());
        }
    }
}

