/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.core.config;

import java.util.Iterator;
import java.util.Properties;
import java.util.ServiceLoader;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.core.config.Configuration;
import org.opensaml.core.config.ConfigurationProperties;
import org.opensaml.core.config.ConfigurationPropertiesSource;
import org.opensaml.core.config.provider.EmptyConfigurationProperties;
import org.opensaml.core.config.provider.MapBasedConfiguration;
import org.opensaml.core.config.provider.PropertiesAdapter;
import org.slf4j.Logger;

public class ConfigurationService {
    @Nonnull
    @NotEmpty
    public static final String DEFAULT_PARTITION_NAME = "default";
    @Nonnull
    @NotEmpty
    public static final String PROPERTY_PARTITION_NAME = "opensaml.config.partitionName";
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationService.class);
    @Nonnull
    private static ServiceLoader<ConfigurationPropertiesSource> configPropertiesLoader = ServiceLoader.load(ConfigurationPropertiesSource.class);
    @Nullable
    private static Configuration configuration;
    @Nullable
    private static ConfigurationPropertiesSource defaultConfigurationPropertiesSource;

    protected ConfigurationService() {
    }

    @Nullable
    public static <T> T get(@Nonnull Class<T> configClass) {
        String partitionName = ConfigurationService.getPartitionName();
        return ConfigurationService.getConfiguration().get(configClass, partitionName);
    }

    @Nonnull
    public static <T> T ensure(@Nonnull Class<T> configClass) {
        String partitionName = ConfigurationService.getPartitionName();
        T config = ConfigurationService.getConfiguration().get(configClass, partitionName);
        if (config == null) {
            throw new IllegalStateException("Configuration instance of type " + configClass.getName() + " was unavailable");
        }
        return config;
    }

    public static <T, I extends T> void register(@Nonnull Class<T> configClass, @Nonnull I configInstance) {
        String partitionName = ConfigurationService.getPartitionName();
        ConfigurationService.getConfiguration().register(configClass, configInstance, partitionName);
    }

    @Nullable
    public static <T> T deregister(@Nonnull Class<T> configClass) {
        String partitionName = ConfigurationService.getPartitionName();
        return ConfigurationService.getConfiguration().deregister(configClass, partitionName);
    }

    @Nonnull
    public static ConfigurationProperties getConfigurationProperties() {
        ConfigurationPropertiesSource defaultSource = defaultConfigurationPropertiesSource;
        if (defaultSource != null) {
            ConfigurationProperties props = defaultSource.getProperties();
            if (props != null) {
                LOG.trace("Resolved configuration properties from configured default properties source: {}", (Object)defaultSource.getClass().getName());
                return props;
            }
            LOG.trace("A default properties source was configured, but produced a null properties set");
        } else {
            LOG.trace("No default configuration properties source was configured");
        }
        LOG.trace("Attempting to resolve configuration properties source candidates via Java Services API");
        Iterator<ConfigurationPropertiesSource> iter = configPropertiesLoader.iterator();
        if (!iter.hasNext()) {
            LOG.trace("No ConfigurationPropertiesSources are configured, defaulting to system properties");
            Properties systemProps = System.getProperties();
            return systemProps != null ? new PropertiesAdapter(systemProps) : new EmptyConfigurationProperties();
        }
        while (iter.hasNext()) {
            ConfigurationPropertiesSource source = iter.next();
            LOG.trace("Evaluating configuration properties implementation: {}", (Object)source.getClass().getName());
            ConfigurationProperties props = source.getProperties();
            if (props == null) continue;
            LOG.trace("Resolved non-null configuration properties using implementation: {}", (Object)source.getClass().getName());
            return props;
        }
        LOG.trace("Unable to resolve non-null configuration properties from any ConfigurationPropertiesSource");
        return new EmptyConfigurationProperties();
    }

    @Nullable
    public static ConfigurationPropertiesSource getDefaultConfigurationPropertiesSource() {
        return defaultConfigurationPropertiesSource;
    }

    public static void setDefaultConfigurationPropertiesSource(@Nullable ConfigurationPropertiesSource source) {
        defaultConfigurationPropertiesSource = source;
    }

    public static void setConfiguration(@Nonnull Configuration newConfiguration) {
        configuration = (Configuration)Constraint.isNotNull((Object)newConfiguration, (String)"Configuration cannot be null");
    }

    @Nonnull
    @NotEmpty
    protected static String getPartitionName() {
        ConfigurationProperties configProperties = ConfigurationService.getConfigurationProperties();
        String partitionName = configProperties.getProperty(PROPERTY_PARTITION_NAME, DEFAULT_PARTITION_NAME);
        LOG.trace("Resolved effective configuration partition name '{}'", (Object)partitionName);
        return partitionName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Nonnull
    protected static Configuration getConfiguration() {
        if (configuration == null) {
            Class<ConfigurationService> clazz = ConfigurationService.class;
            // MONITORENTER : org.opensaml.core.config.ConfigurationService.class
            ServiceLoader<Configuration> loader = ServiceLoader.load(Configuration.class);
            Iterator<Configuration> iter = loader.iterator();
            configuration = iter.hasNext() ? iter.next() : new MapBasedConfiguration();
            // MONITOREXIT : clazz
        }
        if ($assertionsDisabled) return configuration;
        if (configuration != null) return configuration;
        throw new AssertionError();
    }
}

