/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.meta;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.SAXParser;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.meta.ClassMetaDataIterator;
import org.apache.openjpa.lib.meta.FileMetaDataIterator;
import org.apache.openjpa.lib.meta.MetaDataIterator;
import org.apache.openjpa.lib.meta.MetaDataParser;
import org.apache.openjpa.lib.meta.ResourceMetaDataIterator;
import org.apache.openjpa.lib.meta.SuffixMetaDataFilter;
import org.apache.openjpa.lib.meta.URLMetaDataIterator;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.xml.Commentable;
import org.apache.openjpa.lib.xml.DocTypeReader;
import org.apache.openjpa.lib.xml.Location;
import org.apache.openjpa.lib.xml.XMLFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public abstract class XMLMetaDataParser
extends DefaultHandler
implements LexicalHandler,
MetaDataParser {
    private static final Localizer _loc = Localizer.forPackage(XMLMetaDataParser.class);
    private static boolean _schemaBug;
    private static final String OPENJPA_NAMESPACE = "http://openjpa.apache.org/ns/orm";
    protected int _extendedNamespace = 0;
    protected int _openjpaNamespace = 0;
    private Map<ClassLoader, Set<String>> _parsed = null;
    private Log _log = null;
    private boolean _validating = true;
    private boolean _systemId = true;
    private boolean _caching = true;
    private boolean _parseText = true;
    private boolean _parseComments = true;
    private String _suffix = null;
    private ClassLoader _loader = null;
    private ClassLoader _curLoader = null;
    private final Collection _curResults = new LinkedList();
    private List _results = null;
    private String _sourceName = null;
    private File _sourceFile = null;
    private StringBuffer _text = null;
    private List<String> _comments = null;
    private Location _location = new Location();
    private LexicalHandler _lh = null;
    private int _depth = -1;
    private int _ignore = Integer.MAX_VALUE;
    private boolean _parsing = false;
    private boolean _overrideContextClassloader = true;

    public boolean getOverrideContextClassloader() {
        return this._overrideContextClassloader;
    }

    public void setOverrideContextClassloader(boolean overrideCCL) {
        this._overrideContextClassloader = overrideCCL;
    }

    public boolean isParsing() {
        return this._parsing;
    }

    public void setParsing(boolean parsing) {
        this._parsing = parsing;
    }

    public boolean getParseText() {
        return this._parseText;
    }

    public void setParseText(boolean text) {
        this._parseText = text;
    }

    public boolean getParseComments() {
        return this._parseComments;
    }

    public void setParseComments(boolean comments) {
        this._parseComments = comments;
    }

    public Location getLocation() {
        return this._location;
    }

    public LexicalHandler getLexicalHandler() {
        return this._lh;
    }

    public void setLexicalHandler(LexicalHandler lh) {
        this._lh = lh;
    }

    public void setLocation(Location location) {
        this._location = location;
    }

    public boolean getSourceIsSystemId() {
        return this._systemId;
    }

    public void setSourceIsSystemId(boolean systemId) {
        this._systemId = systemId;
    }

    public boolean isValidating() {
        return this._validating;
    }

    public void setValidating(boolean validating) {
        this._validating = validating;
    }

    public String getSuffix() {
        return this._suffix;
    }

    public void setSuffix(String suffix) {
        this._suffix = suffix;
    }

    public boolean isCaching() {
        return this._caching;
    }

    public void setCaching(boolean caching) {
        this._caching = caching;
        if (!caching) {
            this.clear();
        }
    }

    public Log getLog() {
        return this._log;
    }

    public void setLog(Log log) {
        this._log = log;
    }

    public ClassLoader getClassLoader() {
        return this._loader;
    }

    @Override
    public void setClassLoader(ClassLoader loader) {
        this._loader = loader;
    }

    @Override
    public List getResults() {
        if (this._results == null) {
            return Collections.emptyList();
        }
        return this._results;
    }

    @Override
    public void parse(String rsrc) throws IOException {
        if (rsrc != null) {
            this.parse(new ResourceMetaDataIterator(rsrc, this._loader));
        }
    }

    @Override
    public void parse(URL url) throws IOException {
        if (url != null) {
            this.parse(new URLMetaDataIterator(url));
        }
    }

    @Override
    public void parse(File file) throws IOException {
        if (file == null) {
            return;
        }
        if (!AccessController.doPrivileged(J2DoPrivHelper.isDirectoryAction(file)).booleanValue()) {
            this.parse(new FileMetaDataIterator(file));
        } else {
            String suff = this._suffix == null ? "" : this._suffix;
            this.parse(new FileMetaDataIterator(file, new SuffixMetaDataFilter(suff)));
        }
    }

    public void parse(Class cls, boolean topDown) throws IOException {
        String suff = this._suffix == null ? "" : this._suffix;
        this.parse(new ClassMetaDataIterator(cls, suff, topDown), !topDown);
    }

    @Override
    public void parse(Reader xml, String sourceName) throws IOException {
        if (!(xml == null || sourceName != null && this.parsed(sourceName))) {
            this.parseNewResource(xml, sourceName);
        }
    }

    @Override
    public void parse(MetaDataIterator itr) throws IOException {
        this.parse(itr, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(MetaDataIterator itr, boolean stopFirst) throws IOException {
        if (itr == null) {
            return;
        }
        try {
            while (itr.hasNext()) {
                String sourceName = itr.next().toString();
                if (this.parsed(sourceName)) {
                    if (!stopFirst) continue;
                } else {
                    this._sourceFile = itr.getFile();
                    this.parseNewResource(new InputStreamReader(itr.getInputStream()), sourceName);
                    if (!stopFirst) continue;
                }
                break;
            }
        }
        finally {
            itr.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseNewResource(Reader xml, String sourceName) throws IOException {
        Object schemaSource;
        if (this._log != null && this._log.isTraceEnabled()) {
            this._log.trace(_loc.get("start-parse", sourceName));
        }
        if ((schemaSource = this.getSchemaSource()) != null && _schemaBug) {
            if (this._log != null && this._log.isTraceEnabled()) {
                this._log.trace(_loc.get("parser-schema-bug"));
            }
            schemaSource = null;
        }
        boolean validating = this._validating && (this.getDocType() != null || schemaSource != null);
        try {
            this.setParsing(true);
            this._sourceName = sourceName;
            SAXParser parser = null;
            boolean overrideCL = this._overrideContextClassloader;
            ClassLoader oldLoader = null;
            ClassLoader newLoader = null;
            try {
                if (overrideCL) {
                    oldLoader = AccessController.doPrivileged(J2DoPrivHelper.getContextClassLoaderAction());
                    newLoader = XMLMetaDataParser.class.getClassLoader();
                    AccessController.doPrivileged(J2DoPrivHelper.setContextClassLoaderAction(newLoader));
                    if (this._log != null && this._log.isTraceEnabled()) {
                        this._log.trace(_loc.get("override-contextclassloader-begin", oldLoader, newLoader));
                    }
                }
                parser = XMLFactory.getSAXParser(validating, true);
                Object schema = null;
                if (validating && (schema = schemaSource) == null && this.getDocType() != null) {
                    xml = new DocTypeReader(xml, this.getDocType());
                }
                if (this._parseComments || this._lh != null) {
                    parser.setProperty("http://xml.org/sax/properties/lexical-handler", this);
                }
                if (schema != null) {
                    parser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
                    parser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaSource", schema);
                }
                InputSource is = new InputSource(xml);
                if (this._systemId && sourceName != null) {
                    is.setSystemId(sourceName);
                }
                parser.parse(is, (DefaultHandler)this);
                this.finish();
            }
            catch (SAXException se) {
                IOException ioe = new IOException(se.toString(), se);
                throw ioe;
            }
            finally {
                block24: {
                    if (overrideCL) {
                        try {
                            if (this._log != null && this._log.isTraceEnabled()) {
                                this._log.trace(_loc.get("override-contextclassloader-end", newLoader, oldLoader));
                            }
                            AccessController.doPrivileged(J2DoPrivHelper.setContextClassLoaderAction(oldLoader));
                        }
                        catch (Throwable t) {
                            if (this._log == null || !this._log.isWarnEnabled()) break block24;
                            this._log.warn(_loc.get("restore-contextclassloader-failed"));
                        }
                    }
                }
            }
        }
        finally {
            this.reset();
        }
    }

    protected boolean parsed(String src) {
        ClassLoader loader;
        Set set;
        boolean added;
        if (!this._caching) {
            return false;
        }
        if (this._parsed == null) {
            this._parsed = new HashMap<ClassLoader, Set<String>>();
        }
        if (!(added = (set = this._parsed.computeIfAbsent(loader = this.currentClassLoader(), k -> new HashSet())).add(src)) && this._log != null && this._log.isTraceEnabled()) {
            this._log.trace(_loc.get("already-parsed", src));
        }
        return !added;
    }

    @Override
    public void clear() {
        if (this._log != null && this._log.isTraceEnabled()) {
            this._log.trace(_loc.get("clear-parser", this));
        }
        if (this._parsed != null) {
            this._parsed.clear();
        }
    }

    @Override
    public void error(SAXParseException se) throws SAXException {
        throw this.getException(se.toString());
    }

    @Override
    public void fatalError(SAXParseException se) throws SAXException {
        throw this.getException(se.toString());
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this._location.setLocator(locator);
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes attrs) throws SAXException {
        ++this._depth;
        if (this._depth <= this._ignore) {
            if (uri.equals(OPENJPA_NAMESPACE)) {
                ++this._extendedNamespace;
                ++this._openjpaNamespace;
            }
            if (!this.startElement(qName, attrs)) {
                this.ignoreContent(true);
            }
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) throws SAXException {
        if (this._depth < this._ignore) {
            this.endElement(qName);
            this._extendedNamespace = this._extendedNamespace > 0 ? this._extendedNamespace - 1 : 0;
            this._openjpaNamespace = this._openjpaNamespace > 0 ? this._openjpaNamespace - 1 : 0;
        } else if (this._depth == this._ignore) {
            this._extendedNamespace = this._extendedNamespace > 0 ? this._extendedNamespace - 1 : 0;
            this._openjpaNamespace = this._openjpaNamespace > 0 ? this._openjpaNamespace - 1 : 0;
        }
        this._text = null;
        if (this._comments != null) {
            this._comments.clear();
        }
        if (this._depth == this._ignore) {
            this._ignore = Integer.MAX_VALUE;
        }
        --this._depth;
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this._parseText && this._depth <= this._ignore) {
            if (this._text == null) {
                this._text = new StringBuffer();
            }
            this._text.append(ch, start, length);
        }
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        if (this._parseComments && this._depth <= this._ignore) {
            if (this._comments == null) {
                this._comments = new ArrayList<String>(3);
            }
            this._comments.add(String.valueOf(ch, start, length));
        }
        if (this._lh != null) {
            this._lh.comment(ch, start, length);
        }
    }

    @Override
    public void startCDATA() throws SAXException {
        if (this._lh != null) {
            this._lh.startCDATA();
        }
    }

    @Override
    public void endCDATA() throws SAXException {
        if (this._lh != null) {
            this._lh.endCDATA();
        }
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        if (this._lh != null) {
            this._lh.startDTD(name, publicId, systemId);
        }
    }

    @Override
    public void endDTD() throws SAXException {
        if (this._lh != null) {
            this._lh.endDTD();
        }
    }

    @Override
    public void startEntity(String name) throws SAXException {
        if (this._lh != null) {
            this._lh.startEntity(name);
        }
    }

    @Override
    public void endEntity(String name) throws SAXException {
        if (this._lh != null) {
            this._lh.endEntity(name);
        }
    }

    protected abstract boolean startElement(String var1, Attributes var2) throws SAXException;

    protected abstract void endElement(String var1) throws SAXException;

    protected void addResult(Object result) {
        if (this._log != null && this._log.isTraceEnabled()) {
            this._log.trace(_loc.get("add-result", result));
        }
        this._curResults.add(result);
    }

    protected void finish() {
        if (this._log != null && this._log.isTraceEnabled()) {
            this._log.trace(_loc.get("end-parse", this.getSourceName()));
        }
        this._results = new ArrayList(this._curResults);
    }

    protected void reset() {
        this._curResults.clear();
        this._curLoader = null;
        this._sourceName = null;
        this._sourceFile = null;
        this._depth = -1;
        this._ignore = Integer.MAX_VALUE;
        if (this._comments != null) {
            this._comments.clear();
        }
        this.clearDeferredMetaData();
        this.setParsing(false);
    }

    protected Object getSchemaSource() throws IOException {
        return null;
    }

    protected Reader getDocType() throws IOException {
        return null;
    }

    protected String getSourceName() {
        return this._sourceName;
    }

    protected File getSourceFile() {
        return this._sourceFile;
    }

    protected void addComments(Object obj) {
        String[] comments = this.currentComments();
        if (comments.length > 0 && obj instanceof Commentable) {
            ((Commentable)obj).setComments(comments);
        }
    }

    protected String[] currentComments() {
        if (this._comments == null || this._comments.isEmpty()) {
            return Commentable.EMPTY_COMMENTS;
        }
        return this._comments.toArray(new String[this._comments.size()]);
    }

    protected String currentText() {
        if (this._text == null) {
            return "";
        }
        return this._text.toString().trim();
    }

    protected String currentLocation() {
        return " [" + String.valueOf(_loc.get("loc-prefix")) + this._location.getLocation() + "]";
    }

    protected int currentDepth() {
        return this._depth;
    }

    protected ClassLoader currentClassLoader() {
        if (this._loader != null) {
            return this._loader;
        }
        if (this._curLoader == null) {
            this._curLoader = AccessController.doPrivileged(J2DoPrivHelper.getContextClassLoaderAction());
        }
        return this._curLoader;
    }

    protected void ignoreContent(boolean ignoreEnd) {
        this._ignore = this._depth;
        if (!ignoreEnd) {
            ++this._ignore;
        }
    }

    protected SAXException getException(String msg) {
        return new SAXException(this.getSourceName() + this.currentLocation() + ": " + msg);
    }

    protected SAXException getException(Localizer.Message msg) {
        return new SAXException(this.getSourceName() + this.currentLocation() + ": " + msg.getMessage());
    }

    protected SAXException getException(Localizer.Message msg, Throwable cause) {
        if (cause != null && this._log != null && this._log.isTraceEnabled()) {
            this._log.trace(_loc.get("sax-exception", this.getSourceName(), this._location.getLocation()), cause);
        }
        SAXException e = new SAXException(this.getSourceName() + this.currentLocation() + ": " + String.valueOf(msg) + " [" + String.valueOf(cause) + "]");
        e.initCause(cause);
        return e;
    }

    protected void clearDeferredMetaData() {
    }

    static {
        try {
            _schemaBug = "Xerces-J 2.0.2".equals(Class.forName("org.apache.xerces.impl.Version").getField("fVersion").get(null));
        }
        catch (Throwable t) {
            _schemaBug = false;
        }
    }
}

