/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http.parser;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tomcat.util.http.parser.HttpParser;
import org.apache.tomcat.util.http.parser.SkipResult;

public class TE {
    private final String encoding;
    private final Map<String, String> parameters;
    private final double quality;

    protected TE(String encoding, Map<String, String> parameters, double quality) {
        this.encoding = encoding;
        this.parameters = parameters;
        this.quality = quality;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public double getQuality() {
        return this.quality;
    }

    public static List<TE> parse(StringReader input) throws IOException {
        ArrayList<TE> result = new ArrayList<TE>();
        while (true) {
            String encoding;
            if ((encoding = HttpParser.readToken(input)) == null) {
                HttpParser.skipUntil(input, 0, ',');
                continue;
            }
            if (encoding.isEmpty()) break;
            HashMap<String, String> parameters = new HashMap<String, String>();
            while (HttpParser.skipConstant(input, ";") == SkipResult.FOUND) {
                String name = HttpParser.readToken(input);
                String value = null;
                if (HttpParser.skipConstant(input, "=") == SkipResult.FOUND) {
                    value = HttpParser.readTokenOrQuotedString(input, true);
                }
                if (name == null || value == null) continue;
                parameters.put(name, value);
            }
            double quality = 1.0;
            String q = (String)parameters.remove("q");
            if (q != null) {
                quality = HttpParser.readWeight(new StringReader("q=" + q), ',');
            }
            if (!(quality > 0.0)) continue;
            result.add(new TE(encoding, parameters, quality));
        }
        return result;
    }
}

