/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.EvalMode$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.GetTimestamp;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.ParseToDate$;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.TypeCollection;
import org.apache.spark.sql.types.TypeCollection$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple4;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(date_str[, fmt]) - Parses the `date_str` expression with the `fmt` expression to\n      a date. Returns null with invalid input. By default, it follows casting rules to a date if\n      the `fmt` is omitted.\n  ", arguments="\n    Arguments:\n      * date_str - A string to be parsed to date.\n      * fmt - Date format pattern to follow. See <a href=\"https://spark.apache.org/docs/latest/sql-ref-datetime-pattern.html\">Datetime Patterns</a> for valid\n              date and time format patterns.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('2009-07-30 04:17:52');\n       2009-07-30\n      > SELECT _FUNC_('2016-12-31', 'yyyy-MM-dd');\n       2016-12-31\n  ", group="datetime_funcs", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\t-c\u0001B\u0015+\u0001^B\u0001B\u0014\u0001\u0003\u0016\u0004%\ta\u0014\u0005\t!\u0002\u0011\t\u0012)A\u0005q!A\u0011\u000b\u0001BK\u0002\u0013\u0005!\u000b\u0003\u0005W\u0001\tE\t\u0015!\u0003T\u0011!9\u0006A!f\u0001\n\u0003A\u0006\u0002C3\u0001\u0005#\u0005\u000b\u0011B-\t\u0011\u0019\u0004!Q3A\u0005\u0002\u001dD\u0001b\u001b\u0001\u0003\u0012\u0003\u0006I\u0001\u001b\u0005\u0006Y\u0002!\t!\u001c\u0005\tg\u0002A)\u0019!C!\u001f\")A\u000e\u0001C\u0001i\")A\u000e\u0001C\u0001o\")\u0011\u0010\u0001C!u\")1\u0010\u0001C!y\")a\u0010\u0001C!\u007f\"9\u0011Q\b\u0001\u0005B\u0005}\u0002bBA\"\u0001\u0011\u0005\u0013Q\t\u0005\b\u0003+\u0002A\u0011KA,\u0011%\t\u0019\u0007AA\u0001\n\u0003\t)\u0007C\u0005\u0002p\u0001\t\n\u0011\"\u0001\u0002r!I\u0011q\u0011\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u0012\u0005\n\u0003\u001b\u0003\u0011\u0013!C\u0001\u0003\u001fC\u0011\"a%\u0001#\u0003%\t!!&\t\u0013\u0005e\u0005!!A\u0005B\u0005m\u0005\"CAV\u0001\u0005\u0005I\u0011AAW\u0011%\t)\fAA\u0001\n\u0003\t9\fC\u0005\u0002D\u0002\t\t\u0011\"\u0011\u0002F\"I\u00111\u001b\u0001\u0002\u0002\u0013\u0005\u0011Q\u001b\u0005\n\u00033\u0004\u0011\u0011!C!\u00037<\u0011B!\u0002+\u0003\u0003E\tAa\u0002\u0007\u0011%R\u0013\u0011!E\u0001\u0005\u0013Aa\u0001\\\u0010\u0005\u0002\t]\u0001\"\u0003B\r?\u0005\u0005IQ\tB\u000e\u0011%\u0011ibHA\u0001\n\u0003\u0013y\u0002C\u0005\u0003*}\t\n\u0011\"\u0001\u0002\u0010\"I!1F\u0010\u0012\u0002\u0013\u0005\u0011Q\u0013\u0005\n\u0005[y\u0012\u0011!CA\u0005_A\u0011B!\u0010 #\u0003%\t!a$\t\u0013\t}r$%A\u0005\u0002\u0005U\u0005\"\u0003B!?\u0005\u0005I\u0011\u0002B\"\u0005-\u0001\u0016M]:f)>$\u0015\r^3\u000b\u0005-b\u0013aC3yaJ,7o]5p]NT!!\f\u0018\u0002\u0011\r\fG/\u00197zgRT!a\f\u0019\u0002\u0007M\fHN\u0003\u00022e\u0005)1\u000f]1sW*\u00111\u0007N\u0001\u0007CB\f7\r[3\u000b\u0003U\n1a\u001c:h\u0007\u0001\u0019r\u0001\u0001\u001d=\u007f\t+5\n\u0005\u0002:u5\t!&\u0003\u0002<U\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005ej\u0014B\u0001 +\u0005I\u0011VO\u001c;j[\u0016\u0014V\r\u001d7bG\u0016\f'\r\\3\u0011\u0005e\u0002\u0015BA!+\u0005YIU\u000e\u001d7jG&$8)Y:u\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bCA\u001dD\u0013\t!%FA\fUS6,'l\u001c8f\u0003^\f'/Z#yaJ,7o]5p]B\u0011a)S\u0007\u0002\u000f*\t\u0001*A\u0003tG\u0006d\u0017-\u0003\u0002K\u000f\n9\u0001K]8ek\u000e$\bC\u0001$M\u0013\tiuI\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0003mK\u001a$X#\u0001\u001d\u0002\u000b1,g\r\u001e\u0011\u0002\r\u0019|'/\\1u+\u0005\u0019\u0006c\u0001$Uq%\u0011Qk\u0012\u0002\u0007\u001fB$\u0018n\u001c8\u0002\u000f\u0019|'/\\1uA\u0005QA/[7f5>tW-\u00133\u0016\u0003e\u00032A\u0012+[!\tY&M\u0004\u0002]AB\u0011QlR\u0007\u0002=*\u0011qLN\u0001\u0007yI|w\u000e\u001e \n\u0005\u0005<\u0015A\u0002)sK\u0012,g-\u0003\u0002dI\n11\u000b\u001e:j]\u001eT!!Y$\u0002\u0017QLW.\u001a.p]\u0016LE\rI\u0001\fC:\u001c\u0018.\u00128bE2,G-F\u0001i!\t1\u0015.\u0003\u0002k\u000f\n9!i\\8mK\u0006t\u0017\u0001D1og&,e.\u00192mK\u0012\u0004\u0013A\u0002\u001fj]&$h\bF\u0003o_B\f(\u000f\u0005\u0002:\u0001!)a*\u0003a\u0001q!)\u0011+\u0003a\u0001'\"9q+\u0003I\u0001\u0002\u0004I\u0006b\u00024\n!\u0003\u0005\r\u0001[\u0001\fe\u0016\u0004H.Y2f[\u0016tG\u000fF\u0002okZDQAT\u0006A\u0002aBQ!U\u0006A\u0002a\"\"A\u001c=\t\u000b9c\u0001\u0019\u0001\u001d\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-F\u0001[\u000319\u0018\u000e\u001e5US6,'l\u001c8f)\t\u0011U\u0010C\u0003X\u001d\u0001\u0007!,\u0001\u000bo_\u0012,\u0007+\u0019;uKJt7/\u00138uKJt\u0017\r\u001c\u000b\u0003\u0003\u0003\u0001b!a\u0001\u0002\u000e\u0005Ma\u0002BA\u0003\u0003\u0013q1!XA\u0004\u0013\u0005A\u0015bAA\u0006\u000f\u00069\u0001/Y2lC\u001e,\u0017\u0002BA\b\u0003#\u00111aU3r\u0015\r\tYa\u0012\t\u0005\u0003+\t9D\u0004\u0003\u0002\u0018\u0005Eb\u0002BA\r\u0003[qA!a\u0007\u0002,9!\u0011QDA\u0015\u001d\u0011\ty\"a\n\u000f\t\u0005\u0005\u0012Q\u0005\b\u0004;\u0006\r\u0012\"A\u001b\n\u0005M\"\u0014BA\u00193\u0013\ty\u0003'\u0003\u0002.]%\u0019\u0011q\u0006\u0017\u0002\u000bQ\u0014X-Z:\n\t\u0005M\u0012QG\u0001\f)J,W\rU1ui\u0016\u0014hNC\u0002\u000201JA!!\u000f\u0002<\tYAK]3f!\u0006$H/\u001a:o\u0015\u0011\t\u0019$!\u000e\u0002\u0011\rD\u0017\u000e\u001c3sK:,\"!!\u0011\u0011\u000b\u0005\r\u0011Q\u0002\u001d\u0002\u0015%t\u0007/\u001e;UsB,7/\u0006\u0002\u0002HA1\u00111AA\u0007\u0003\u0013\u0002B!a\u0013\u0002R5\u0011\u0011Q\n\u0006\u0004\u0003\u001fr\u0013!\u0002;za\u0016\u001c\u0018\u0002BA*\u0003\u001b\u0012\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002/]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3sK:Le\u000e^3s]\u0006dGc\u0001\u001d\u0002Z!9\u00111\f\nA\u0002\u0005u\u0013a\u00038fo\u000eC\u0017\u000e\u001c3sK:\u0004R!a\u0001\u0002`aJA!!\u0019\u0002\u0012\tQ\u0011J\u001c3fq\u0016$7+Z9\u0002\t\r|\u0007/\u001f\u000b\n]\u0006\u001d\u0014\u0011NA6\u0003[BqAT\n\u0011\u0002\u0003\u0007\u0001\bC\u0004R'A\u0005\t\u0019A*\t\u000f]\u001b\u0002\u0013!a\u00013\"9am\u0005I\u0001\u0002\u0004A\u0017AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003gR3\u0001OA;W\t\t9\b\u0005\u0003\u0002z\u0005\rUBAA>\u0015\u0011\ti(a \u0002\u0013Ut7\r[3dW\u0016$'bAAA\u000f\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u0015\u00151\u0010\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003\u0017S3aUA;\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"!!%+\u0007e\u000b)(\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u0005]%f\u00015\u0002v\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!!(\u0011\t\u0005}\u0015\u0011V\u0007\u0003\u0003CSA!a)\u0002&\u0006!A.\u00198h\u0015\t\t9+\u0001\u0003kCZ\f\u0017bA2\u0002\"\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011q\u0016\t\u0004\r\u0006E\u0016bAAZ\u000f\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011\u0011XA`!\r1\u00151X\u0005\u0004\u0003{;%aA!os\"I\u0011\u0011\u0019\u000e\u0002\u0002\u0003\u0007\u0011qV\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005\u001d\u0007CBAe\u0003\u001f\fI,\u0004\u0002\u0002L*\u0019\u0011QZ$\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002R\u0006-'\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$2\u0001[Al\u0011%\t\t\rHA\u0001\u0002\u0004\tI,\u0001\u0004fcV\fGn\u001d\u000b\u0004Q\u0006u\u0007\"CAa;\u0005\u0005\t\u0019AA]Q]\u0001\u0011\u0011]At\u0003S\fi/a<\u0002t\u0006U\u0018\u0011`A~\u0003\u007f\u0014\t\u0001E\u0002:\u0003GL1!!:+\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!a;\u0002\u0003sS\u0001\u0005\t\u0011!?\u001a+fjQ0)I\u0006$XmX:uenc\u0003EZ7u;&\u0002S\u0006\t)beN,7\u000f\t;iK\u0002\u0002G-\u0019;f?N$(\u000f\u0019\u0011fqB\u0014Xm]:j_:\u0004s/\u001b;iAQDW\r\t1g[R\u0004\u0007%\u001a=qe\u0016\u001c8/[8oAQ|'\u0002\t\u0011!A\u0001\u0002\u0013\r\t3bi\u0016t\u0003EU3ukJt7\u000f\t8vY2\u0004s/\u001b;iA%tg/\u00197jI\u0002Jg\u000e];u]\u0001\u0012\u0015\u0010\t3fM\u0006,H\u000e\u001e\u0017!SR\u0004cm\u001c7m_^\u001c\beY1ti&tw\r\t:vY\u0016\u001c\b\u0005^8!C\u0002\"\u0017\r^3!S\u001aT\u0001\u0005\t\u0011!A\u0001\"\b.\u001a\u0011aM6$\b\rI5tA=l\u0017\u000e\u001e;fI:R\u0001\u0005I\u0001\nCJ<W/\\3oiN\f#!!=\u0002\u0005?Q\u0001\u0005\t\u0011!\u0003J<W/\\3oiNT$\u0002\t\u0011!A\u0001\u0002#\u0006\t3bi\u0016|6\u000f\u001e:![\u0001\n\u0005e\u001d;sS:<\u0007\u0005^8!E\u0016\u0004\u0003/\u0019:tK\u0012\u0004Co\u001c\u0011eCR,gF\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011g[R\u0004S\u0006\t#bi\u0016\u0004cm\u001c:nCR\u0004\u0003/\u0019;uKJt\u0007\u0005^8!M>dGn\\</AM+W\r\t\u001fbA!\u0014XMZ\u001f#QR$\bo\u001d\u001e0_M\u0004\u0018M]6/CB\f7\r[3/_J<w\u0006Z8dg>b\u0017\r^3ti>\u001a\u0018\u000f\\\u0017sK\u001alC-\u0019;fi&lW-\f9biR,'O\u001c\u0018ii6d'E\u0010#bi\u0016$\u0018.\\3!!\u0006$H/\u001a:ogrz\u0013M\u0010\u0011g_J\u0004c/\u00197jI*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\"\u0017\r^3!C:$\u0007\u0005^5nK\u00022wN]7bi\u0002\u0002\u0018\r\u001e;fe:\u001chF\u0003\u0011!\u0003!)\u00070Y7qY\u0016\u001c\u0018EAA|\u0003\u00055\"\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u00143aAJT\u0006M\u001c.gA\u0002\u0003\u0007\u000e\u001e2oi*$gJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AI\u0002\u0004'O\u00171o5\u001a\u0004G\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(eA\nd'L\u00193[M\nt\u0005\f\u0011(sfL\u00180L'N[\u0011$w%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!eA\nd'L\u00193[M\n$\u0002\t\u0011\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005u\u0018A\u00043bi\u0016$\u0018.\\3`MVt7m]\u0001\u0006g&t7-Z\u0011\u0003\u0005\u0007\tQ!\r\u00186]A\n1\u0002U1sg\u0016$v\u000eR1uKB\u0011\u0011hH\n\u0005?\t-1\nE\u0005\u0003\u000e\tM\u0001hU-i]6\u0011!q\u0002\u0006\u0004\u0005#9\u0015a\u0002:v]RLW.Z\u0005\u0005\u0005+\u0011yAA\tBEN$(/Y2u\rVt7\r^5p]R\"\"Aa\u0002\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!(\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u00139\u0014\tCa\t\u0003&\t\u001d\u0002\"\u0002(#\u0001\u0004A\u0004\"B)#\u0001\u0004\u0019\u0006bB,#!\u0003\u0005\r!\u0017\u0005\bM\n\u0002\n\u00111\u0001i\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u001a\u0014aD1qa2LH\u0005Z3gCVdG\u000f\n\u001b\u0002\u000fUt\u0017\r\u001d9msR!!\u0011\u0007B\u001d!\u00111EKa\r\u0011\u000f\u0019\u0013)\u0004O*ZQ&\u0019!qG$\u0003\rQ+\b\u000f\\35\u0011!\u0011Y$JA\u0001\u0002\u0004q\u0017a\u0001=%a\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"A!\u0012\u0011\t\u0005}%qI\u0005\u0005\u0005\u0013\n\tK\u0001\u0004PE*,7\r\u001e")
public class ParseToDate
extends Expression
implements RuntimeReplaceable,
ImplicitCastInputTypes,
TimeZoneAwareExpression,
scala.Serializable {
    private Expression replacement;
    private final Expression left;
    private final Option<Expression> format;
    private final Option<String> timeZoneId;
    private final boolean ansiEnabled;
    private boolean resolved;
    private final Seq<Enumeration.Value> nodePatterns;
    private transient ZoneId zoneId;
    private Expression canonicalized;
    private volatile byte bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static boolean $lessinit$greater$default$4() {
        return ParseToDate$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<String> $lessinit$greater$default$3() {
        return ParseToDate$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple4<Expression, Option<Expression>, Option<String>, Object>> unapply(ParseToDate parseToDate) {
        return ParseToDate$.MODULE$.unapply(parseToDate);
    }

    public static boolean apply$default$4() {
        return ParseToDate$.MODULE$.apply$default$4();
    }

    public static Option<String> apply$default$3() {
        return ParseToDate$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple4<Expression, Option<Expression>, Option<String>, Object>, ParseToDate> tupled() {
        return ParseToDate$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Option<Expression>, Function1<Option<String>, Function1<Object, ParseToDate>>>> curried() {
        return ParseToDate$.MODULE$.curried();
    }

    @Override
    public ZoneId zoneIdForType(DataType dataType) {
        return TimeZoneAwareExpression.zoneIdForType$(this, dataType);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public DataType dataType() {
        return RuntimeReplaceable.dataType$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return RuntimeReplaceable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return RuntimeReplaceable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return RuntimeReplaceable.doGenCode$(this, ctx, ev);
    }

    private boolean resolved$lzycompute() {
        ParseToDate parseToDate = this;
        synchronized (parseToDate) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.resolved$lzycompute();
        }
        return this.resolved;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private ZoneId zoneId$lzycompute() {
        ParseToDate parseToDate = this;
        synchronized (parseToDate) {
            if (!this.bitmap$trans$0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        if (!this.bitmap$trans$0) {
            return this.zoneId$lzycompute();
        }
        return this.zoneId;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$TimeZoneAwareExpression$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    private Expression canonicalized$lzycompute() {
        ParseToDate parseToDate = this;
        synchronized (parseToDate) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.canonicalized$lzycompute();
        }
        return this.canonicalized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
    }

    public Expression left() {
        return this.left;
    }

    public Option<Expression> format() {
        return this.format;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    public boolean ansiEnabled() {
        return this.ansiEnabled;
    }

    private Expression replacement$lzycompute() {
        ParseToDate parseToDate = this;
        synchronized (parseToDate) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.replacement = (Expression)this.format().map((Function1 & Serializable & scala.Serializable)f -> new Cast(new GetTimestamp(this.left(), (Expression)f, (DataType)TimestampType$.MODULE$, this.timeZoneId(), this.ansiEnabled()), (DataType)DateType$.MODULE$, this.timeZoneId(), EvalMode$.MODULE$.fromBoolean(this.ansiEnabled()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> new Cast(this.left(), (DataType)DateType$.MODULE$, this.timeZoneId(), EvalMode$.MODULE$.fromBoolean(this.ansiEnabled())));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.replacement;
    }

    @Override
    public Expression replacement() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.replacement$lzycompute();
        }
        return this.replacement;
    }

    @Override
    public String prettyName() {
        return "to_date";
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Some x$1 = new Some((Object)timeZoneId);
        Expression x$2 = this.copy$default$1();
        Option<Expression> x$3 = this.copy$default$2();
        boolean x$4 = this.copy$default$4();
        return this.copy(x$2, x$3, (Option<String>)x$1, x$4);
    }

    @Override
    public Seq<Enumeration.Value> nodePatternsInternal() {
        return (Seq)new .colon.colon((Object)TreePattern$.MODULE$.RUNTIME_REPLACEABLE(), (List)Nil$.MODULE$);
    }

    @Override
    public Seq<Expression> children() {
        Expression expression = this.left();
        return (Seq)Option$.MODULE$.option2Iterable(this.format()).toSeq().$plus$colon((Object)expression, Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        TypeCollection typeCollection = TypeCollection$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{StringType$.MODULE$, DateType$.MODULE$, TimestampType$.MODULE$, TimestampNTZType$.MODULE$}));
        return (Seq)Option$.MODULE$.option2Iterable(this.format().map((Function1 & Serializable & scala.Serializable)x$7 -> StringType$.MODULE$)).toSeq().$plus$colon((Object)typeCollection, Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public Expression withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        if (this.format().isDefined()) {
            return this.copy((Expression)newChildren.head(), (Option<Expression>)new Some(newChildren.last()), this.copy$default$3(), this.copy$default$4());
        }
        return this.copy((Expression)newChildren.head(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4());
    }

    public ParseToDate copy(Expression left, Option<Expression> format, Option<String> timeZoneId, boolean ansiEnabled) {
        return new ParseToDate(left, format, timeZoneId, ansiEnabled);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Option<Expression> copy$default$2() {
        return this.format();
    }

    public Option<String> copy$default$3() {
        return this.timeZoneId();
    }

    public boolean copy$default$4() {
        return this.ansiEnabled();
    }

    @Override
    public String productPrefix() {
        return "ParseToDate";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.format();
            }
            case 2: {
                return this.timeZoneId();
            }
            case 3: {
                return BoxesRunTime.boxToBoolean((boolean)this.ansiEnabled());
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ParseToDate;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ParseToDate)) return false;
        boolean bl = true;
        if (!bl) return false;
        ParseToDate parseToDate = (ParseToDate)x$1;
        Expression expression = this.left();
        Expression expression2 = parseToDate.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Expression> option = this.format();
        Option<Expression> option2 = parseToDate.format();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<String> option3 = this.timeZoneId();
        Option<String> option4 = parseToDate.timeZoneId();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        if (this.ansiEnabled() != parseToDate.ansiEnabled()) return false;
        if (!parseToDate.canEqual(this)) return false;
        return true;
    }

    public ParseToDate(Expression left, Option<Expression> format, Option<String> timeZoneId, boolean ansiEnabled) {
        this.left = left;
        this.format = format;
        this.timeZoneId = timeZoneId;
        this.ansiEnabled = ansiEnabled;
        RuntimeReplaceable.$init$(this);
        ExpectsInputTypes.$init$(this);
        TimeZoneAwareExpression.$init$(this);
    }

    public ParseToDate(Expression left, Expression format) {
        this(left, (Option<Expression>)Option$.MODULE$.apply((Object)format), ParseToDate$.MODULE$.$lessinit$greater$default$3(), ParseToDate$.MODULE$.$lessinit$greater$default$4());
    }

    public ParseToDate(Expression left) {
        this(left, (Option<Expression>)None$.MODULE$, ParseToDate$.MODULE$.$lessinit$greater$default$3(), ParseToDate$.MODULE$.$lessinit$greater$default$4());
    }
}

