/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.LeafExpression;
import org.apache.spark.sql.catalyst.expressions.MonotonicallyIncreasingID$;
import org.apache.spark.sql.catalyst.expressions.Nondeterministic;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_() - Returns monotonically increasing 64-bit integers. The generated ID is guaranteed\n      to be monotonically increasing and unique, but not consecutive. The current implementation\n      puts the partition ID in the upper 31 bits, and the lower 33 bits represent the record number\n      within each partition. The assumption is that the data frame has less than 1 billion\n      partitions, and each partition has less than 8 billion records.\n      The function is non-deterministic because its result depends on partition IDs.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_();\n       0\n  ", since="1.4.0", group="misc_funcs")
@ScalaSignature(bytes="\u0006\u0001\u0005Uf\u0001B\u000e\u001d\u0001&BQA\u000f\u0001\u0005\u0002mB\u0011\"\u0010\u0001A\u0002\u0003\u0005\u000b\u0015\u0002 \t\u0013\u0015\u0003\u0001\u0019!A!B\u0013q\u0004\"B$\u0001\t\u0003B\u0005\"\u0002'\u0001\t#j\u0005\"\u0002,\u0001\t\u0003:\u0006\"B5\u0001\t\u0003B\u0005\"\u00026\u0001\t\u0003Z\u0007\"\u0002:\u0001\t#\u001a\b\"\u0002>\u0001\t\u0003Z\bbBA\n\u0001\u0011\u0005\u0013Q\u0003\u0005\u0007C\u0001!\t%!\u0006\t\u0011\u0005\u001d\u0002!!A\u0005\u0002mB\u0011\"!\u000b\u0001\u0003\u0003%\t%a\u000b\t\u0013\u0005m\u0002!!A\u0005\u0002\u0005u\u0002\"CA \u0001\u0005\u0005I\u0011AA!\u0011%\ti\u0005AA\u0001\n\u0003\ny\u0005C\u0005\u0002^\u0001\t\t\u0011\"\u0001\u0002`!I\u00111\r\u0001\u0002\u0002\u0013\u0005\u0013QM\u0004\n\u0003\u0013c\u0012\u0011!E\u0001\u0003\u00173\u0001b\u0007\u000f\u0002\u0002#\u0005\u0011Q\u0012\u0005\u0007uU!\t!a'\t\u0013\u0005uU#!A\u0005F\u0005}\u0005\u0002CAQ+\u0005\u0005I\u0011Q\u001e\t\u0013\u0005\rV#!A\u0005\u0002\u0006\u0015\u0006\"CAV+\u0005\u0005I\u0011BAW\u0005eiuN\\8u_:L7-\u00197ms&s7M]3bg&tw-\u0013#\u000b\u0005uq\u0012aC3yaJ,7o]5p]NT!a\b\u0011\u0002\u0011\r\fG/\u00197zgRT!!\t\u0012\u0002\u0007M\fHN\u0003\u0002$I\u0005)1\u000f]1sW*\u0011QEJ\u0001\u0007CB\f7\r[3\u000b\u0003\u001d\n1a\u001c:h\u0007\u0001\u0019R\u0001\u0001\u0016/c]\u0002\"a\u000b\u0017\u000e\u0003qI!!\f\u000f\u0003\u001d1+\u0017MZ#yaJ,7o]5p]B\u00111fL\u0005\u0003aq\u0011\u0001CT8oI\u0016$XM]7j]&\u001cH/[2\u0011\u0005I*T\"A\u001a\u000b\u0003Q\nQa]2bY\u0006L!AN\u001a\u0003\u000fA\u0013x\u000eZ;diB\u0011!\u0007O\u0005\u0003sM\u0012AbU3sS\u0006d\u0017N_1cY\u0016\fa\u0001P5oSRtD#\u0001\u001f\u0011\u0005-\u0002\u0011!B2pk:$\bC\u0001\u001a@\u0013\t\u00015G\u0001\u0003M_:<\u0007F\u0001\u0002C!\t\u00114)\u0003\u0002Eg\tIAO]1og&,g\u000e^\u0001\u000ea\u0006\u0014H/\u001b;j_:l\u0015m]6)\u0005\r\u0011\u0015\u0001C:uCR,g-\u001e7\u0016\u0003%\u0003\"A\r&\n\u0005-\u001b$a\u0002\"p_2,\u0017M\\\u0001\u0013S:LG/[1mSj,\u0017J\u001c;fe:\fG\u000e\u0006\u0002O#B\u0011!gT\u0005\u0003!N\u0012A!\u00168ji\")!+\u0002a\u0001'\u0006q\u0001/\u0019:uSRLwN\\%oI\u0016D\bC\u0001\u001aU\u0013\t)6GA\u0002J]R\fqc^5uQ:+wo\u00115jY\u0012\u0014XM\\%oi\u0016\u0014h.\u00197\u0015\u0005a[\u0006CA\u0016Z\u0013\tQFD\u0001\u0006FqB\u0014Xm]:j_:DQ\u0001\u0018\u0004A\u0002u\u000b1B\\3x\u0007\"LG\u000e\u001a:f]B\u0019aL\u001a-\u000f\u0005}#gB\u00011d\u001b\u0005\t'B\u00012)\u0003\u0019a$o\\8u}%\tA'\u0003\u0002fg\u00059\u0001/Y2lC\u001e,\u0017BA4i\u0005)Ie\u000eZ3yK\u0012\u001cV-\u001d\u0006\u0003KN\n\u0001B\\;mY\u0006\u0014G.Z\u0001\tI\u0006$\u0018\rV=qKV\tA\u000e\u0005\u0002na6\taN\u0003\u0002pA\u0005)A/\u001f9fg&\u0011\u0011O\u001c\u0002\t\t\u0006$\u0018\rV=qK\u0006aQM^1m\u0013:$XM\u001d8bYR\u0011a\b\u001e\u0005\u0006k&\u0001\rA^\u0001\u0006S:\u0004X\u000f\u001e\t\u0003obl\u0011AH\u0005\u0003sz\u00111\"\u00138uKJt\u0017\r\u001c*po\u0006IAm\\$f]\u000e{G-\u001a\u000b\u0006y\u0006\u0015\u0011q\u0002\t\u0004{\u0006\u0005Q\"\u0001@\u000b\u0005}d\u0012aB2pI\u0016<WM\\\u0005\u0004\u0003\u0007q(\u0001C#yaJ\u001cu\u000eZ3\t\u000f\u0005\u001d!\u00021\u0001\u0002\n\u0005\u00191\r\u001e=\u0011\u0007u\fY!C\u0002\u0002\u000ey\u0014abQ8eK\u001e,gnQ8oi\u0016DH\u000f\u0003\u0004\u0002\u0012)\u0001\r\u0001`\u0001\u0003KZ\f\u0001B\\8eK:\u000bW.Z\u000b\u0003\u0003/\u0001B!!\u0007\u0002\"9!\u00111DA\u000f!\t\u00017'C\u0002\u0002 M\na\u0001\u0015:fI\u00164\u0017\u0002BA\u0012\u0003K\u0011aa\u0015;sS:<'bAA\u0010g\u0005!1m\u001c9z\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011Q\u0006\t\u0005\u0003_\tI$\u0004\u0002\u00022)!\u00111GA\u001b\u0003\u0011a\u0017M\\4\u000b\u0005\u0005]\u0012\u0001\u00026bm\u0006LA!a\t\u00022\u0005a\u0001O]8ek\u000e$\u0018I]5usV\t1+\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005\r\u0013\u0011\n\t\u0004e\u0005\u0015\u0013bAA$g\t\u0019\u0011I\\=\t\u0011\u0005-\u0003#!AA\u0002M\u000b1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA)!\u0019\t\u0019&!\u0017\u0002D5\u0011\u0011Q\u000b\u0006\u0004\u0003/\u001a\u0014AC2pY2,7\r^5p]&!\u00111LA+\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007%\u000b\t\u0007C\u0005\u0002LI\t\t\u00111\u0001\u0002D\u00051Q-];bYN$2!SA4\u0011%\tYeEA\u0001\u0002\u0004\t\u0019\u0005K\n\u0001\u0003W\n\t(a\u001d\u0002x\u0005e\u0014QPA@\u0003\u0007\u000b)\tE\u0002,\u0003[J1!a\u001c\u001d\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!!\u001e\u0002\t{Q\u0001\u0005\t\u0011!?\u001a+fjQ0)S\u0001j\u0003EU3ukJt7\u000fI7p]>$xN\\5dC2d\u0017\u0010I5oGJ,\u0017m]5oO\u00022D'\f2ji\u0002Jg\u000e^3hKJ\u001ch\u0006\t+iK\u0002:WM\\3sCR,G\rI%EA%\u001c\beZ;be\u0006tG/Z3e\u0015\u0001\u0002\u0003\u0005\t\u0011!i>\u0004#-\u001a\u0011n_:|Go\u001c8jG\u0006dG.\u001f\u0011j]\u000e\u0014X-Y:j]\u001e\u0004\u0013M\u001c3!k:L\u0017/^3-A\t,H\u000f\t8pi\u0002\u001awN\\:fGV$\u0018N^3/AQCW\rI2veJ,g\u000e\u001e\u0011j[BdW-\\3oi\u0006$\u0018n\u001c8\u000bA\u0001\u0002\u0003\u0005\t\u0011qkR\u001c\b\u0005\u001e5fAA\f'\u000f^5uS>t\u0007%\u0013#!S:\u0004C\u000f[3!kB\u0004XM\u001d\u00114c\u0001\u0012\u0017\u000e^:-A\u0005tG\r\t;iK\u0002bwn^3sAM\u001a\u0004EY5ug\u0002\u0012X\r\u001d:fg\u0016tG\u000f\t;iK\u0002\u0012XmY8sI\u0002rW/\u001c2fe*\u0001\u0003\u0005\t\u0011!A]LG\u000f[5oA\u0015\f7\r\u001b\u0011qCJ$\u0018\u000e^5p]:\u0002C\u000b[3!CN\u001cX/\u001c9uS>t\u0007%[:!i\"\fG\u000f\t;iK\u0002\"\u0017\r^1!MJ\fW.\u001a\u0011iCN\u0004C.Z:tAQD\u0017M\u001c\u00112A\tLG\u000e\\5p]*\u0001\u0003\u0005\t\u0011!AA\f'\u000f^5uS>t7\u000f\f\u0011b]\u0012\u0004S-Y2iAA\f'\u000f^5uS>t\u0007\u0005[1tA1,7o\u001d\u0011uQ\u0006t\u0007\u0005\u000f\u0011cS2d\u0017n\u001c8!e\u0016\u001cwN\u001d3t])\u0001\u0003\u0005\t\u0011!AQCW\r\t4v]\u000e$\u0018n\u001c8!SN\u0004cn\u001c8.I\u0016$XM]7j]&\u001cH/[2!E\u0016\u001c\u0017-^:fA%$8\u000f\t:fgVdG\u000f\t3fa\u0016tGm\u001d\u0011p]\u0002\u0002\u0018M\u001d;ji&|g\u000eI%Eg:R\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u00111P\u00014\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"J3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0019\u000bA\u0001\nQa]5oG\u0016\f#!!!\u0002\u000bErCG\f\u0019\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005\u001d\u0015AC7jg\u000e|f-\u001e8dg\u0006IRj\u001c8pi>t\u0017nY1mYfLen\u0019:fCNLgnZ%E!\tYSc\u0005\u0003\u0016\u0003\u001f;\u0004#BAI\u0003/cTBAAJ\u0015\r\t)jM\u0001\beVtG/[7f\u0013\u0011\tI*a%\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t\u0007\u0007\u0006\u0002\u0002\f\u0006AAo\\*ue&tw\r\u0006\u0002\u0002.\u0005)\u0011\r\u001d9ms\u00069QO\\1qa2LHcA%\u0002(\"A\u0011\u0011V\r\u0002\u0002\u0003\u0007A(A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011\u0011q\u0016\t\u0005\u0003_\t\t,\u0003\u0003\u00024\u0006E\"AB(cU\u0016\u001cG\u000f")
public class MonotonicallyIncreasingID
extends LeafExpression
implements Nondeterministic,
Serializable {
    private transient long count;
    private transient long partitionMask;
    private boolean deterministic;
    private transient boolean org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized;
    private volatile boolean bitmap$0;

    public static boolean unapply(MonotonicallyIncreasingID monotonicallyIncreasingID) {
        return MonotonicallyIncreasingID$.MODULE$.unapply(monotonicallyIncreasingID);
    }

    @Override
    public final boolean foldable() {
        return Nondeterministic.foldable$(this);
    }

    @Override
    public final void initialize(int partitionIndex) {
        Nondeterministic.initialize$(this, partitionIndex);
    }

    @Override
    public final Object eval(InternalRow input) {
        return Nondeterministic.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return Nondeterministic.eval$default$1$(this);
    }

    private boolean deterministic$lzycompute() {
        MonotonicallyIncreasingID monotonicallyIncreasingID = this;
        synchronized (monotonicallyIncreasingID) {
            if (!this.bitmap$0) {
                this.deterministic = Nondeterministic.deterministic$(this);
                this.bitmap$0 = true;
            }
        }
        return this.deterministic;
    }

    @Override
    public final boolean deterministic() {
        if (!this.bitmap$0) {
            return this.deterministic$lzycompute();
        }
        return this.deterministic;
    }

    @Override
    public boolean org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized() {
        return this.org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized_$eq(boolean x$1) {
        this.org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized = x$1;
    }

    @Override
    public boolean stateful() {
        return true;
    }

    @Override
    public void initializeInternal(int partitionIndex) {
        this.count = 0L;
        this.partitionMask = (long)partitionIndex << 33;
    }

    @Override
    public Expression withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return new MonotonicallyIncreasingID();
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public DataType dataType() {
        return LongType$.MODULE$;
    }

    public long evalInternal(InternalRow input) {
        long currentCount = this.count++;
        return this.partitionMask + currentCount;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String countTerm = ctx.addMutableState("long", "count", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String partitionMaskTerm = "partitionMask";
        ctx.addImmutableStateIfNotExists("long", partitionMaskTerm, ctx.addImmutableStateIfNotExists$default$3());
        ctx.addPartitionInitializationStatement(new StringBuilder(6).append(countTerm).append(" = 0L;").toString());
        ctx.addPartitionInitializationStatement(new StringBuilder(33).append(partitionMaskTerm).append(" = ((long) partitionIndex) << 33;").toString());
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n      final ", " ", " = ", " + ", ";\n      ", "++;"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), partitionMaskTerm, countTerm, countTerm})), FalseLiteral$.MODULE$, ev.copy$default$3());
    }

    @Override
    public String nodeName() {
        return "monotonically_increasing_id";
    }

    @Override
    public String sql() {
        return new StringBuilder(2).append(this.prettyName()).append("()").toString();
    }

    public MonotonicallyIncreasingID copy() {
        return new MonotonicallyIncreasingID();
    }

    @Override
    public String productPrefix() {
        return "MonotonicallyIncreasingID";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MonotonicallyIncreasingID;
    }

    public boolean equals(Object x$1) {
        Object object = x$1;
        return object instanceof MonotonicallyIncreasingID && ((MonotonicallyIncreasingID)x$1).canEqual(this);
    }

    public MonotonicallyIncreasingID() {
        Nondeterministic.$init$(this);
    }
}

