/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.ql.io.RCFile;
import org.apache.hadoop.hive.serde2.columnar.BytesRefArrayWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.ReflectionUtils;

public class RCFileOutputFormat
extends FileOutputFormat<WritableComparable, BytesRefArrayWritable>
implements HiveOutputFormat<WritableComparable, BytesRefArrayWritable> {
    public static void setColumnNumber(Configuration conf, int columnNum) {
        assert (columnNum > 0);
        conf.setInt(HiveConf.ConfVars.HIVE_RCFILE_COLUMN_NUMBER_CONF.varname, columnNum);
    }

    public static int getColumnNumber(Configuration conf) {
        return HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_RCFILE_COLUMN_NUMBER_CONF);
    }

    public RecordWriter<WritableComparable, BytesRefArrayWritable> getRecordWriter(FileSystem ignored, JobConf job, String name, Progressable progress) throws IOException {
        Path outputPath = RCFileOutputFormat.getWorkOutputPath((JobConf)job);
        FileSystem fs = outputPath.getFileSystem((Configuration)job);
        Path file = new Path(outputPath, name);
        CompressionCodec codec = null;
        if (RCFileOutputFormat.getCompressOutput((JobConf)job)) {
            Class codecClass = RCFileOutputFormat.getOutputCompressorClass((JobConf)job, DefaultCodec.class);
            codec = (CompressionCodec)ReflectionUtils.newInstance((Class)codecClass, (Configuration)job);
        }
        final RCFile.Writer out = new RCFile.Writer(fs, (Configuration)job, file, progress, codec);
        return new RecordWriter<WritableComparable, BytesRefArrayWritable>(){

            public void close(Reporter reporter) throws IOException {
                out.close();
            }

            public void write(WritableComparable key, BytesRefArrayWritable value) throws IOException {
                out.append((Writable)value);
            }
        };
    }

    @Override
    public FileSinkOperator.RecordWriter getHiveRecordWriter(JobConf jc, Path finalOutPath, Class<? extends Writable> valueClass, boolean isCompressed, Properties tableProperties, Progressable progress) throws IOException {
        String[] cols = null;
        String columns = tableProperties.getProperty("columns");
        cols = columns == null || columns.trim().equals("") ? new String[]{} : StringUtils.split((String)columns, (String)",");
        RCFileOutputFormat.setColumnNumber((Configuration)jc, cols.length);
        final RCFile.Writer outWriter = Utilities.createRCFileWriter(jc, finalOutPath.getFileSystem((Configuration)jc), finalOutPath, isCompressed, progress);
        return new FileSinkOperator.RecordWriter(){

            @Override
            public void write(Writable r) throws IOException {
                outWriter.append(r);
            }

            @Override
            public void close(boolean abort) throws IOException {
                outWriter.close();
            }
        };
    }
}

