/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.NonSQLExpression;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.Unevaluable;
import org.apache.spark.sql.catalyst.expressions.WindowTime$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(window_column) - Extract the time value from time/session window column which can be used for event time value of window.\n      The extracted time is (window.end - 1) which reflects the fact that the the aggregating\n      windows have exclusive upper bound - [start, end)\n      See <a href=\"https://spark.apache.org/docs/latest/structured-streaming-programming-guide.html#window-operations-on-event-time\">'Window Operations on Event Time'</a> in Structured Streaming guide doc for detailed explanation and examples.\n  ", arguments="\n    Arguments:\n      * window_column - The column representing time/session window.\n  ", examples="\n    Examples:\n      > SELECT a, window.start as start, window.end as end, _FUNC_(window), cnt FROM (SELECT a, window, count(*) as cnt FROM VALUES ('A1', '2021-01-01 00:00:00'), ('A1', '2021-01-01 00:04:30'), ('A1', '2021-01-01 00:06:00'), ('A2', '2021-01-01 00:01:00') AS tab(a, b) GROUP by a, window(b, '5 minutes') ORDER BY a, window.start);\n        A1\t2021-01-01 00:00:00\t2021-01-01 00:05:00\t2021-01-01 00:04:59.999999\t2\n        A1\t2021-01-01 00:05:00\t2021-01-01 00:10:00\t2021-01-01 00:09:59.999999\t1\n        A2\t2021-01-01 00:00:00\t2021-01-01 00:05:00\t2021-01-01 00:04:59.999999\t1\n  ", group="datetime_funcs", since="3.4.0")
@ScalaSignature(bytes="\u0006\u0005\u0005Mh\u0001\u0002\u000f\u001e\u0001*B\u0001B\u0013\u0001\u0003\u0016\u0004%\ta\u0013\u0005\t\u001f\u0002\u0011\t\u0012)A\u0005\u0019\")\u0001\u000b\u0001C\u0001#\")A\u000b\u0001C!\u0017\")Q\u000b\u0001C!-\")\u0001\r\u0001C!C\"9Q\r\u0001b\u0001\n\u000b2\u0007BB?\u0001A\u00035q\rC\u0003\u007f\u0001\u0011\u0005s\u0010\u0003\u0006\u0002\u0012\u0001A)\u0019!C!\u0003'Aq!a\u0007\u0001\t#\ni\u0002C\u0005\u0002$\u0001\t\t\u0011\"\u0001\u0002&!I\u0011\u0011\u0006\u0001\u0012\u0002\u0013\u0005\u00111\u0006\u0005\n\u0003\u0003\u0002\u0011\u0011!C!\u0003\u0007B\u0011\"a\u0015\u0001\u0003\u0003%\t!!\u0016\t\u0013\u0005u\u0003!!A\u0005\u0002\u0005}\u0003\"CA6\u0001\u0005\u0005I\u0011IA7\u0011%\tY\bAA\u0001\n\u0003\ti\bC\u0005\u0002\u0002\u0002\t\t\u0011\"\u0011\u0002\u0004\"I\u0011q\u0011\u0001\u0002\u0002\u0013\u0005\u0013\u0011R\u0004\n\u0003gk\u0012\u0011!E\u0001\u0003k3\u0001\u0002H\u000f\u0002\u0002#\u0005\u0011q\u0017\u0005\u0007!Z!\t!a4\t\u0013\u0005Eg#!A\u0005F\u0005M\u0007\"CAk-\u0005\u0005I\u0011QAl\u0011%\tYNFA\u0001\n\u0003\u000bi\u000eC\u0005\u0002jZ\t\t\u0011\"\u0003\u0002l\nQq+\u001b8e_^$\u0016.\\3\u000b\u0005yy\u0012aC3yaJ,7o]5p]NT!\u0001I\u0011\u0002\u0011\r\fG/\u00197zgRT!AI\u0012\u0002\u0007M\fHN\u0003\u0002%K\u0005)1\u000f]1sW*\u0011aeJ\u0001\u0007CB\f7\r[3\u000b\u0003!\n1a\u001c:h\u0007\u0001\u0019r\u0001A\u00160eUBd\b\u0005\u0002-[5\tQ$\u0003\u0002/;\tyQK\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u0002-a%\u0011\u0011'\b\u0002\u0017\u00136\u0004H.[2ji\u000e\u000b7\u000f^%oaV$H+\u001f9fgB\u0011AfM\u0005\u0003iu\u00111\"\u00168fm\u0006dW/\u00192mKB\u0011AFN\u0005\u0003ou\u0011\u0001CT8o'FcU\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005ebT\"\u0001\u001e\u000b\u0003m\nQa]2bY\u0006L!!\u0010\u001e\u0003\u000fA\u0013x\u000eZ;diB\u0011qh\u0012\b\u0003\u0001\u0016s!!\u0011#\u000e\u0003\tS!aQ\u0015\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0014B\u0001$;\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001S%\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005\u0019S\u0014\u0001D<j]\u0012|woQ8mk6tW#\u0001'\u0011\u00051j\u0015B\u0001(\u001e\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u000eo&tGm\\<D_2,XN\u001c\u0011\u0002\rqJg.\u001b;?)\t\u00116\u000b\u0005\u0002-\u0001!)!j\u0001a\u0001\u0019\u0006)1\r[5mI\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0003]\u00032a\u0010-[\u0013\tI\u0016JA\u0002TKF\u0004\"a\u00170\u000e\u0003qS!!X\u0011\u0002\u000bQL\b/Z:\n\u0005}c&\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0003!!\u0017\r^1UsB,W#\u00012\u0011\u0005m\u001b\u0017B\u00013]\u0005!!\u0015\r^1UsB,\u0017\u0001\u00048pI\u0016\u0004\u0016\r\u001e;fe:\u001cX#A4\u0011\u0007}B\u0006\u000e\u0005\u0002ju:\u0011!n\u001e\b\u0003WVt!\u0001\u001c;\u000f\u00055\u001chB\u00018s\u001d\ty\u0017O\u0004\u0002Ba&\t\u0001&\u0003\u0002'O%\u0011A%J\u0005\u0003E\rJ!\u0001I\u0011\n\u0005Y|\u0012!\u0002;sK\u0016\u001c\u0018B\u0001=z\u0003-!&/Z3QCR$XM\u001d8\u000b\u0005Y|\u0012BA>}\u0005-!&/Z3QCR$XM\u001d8\u000b\u0005aL\u0018!\u00048pI\u0016\u0004\u0016\r\u001e;fe:\u001c\b%\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\"!!\u0001\u0011\t\u0005\r\u00111\u0002\b\u0005\u0003\u000b\t9\u0001\u0005\u0002Bu%\u0019\u0011\u0011\u0002\u001e\u0002\rA\u0013X\rZ3g\u0013\u0011\ti!a\u0004\u0003\rM#(/\u001b8h\u0015\r\tIAO\u0001\te\u0016\u001cx\u000e\u001c<fIV\u0011\u0011Q\u0003\t\u0004s\u0005]\u0011bAA\ru\t9!i\\8mK\u0006t\u0017\u0001F<ji\"tUm^\"iS2$\u0017J\u001c;fe:\fG\u000eF\u0002S\u0003?Aa!!\t\f\u0001\u0004a\u0015\u0001\u00038fo\u000eC\u0017\u000e\u001c3\u0002\t\r|\u0007/\u001f\u000b\u0004%\u0006\u001d\u0002b\u0002&\r!\u0003\u0005\r\u0001T\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tiCK\u0002M\u0003_Y#!!\r\u0011\t\u0005M\u0012QH\u0007\u0003\u0003kQA!a\u000e\u0002:\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003wQ\u0014AC1o]>$\u0018\r^5p]&!\u0011qHA\u001b\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005\u0015\u0003\u0003BA$\u0003#j!!!\u0013\u000b\t\u0005-\u0013QJ\u0001\u0005Y\u0006twM\u0003\u0002\u0002P\u0005!!.\u0019<b\u0013\u0011\ti!!\u0013\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005]\u0003cA\u001d\u0002Z%\u0019\u00111\f\u001e\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005\u0005\u0014q\r\t\u0004s\u0005\r\u0014bAA3u\t\u0019\u0011I\\=\t\u0013\u0005%\u0004#!AA\u0002\u0005]\u0013a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002pA1\u0011\u0011OA<\u0003Cj!!a\u001d\u000b\u0007\u0005U$(\u0001\u0006d_2dWm\u0019;j_:LA!!\u001f\u0002t\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t)\"a \t\u0013\u0005%$#!AA\u0002\u0005\u0005\u0014A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!!\u0012\u0002\u0006\"I\u0011\u0011N\n\u0002\u0002\u0003\u0007\u0011qK\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005U\u00111\u0012\u0005\n\u0003S\"\u0012\u0011!a\u0001\u0003CBs\u0003AAH\u0003+\u000b9*a'\u0002\u001e\u0006\u0005\u00161UAT\u0003S\u000bi+a,\u0011\u00071\n\t*C\u0002\u0002\u0014v\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002\u001a\u0006!)C\u0003\u0011!A\u0001zf)\u0016(D?\":\u0018N\u001c3po~\u001bw\u000e\\;n]&\u0002S\u0006I#yiJ\f7\r\u001e\u0011uQ\u0016\u0004C/[7fAY\fG.^3!MJ|W\u000e\t;j[\u0016|3/Z:tS>t\u0007e^5oI><\beY8mk6t\u0007e\u001e5jG\"\u00043-\u00198!E\u0016\u0004So]3eA\u0019|'\u000fI3wK:$\b\u0005^5nK\u00022\u0018\r\\;fA=4\u0007e^5oI><hF\u0003\u0011!A\u0001\u0002\u0003\u0005\u00165fA\u0015DHO]1di\u0016$\u0007\u0005^5nK\u0002J7\u000f\t\u0015xS:$wn\u001e\u0018f]\u0012\u0004S\u0006I\u0019*A]D\u0017n\u00195!e\u00164G.Z2ug\u0002\"\b.\u001a\u0011gC\u000e$\b\u0005\u001e5bi\u0002\"\b.\u001a\u0011uQ\u0016\u0004\u0013mZ4sK\u001e\fG/\u001b8h\u0015\u0001\u0002\u0003\u0005\t\u0011!o&tGm\\<tA!\fg/\u001a\u0011fq\u000edWo]5wK\u0002*\b\u000f]3sA\t|WO\u001c3![\u0001Z6\u000f^1si2\u0002SM\u001c3*\u0015\u0001\u0002\u0003\u0005\t\u0011!'\u0016,\u0007\u0005P1!QJ,g-\u0010\u0012iiR\u00048OO\u00180gB\f'o\u001b\u0018ba\u0006\u001c\u0007.\u001a\u0018pe\u001e|Cm\\2t_1\fG/Z:u_M$(/^2ukJ,G-L:ue\u0016\fW.\u001b8h[A\u0014xn\u001a:b[6LgnZ\u0017hk&$WM\f5u[2\u001cs/\u001b8e_^ls\u000e]3sCRLwN\\:._:lSM^3oi6\"\u0018.\\3#}\u001d:\u0016N\u001c3po\u0002z\u0005/\u001a:bi&|gn\u001d\u0011p]\u0002*e/\u001a8uAQKW.Z\u0014=_\u0005t\u0004%\u001b8!'R\u0014Xo\u0019;ve\u0016$\u0007e\u0015;sK\u0006l\u0017N\\4!OVLG-\u001a\u0011e_\u000e\u0004cm\u001c:!I\u0016$\u0018-\u001b7fI\u0002*\u0007\u0010\u001d7b]\u0006$\u0018n\u001c8!C:$\u0007%\u001a=b[BdWm\u001d\u0018\u000bA\u0001\n\u0011\"\u0019:hk6,g\u000e^:\"\u0005\u0005}\u0015a\u0016\u0006!A\u0001\u0002\u0013I]4v[\u0016tGo\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011+A]Lg\u000eZ8x?\u000e|G.^7oA5\u0002C\u000b[3!G>dW/\u001c8!e\u0016\u0004(/Z:f]RLgn\u001a\u0011uS6,wf]3tg&|g\u000eI<j]\u0012|wO\f\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0002&\u0006!9J\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011bY\u0001:\u0018N\u001c3po:\u001aH/\u0019:uA\u0005\u001c\be\u001d;beRd\u0003e^5oI><h&\u001a8eA\u0005\u001c\b%\u001a8eY\u0001zf)\u0016(D?\":\u0018N\u001c3po&b\u0003e\u00198uA\u0019\u0013v*\u0014\u0011)'\u0016cUi\u0011+!C2\u0002s/\u001b8e_^d\u0003eY8v]RD#&\u000b\u0011bg\u0002\u001ag\u000e\u001e\u0011G%>k\u0005EV!M+\u0016\u001b\u0006\u0005K\u0014Bc\u001db\u0003e\n\u001a1eEj\u0003'M\u00171c\u0001\u0002\u0004G\u000f\u00191uA\u0002t%\u000b\u0017!Q\u001d\n\u0015g\n\u0017!OI\u0002$'M\u00171c5\u0002\u0014\u0007\t\u00191uA\"$h\r\u0019(S1\u0002\u0003fJ!2O1\u0002sE\r\u00193c5\u0002\u0014'\f\u00192AA\u0002$\b\r\u001c;aA:\u0013\u0006\f\u0011)O\u0005\u0013t\u0005\f\u0011(eA\u0012\u0014'\f\u00192[A\n\u0004\u0005\r\u0019;aER\u0004\u0007M\u0014*A\u0005\u001b\u0006\u0005^1cQ\u0005d\u0003EY\u0015!\u000fJ{U\u000b\u0015\u0011cs\u0002\nG\u0006I<j]\u0012|w\u000f\u000b2-A\u001d*\u0004%\\5okR,7oJ\u0015!\u001fJ#UI\u0015\u0011C3\u0002\nG\u0006I<j]\u0012|wOL:uCJ$\u0018f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011!\u0003FJ!\u0007\r\u001a2[A\nT\u0006M\u0019!aAR\u0004\u0007\r\u001e1a%\u0011\u0004GM\u0019.aEj\u0003'\r\u00111ai\u0002TG\u000f\u00191\u0013I\u0002$'M\u00171c5\u0002\u0014\u0007\t\u00191uA\"$(N\u001d/seJ\u0014(O\u001d\ne)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0013)M\u00053aI\nT\u0006M\u0019.aE\u0002\u0003\u0007\r\u001e1ki\u0002\u0004'\u0003\u001a1eEj\u0003'M\u00171c\u0001\u0002\u0004GO\u00191uA\u0002\u0014B\r\u00193c5\u0002\u0014'\f\u00192AA\u0002$\bM\u001d;ker\u0013(O\u001d:seJ\u0011G\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011Be%\u0011\u0004GM\u0019.aEj\u0003'\r\u00111ai\u0002\u0004G\u000f\u00191\u0013I\u0002$'M\u00171c5\u0002\u0014\u0007\t\u00191uA*$\b\r\u0019\neA\u0012\u0014'\f\u00192[A\n\u0004\u0005\r\u0019;aQRT'\u000f\u0018:seJ\u0014(O\u00052\u0015\u0001\u0002\u0013!B4s_V\u0004\u0018EAAV\u00039!\u0017\r^3uS6,wLZ;oGN\fQa]5oG\u0016\f#!!-\u0002\u000bMrCG\f\u0019\u0002\u0015]Kg\u000eZ8x)&lW\r\u0005\u0002--M)a#!/\u0002FB1\u00111XAa\u0019Jk!!!0\u000b\u0007\u0005}&(A\u0004sk:$\u0018.\\3\n\t\u0005\r\u0017Q\u0018\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\f\u0004\u0003BAd\u0003\u001bl!!!3\u000b\t\u0005-\u0017QJ\u0001\u0003S>L1\u0001SAe)\t\t),\u0001\u0005u_N#(/\u001b8h)\t\t)%A\u0003baBd\u0017\u0010F\u0002S\u00033DQAS\rA\u00021\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002`\u0006\u0015\b\u0003B\u001d\u0002b2K1!a9;\u0005\u0019y\u0005\u000f^5p]\"A\u0011q\u001d\u000e\u0002\u0002\u0003\u0007!+A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"!!<\u0011\t\u0005\u001d\u0013q^\u0005\u0005\u0003c\fIE\u0001\u0004PE*,7\r\u001e")
public class WindowTime
extends UnaryExpression
implements ImplicitCastInputTypes,
Unevaluable,
NonSQLExpression,
Serializable {
    private boolean resolved;
    private final Expression windowColumn;
    private final Seq<Enumeration.Value> nodePatterns;
    private volatile boolean bitmap$0;

    public static Option<Expression> unapply(WindowTime x$0) {
        return WindowTime$.MODULE$.unapply(x$0);
    }

    public static <A> Function1<Expression, A> andThen(Function1<WindowTime, A> g) {
        return WindowTime$.MODULE$.andThen(g);
    }

    public static <A$> Function1<A$, WindowTime> compose(Function1<A$, Expression> g) {
        return WindowTime$.MODULE$.compose(g);
    }

    @Override
    public final String sql() {
        return NonSQLExpression.sql$(this);
    }

    @Override
    public final boolean foldable() {
        return Unevaluable.foldable$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return Unevaluable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return Unevaluable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return Unevaluable.doGenCode$(this, ctx, ev);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression windowColumn() {
        return this.windowColumn;
    }

    @Override
    public Expression child() {
        return this.windowColumn();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StructType$[]{StructType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return ((StructField)((StructType)this.child().dataType()).head()).dataType();
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    @Override
    public String prettyName() {
        return "window_time";
    }

    private boolean resolved$lzycompute() {
        WindowTime windowTime = this;
        synchronized (windowTime) {
            if (!this.bitmap$0) {
                this.resolved = false;
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return !this.bitmap$0 ? this.resolved$lzycompute() : this.resolved;
    }

    @Override
    public WindowTime withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    public WindowTime copy(Expression windowColumn) {
        return new WindowTime(windowColumn);
    }

    public Expression copy$default$1() {
        return this.windowColumn();
    }

    @Override
    public String productPrefix() {
        return "WindowTime";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.windowColumn();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof WindowTime;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "windowColumn";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof WindowTime)) return false;
        boolean bl = true;
        if (!bl) return false;
        WindowTime windowTime = (WindowTime)x$1;
        Expression expression = this.windowColumn();
        Expression expression2 = windowTime.windowColumn();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!windowTime.canEqual(this)) return false;
        return true;
    }

    public WindowTime(Expression windowColumn) {
        this.windowColumn = windowColumn;
        ExpectsInputTypes.$init$(this);
        Unevaluable.$init$(this);
        NonSQLExpression.$init$(this);
        this.nodePatterns = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{TreePattern$.MODULE$.WINDOW_TIME()}));
    }
}

