/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.encoders;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoder;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoders;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ObjectType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.ScalaRunTime$;

public final class EncoderUtils$ {
    public static final EncoderUtils$ MODULE$ = new EncoderUtils$();
    private static final Map<DataType, Class<?>> typeJavaMapping = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BooleanType$.MODULE$), Boolean.TYPE), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ByteType$.MODULE$), Byte.TYPE), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ShortType$.MODULE$), Short.TYPE), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)IntegerType$.MODULE$), Integer.TYPE), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LongType$.MODULE$), Long.TYPE), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)FloatType$.MODULE$), Float.TYPE), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DoubleType$.MODULE$), Double.TYPE), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)StringType$.MODULE$), UTF8String.class), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DateType$.MODULE$), Integer.TYPE), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TimestampType$.MODULE$), Long.TYPE), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TimestampNTZType$.MODULE$), Long.TYPE), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BinaryType$.MODULE$), byte[].class), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)CalendarIntervalType$.MODULE$), CalendarInterval.class)}));
    private static final Map<DataType, Class<?>> typeBoxedJavaMapping = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BooleanType$.MODULE$), Boolean.class), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ByteType$.MODULE$), Byte.class), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ShortType$.MODULE$), Short.class), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)IntegerType$.MODULE$), Integer.class), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LongType$.MODULE$), Long.class), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)FloatType$.MODULE$), Float.class), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DoubleType$.MODULE$), Double.class), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DateType$.MODULE$), Integer.class), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TimestampType$.MODULE$), Long.class), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TimestampNTZType$.MODULE$), Long.class)}));

    public DataType externalDataTypeFor(AgnosticEncoder<?> enc) {
        return this.externalDataTypeFor(enc, false);
    }

    public DataType lenientExternalDataTypeFor(AgnosticEncoder<?> enc) {
        return this.externalDataTypeFor(enc, enc.lenientSerialization());
    }

    private DataType externalDataTypeFor(AgnosticEncoder<?> enc, boolean lenientSerialization) {
        return this.isNativeEncoder(enc) ? enc.dataType() : (lenientSerialization ? new ObjectType(Object.class) : new ObjectType(enc.clsTag().runtimeClass()));
    }

    public boolean isNativeEncoder(AgnosticEncoder<?> enc) {
        AgnosticEncoder<?> agnosticEncoder = enc;
        boolean bl = AgnosticEncoders.PrimitiveBooleanEncoder$.MODULE$.equals(agnosticEncoder) ? true : (AgnosticEncoders.PrimitiveByteEncoder$.MODULE$.equals(agnosticEncoder) ? true : (AgnosticEncoders.PrimitiveShortEncoder$.MODULE$.equals(agnosticEncoder) ? true : (AgnosticEncoders.PrimitiveIntEncoder$.MODULE$.equals(agnosticEncoder) ? true : (AgnosticEncoders.PrimitiveLongEncoder$.MODULE$.equals(agnosticEncoder) ? true : (AgnosticEncoders.PrimitiveFloatEncoder$.MODULE$.equals(agnosticEncoder) ? true : (AgnosticEncoders.PrimitiveDoubleEncoder$.MODULE$.equals(agnosticEncoder) ? true : (AgnosticEncoders.NullEncoder$.MODULE$.equals(agnosticEncoder) ? true : (AgnosticEncoders.CalendarIntervalEncoder$.MODULE$.equals(agnosticEncoder) ? true : (AgnosticEncoders.BinaryEncoder$.MODULE$.equals(agnosticEncoder) ? true : agnosticEncoder instanceof AgnosticEncoders.SparkDecimalEncoder)))))))));
        return bl;
    }

    public Class<?> dataTypeJavaClass(DataType dt) {
        Class clazz;
        DataType dataType = dt;
        if (dataType instanceof DecimalType) {
            clazz = Decimal.class;
        } else if (dataType instanceof DayTimeIntervalType) {
            clazz = Long.TYPE;
        } else if (dataType instanceof YearMonthIntervalType) {
            clazz = Integer.TYPE;
        } else if (dataType instanceof StructType) {
            clazz = InternalRow.class;
        } else if (dataType instanceof ArrayType) {
            clazz = ArrayData.class;
        } else if (dataType instanceof MapType) {
            clazz = MapData.class;
        } else if (dataType instanceof ObjectType) {
            Class cls;
            ObjectType objectType = (ObjectType)dataType;
            clazz = cls = objectType.cls();
        } else {
            clazz = (Class)this.typeJavaMapping().getOrElse((Object)dt, (Function0 & Serializable)() -> Object.class);
        }
        return clazz;
    }

    public Class<?> javaBoxedType(DataType dt) {
        Class clazz;
        block12: {
            DataType dataType;
            while (true) {
                if ((dataType = dt) instanceof DecimalType) {
                    clazz = Decimal.class;
                    break block12;
                }
                if (dataType instanceof DayTimeIntervalType) {
                    clazz = Long.class;
                    break block12;
                }
                if (dataType instanceof YearMonthIntervalType) {
                    clazz = Integer.class;
                    break block12;
                }
                if (BinaryType$.MODULE$.equals(dataType)) {
                    clazz = byte[].class;
                    break block12;
                }
                if (StringType$.MODULE$.equals(dataType)) {
                    clazz = UTF8String.class;
                    break block12;
                }
                if (CalendarIntervalType$.MODULE$.equals(dataType)) {
                    clazz = CalendarInterval.class;
                    break block12;
                }
                if (dataType instanceof StructType) {
                    clazz = InternalRow.class;
                    break block12;
                }
                if (dataType instanceof ArrayType) {
                    clazz = ArrayData.class;
                    break block12;
                }
                if (dataType instanceof MapType) {
                    clazz = MapData.class;
                    break block12;
                }
                if (!(dataType instanceof UserDefinedType)) break;
                UserDefinedType userDefinedType = (UserDefinedType)dataType;
                dt = userDefinedType.sqlType();
            }
            if (dataType instanceof ObjectType) {
                Class cls;
                ObjectType objectType = (ObjectType)dataType;
                clazz = cls = objectType.cls();
            } else {
                clazz = (Class)this.typeBoxedJavaMapping().getOrElse((Object)dt, (Function0 & Serializable)() -> Object.class);
            }
        }
        return clazz;
    }

    public Seq<Class<?>> expressionJavaClasses(Seq<Expression> arguments) {
        Seq<Expression> seq = arguments;
        Nil$ nil$ = package$.MODULE$.Nil();
        return (seq == null ? nil$ != null : !seq.equals((Object)nil$)) ? (Seq)arguments.map((Function1 & Serializable)e -> MODULE$.dataTypeJavaClass(e.dataType())) : (Seq)package$.MODULE$.Seq().empty();
    }

    public Map<DataType, Class<?>> typeJavaMapping() {
        return typeJavaMapping;
    }

    public Map<DataType, Class<?>> typeBoxedJavaMapping() {
        return typeBoxedJavaMapping;
    }

    private EncoderUtils$() {
    }
}

