/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import java.time.ZoneId;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.hadoop.Footer;
import org.apache.parquet.hadoop.ParquetInputFormat;
import org.apache.parquet.hadoop.ParquetRecordReader;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.TaskContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.JoinedRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.codegen.GenerateUnsafeProjection$;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.RebaseDateTime;
import org.apache.spark.sql.execution.datasources.DataSourceUtils$;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.FileFormat$;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.RecordReaderIterator;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFilters;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFooterReader;
import org.apache.spark.sql.execution.datasources.parquet.ParquetOptions;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetRowIndexUtil$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetToSparkSchemaConverter;
import org.apache.spark.sql.execution.datasources.parquet.ParquetUtils$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport$;
import org.apache.spark.sql.execution.datasources.parquet.VectorizedParquetRecordReader;
import org.apache.spark.sql.execution.vectorized.ConstantColumnVector;
import org.apache.spark.sql.execution.vectorized.OffHeapColumnVector;
import org.apache.spark.sql.execution.vectorized.OnHeapColumnVector;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.util.SerializableConfiguration;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\t-d\u0001B\u000f\u001f\u00015BQ\u0001\u0015\u0001\u0005\u0002ECQ\u0001\u0016\u0001\u0005BUCQA\u0018\u0001\u0005BUCQa\u0018\u0001\u0005B\u0001DQ\u0001\u001a\u0001\u0005B\u0015DQA\u001c\u0001\u0005B=Dq!!\t\u0001\t\u0003\n\u0019\u0003C\u0004\u0002H\u0001!\t%!\u0013\t\u000f\u0005E\u0003\u0001\"\u0011\u0002T!9\u0011q\u000e\u0001\u0005B\u0005E\u0004bBAA\u0001\u0011\u0005\u00131\u0011\u0005\b\u0003\u0013\u0004A\u0011IAf\u0011\u001d\t9\u000e\u0001C!\u00033<q!a9\u001f\u0011\u0003\t)O\u0002\u0004\u001e=!\u0005\u0011q\u001d\u0005\u0007!>!\t!a>\t\u0013\u0005exB1A\u0005\u0002\u0005m\b\u0002\u0003B\u0004\u001f\u0001\u0006I!!@\t\u0013\t%qB1A\u0005\u0002\t-\u0001b\u0002B\u0007\u001f\u0001\u0006IA\u0016\u0005\n\u0005\u001fy!\u0019!C\u0001\u0005#A\u0001Ba\u0005\u0010A\u0003%\u0011Q\u001c\u0005\t\u0005+yA\u0011\u0001\u0010\u0003\u0018!A!QF\b\u0005\u0002y\u0011y\u0003C\u0004\u0003<=!\tA!\u0010\t\u000f\t\u001ds\u0002\"\u0001\u0003J!9!\u0011L\b\u0005\n\tm\u0003\"\u0003B1\u001f\u0005\u0005I\u0011\u0002B2\u0005E\u0001\u0016M]9vKR4\u0015\u000e\\3G_Jl\u0017\r\u001e\u0006\u0003?\u0001\nq\u0001]1scV,GO\u0003\u0002\"E\u0005YA-\u0019;bg>,(oY3t\u0015\t\u0019C%A\u0005fq\u0016\u001cW\u000f^5p]*\u0011QEJ\u0001\u0004gFd'BA\u0014)\u0003\u0015\u0019\b/\u0019:l\u0015\tI#&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002W\u0005\u0019qN]4\u0004\u0001M1\u0001A\f\u001b9}\u0011\u0003\"a\f\u001a\u000e\u0003AR\u0011!M\u0001\u0006g\u000e\fG.Y\u0005\u0003gA\u0012a!\u00118z%\u00164\u0007CA\u001b7\u001b\u0005\u0001\u0013BA\u001c!\u0005)1\u0015\u000e\\3G_Jl\u0017\r\u001e\t\u0003sqj\u0011A\u000f\u0006\u0003w\u0011\nqa]8ve\u000e,7/\u0003\u0002>u\t\u0011B)\u0019;b'>,(oY3SK\u001eL7\u000f^3s!\ty$)D\u0001A\u0015\t\te%\u0001\u0005j]R,'O\\1m\u0013\t\u0019\u0005IA\u0004M_\u001e<\u0017N\\4\u0011\u0005\u0015keB\u0001$L\u001d\t9%*D\u0001I\u0015\tIE&\u0001\u0004=e>|GOP\u0005\u0002c%\u0011A\nM\u0001\ba\u0006\u001c7.Y4f\u0013\tquJ\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002Ma\u00051A(\u001b8jiz\"\u0012A\u0015\t\u0003'\u0002i\u0011AH\u0001\ng\"|'\u000f\u001e(b[\u0016$\u0012A\u0016\t\u0003/ns!\u0001W-\u0011\u0005\u001d\u0003\u0014B\u0001.1\u0003\u0019\u0001&/\u001a3fM&\u0011A,\u0018\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005i\u0003\u0014\u0001\u0003;p'R\u0014\u0018N\\4\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012!\u0019\t\u0003_\tL!a\u0019\u0019\u0003\u0007%sG/\u0001\u0004fcV\fGn\u001d\u000b\u0003M&\u0004\"aL4\n\u0005!\u0004$a\u0002\"p_2,\u0017M\u001c\u0005\u0006U\u0016\u0001\ra[\u0001\u0006_RDWM\u001d\t\u0003_1L!!\u001c\u0019\u0003\u0007\u0005s\u00170\u0001\u0007qe\u0016\u0004\u0018M]3Xe&$X\rF\u0004qgf\f9!!\u0005\u0011\u0005U\n\u0018B\u0001:!\u0005MyU\u000f\u001e9vi^\u0013\u0018\u000e^3s\r\u0006\u001cGo\u001c:z\u0011\u0015!h\u00011\u0001v\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o!\t1x/D\u0001%\u0013\tAHE\u0001\u0007Ta\u0006\u00148nU3tg&|g\u000eC\u0003{\r\u0001\u000710A\u0002k_\n\u00042\u0001`A\u0002\u001b\u0005i(B\u0001@\u0000\u0003%i\u0017\r\u001d:fIV\u001cWMC\u0002\u0002\u0002!\na\u0001[1e_>\u0004\u0018bAA\u0003{\n\u0019!j\u001c2\t\u000f\u0005%a\u00011\u0001\u0002\f\u00059q\u000e\u001d;j_:\u001c\b#B,\u0002\u000eY3\u0016bAA\b;\n\u0019Q*\u00199\t\u000f\u0005Ma\u00011\u0001\u0002\u0016\u0005QA-\u0019;b'\u000eDW-\\1\u0011\t\u0005]\u0011QD\u0007\u0003\u00033Q1!a\u0007%\u0003\u0015!\u0018\u0010]3t\u0013\u0011\ty\"!\u0007\u0003\u0015M#(/^2u)f\u0004X-A\u0006j]\u001a,'oU2iK6\fG\u0003CA\u0013\u0003W\ti#!\r\u0011\u000b=\n9#!\u0006\n\u0007\u0005%\u0002G\u0001\u0004PaRLwN\u001c\u0005\u0006i\u001e\u0001\r!\u001e\u0005\b\u0003_9\u0001\u0019AA\u0006\u0003)\u0001\u0018M]1nKR,'o\u001d\u0005\b\u0003g9\u0001\u0019AA\u001b\u0003\u00151\u0017\u000e\\3t!\u0015)\u0015qGA\u001e\u0013\r\tId\u0014\u0002\u0004'\u0016\f\b\u0003BA\u001f\u0003\u0007j!!a\u0010\u000b\u0007\u0005\u0005s0\u0001\u0002gg&!\u0011QIA \u0005)1\u0015\u000e\\3Ti\u0006$Xo]\u0001\rgV\u0004\bo\u001c:u\u0005\u0006$8\r\u001b\u000b\u0006M\u0006-\u0013Q\n\u0005\u0006i\"\u0001\r!\u001e\u0005\b\u0003\u001fB\u0001\u0019AA\u000b\u0003\u0019\u00198\r[3nC\u0006Ya/Z2u_J$\u0016\u0010]3t)!\t)&!\u0017\u0002^\u0005\u0005\u0004#B\u0018\u0002(\u0005]\u0003\u0003B#\u00028YCq!a\u0017\n\u0001\u0004\t)\"\u0001\bsKF,\u0018N]3e'\u000eDW-\\1\t\u000f\u0005}\u0013\u00021\u0001\u0002\u0016\u0005y\u0001/\u0019:uSRLwN\\*dQ\u0016l\u0017\rC\u0004\u0002d%\u0001\r!!\u001a\u0002\u000fM\fHnQ8oMB!\u0011qMA6\u001b\t\tIG\u0003\u0002BI%!\u0011QNA5\u0005\u001d\u0019\u0016\u000bT\"p]\u001a\f1\"[:Ta2LG/\u00192mKR9a-a\u001d\u0002v\u0005]\u0004\"\u0002;\u000b\u0001\u0004)\bbBA\u0005\u0015\u0001\u0007\u00111\u0002\u0005\b\u0003sR\u0001\u0019AA>\u0003\u0011\u0001\u0018\r\u001e5\u0011\t\u0005u\u0012QP\u0005\u0005\u0003\u007f\nyD\u0001\u0003QCRD\u0017A\b2vS2$'+Z1eKJ<\u0016\u000e\u001e5QCJ$\u0018\u000e^5p]Z\u000bG.^3t)A\t))a)\u0002&\u0006\u001d\u0016\u0011VAV\u0003o\u000bI\fE\u00040\u0003\u000f\u000bY)!%\n\u0007\u0005%\u0005GA\u0005Gk:\u001cG/[8ocA\u0019Q'!$\n\u0007\u0005=\u0005EA\bQCJ$\u0018\u000e^5p]\u0016$g)\u001b7f!\u0015)\u00151SAL\u0013\r\t)j\u0014\u0002\t\u0013R,'/\u0019;peB!\u0011\u0011TAP\u001b\t\tYJC\u0002\u0002\u001e\u0012\n\u0001bY1uC2L8\u000f^\u0005\u0005\u0003C\u000bYJA\u0006J]R,'O\\1m%><\b\"\u0002;\f\u0001\u0004)\bbBA\n\u0017\u0001\u0007\u0011Q\u0003\u0005\b\u0003?Z\u0001\u0019AA\u000b\u0011\u001d\tYf\u0003a\u0001\u0003+Aq!!,\f\u0001\u0004\ty+A\u0004gS2$XM]:\u0011\u000b\u0015\u000b9$!-\u0011\u0007e\n\u0019,C\u0002\u00026j\u0012aAR5mi\u0016\u0014\bbBA\u0005\u0017\u0001\u0007\u00111\u0002\u0005\b\u0003w[\u0001\u0019AA_\u0003)A\u0017\rZ8pa\u000e{gN\u001a\t\u0005\u0003\u007f\u000b)-\u0004\u0002\u0002B*\u0019\u00111Y@\u0002\t\r|gNZ\u0005\u0005\u0003\u000f\f\tMA\u0007D_:4\u0017nZ;sCRLwN\\\u0001\u0010gV\u0004\bo\u001c:u\t\u0006$\u0018\rV=qKR\u0019a-!4\t\u000f\u0005=G\u00021\u0001\u0002R\u0006AA-\u0019;b)f\u0004X\r\u0005\u0003\u0002\u0018\u0005M\u0017\u0002BAk\u00033\u0011\u0001\u0002R1uCRK\b/Z\u0001\u0015[\u0016$\u0018\rZ1uCN\u001b\u0007.Z7b\r&,G\u000eZ:\u0016\u0005\u0005m\u0007#B#\u00028\u0005u\u0007\u0003BA\f\u0003?LA!!9\u0002\u001a\tY1\u000b\u001e:vGR4\u0015.\u001a7e\u0003E\u0001\u0016M]9vKR4\u0015\u000e\\3G_Jl\u0017\r\u001e\t\u0003'>\u0019Ra\u0004\u0018?\u0003S\u0004B!a;\u0002v6\u0011\u0011Q\u001e\u0006\u0005\u0003_\f\t0\u0001\u0002j_*\u0011\u00111_\u0001\u0005U\u00064\u0018-C\u0002O\u0003[$\"!!:\u0002\u0013I{ukX%O\t\u0016CVCAA\u007f!\u0011\tyP!\u0002\u000e\u0005\t\u0005!\u0002\u0002B\u0002\u0003c\fA\u0001\\1oO&\u0019AL!\u0001\u0002\u0015I{ukX%O\t\u0016C\u0006%A\u0010S\u001f^{\u0016J\u0014#F1~#V)\u0014)P%\u0006\u0013\u0016lX\"P\u0019Vkej\u0018(B\u001b\u0016+\u0012AV\u0001!%>;v,\u0013(E\u000bb{F+R'Q\u001fJ\u000b%+W0D\u001f2+VJT0O\u00036+\u0005%A\bS\u001f^{\u0016J\u0014#F1~3\u0015*\u0012'E+\t\ti.\u0001\tS\u001f^{\u0016J\u0014#F1~3\u0015*\u0012'EA\u0005Q!/Z1e'\u000eDW-\\1\u0015\r\u0005\u0015\"\u0011\u0004B\u0016\u0011\u001d\u0011Yb\u0006a\u0001\u0005;\tqAZ8pi\u0016\u00148\u000fE\u0003F\u0003o\u0011y\u0002\u0005\u0003\u0003\"\t\u001dRB\u0001B\u0012\u0015\u0011\t\tA!\n\u000b\u0005}A\u0013\u0002\u0002B\u0015\u0005G\u0011aAR8pi\u0016\u0014\b\"\u0002;\u0018\u0001\u0004)\u0018\u0001\b:fC\u0012\u0004\u0016M]9vKR4un\u001c;feNLe\u000eU1sC2dW\r\u001c\u000b\t\u0005;\u0011\tDa\r\u00038!9\u00111\u0019\rA\u0002\u0005u\u0006b\u0002B\u001b1\u0001\u0007\u0011QG\u0001\na\u0006\u0014HOR5mKNDaA!\u000f\u0019\u0001\u00041\u0017AE5h]>\u0014XmQ8seV\u0004HOR5mKN\fa#\\3sO\u0016\u001c6\r[3nCNLe\u000eU1sC2dW\r\u001c\u000b\t\u0003K\u0011yD!\u0011\u0003F!9\u0011qF\rA\u0002\u0005-\u0001b\u0002B\"3\u0001\u0007\u0011QG\u0001\rM&dWm\u001d+p)>,8\r\u001b\u0005\u0006if\u0001\r!^\u0001\u0015e\u0016\fGmU2iK6\fgI]8n\r>|G/\u001a:\u0015\r\u0005U!1\nB(\u0011\u001d\u0011iE\u0007a\u0001\u0005?\taAZ8pi\u0016\u0014\bb\u0002B)5\u0001\u0007!1K\u0001\nG>tg/\u001a:uKJ\u00042a\u0015B+\u0013\r\u00119F\b\u0002\u001e!\u0006\u0014\u0018/^3u)>\u001c\u0006/\u0019:l'\u000eDW-\\1D_:4XM\u001d;fe\u00069B-Z:fe&\fG.\u001b>f'\u000eDW-\\1TiJLgn\u001a\u000b\u0005\u0003K\u0011i\u0006\u0003\u0004\u0003`m\u0001\rAV\u0001\rg\u000eDW-\\1TiJLgnZ\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0005K\u0002B!a@\u0003h%!!\u0011\u000eB\u0001\u0005\u0019y%M[3di\u0002")
public class ParquetFileFormat
implements FileFormat,
DataSourceRegister,
Logging,
Serializable {
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static StructType readSchemaFromFooter(Footer footer, ParquetToSparkSchemaConverter converter) {
        return ParquetFileFormat$.MODULE$.readSchemaFromFooter(footer, converter);
    }

    public static Option<StructType> mergeSchemasInParallel(scala.collection.immutable.Map<String, String> parameters, Seq<FileStatus> filesToTouch, SparkSession sparkSession) {
        return ParquetFileFormat$.MODULE$.mergeSchemasInParallel(parameters, filesToTouch, sparkSession);
    }

    public static StructField ROW_INDEX_FIELD() {
        return ParquetFileFormat$.MODULE$.ROW_INDEX_FIELD();
    }

    public static String ROW_INDEX_TEMPORARY_COLUMN_NAME() {
        return ParquetFileFormat$.MODULE$.ROW_INDEX_TEMPORARY_COLUMN_NAME();
    }

    public static String ROW_INDEX() {
        return ParquetFileFormat$.MODULE$.ROW_INDEX();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, scala.collection.immutable.Map<String, String> options, Configuration hadoopConf) {
        return FileFormat.buildReader$(this, sparkSession, dataSchema, partitionSchema, requiredSchema, filters, options, hadoopConf);
    }

    @Override
    public AttributeReference createFileMetadataCol() {
        return FileFormat.createFileMetadataCol$(this);
    }

    @Override
    public boolean supportFieldName(String name) {
        return FileFormat.supportFieldName$(this, name);
    }

    @Override
    public scala.collection.immutable.Map<String, Function1<PartitionedFile, Object>> fileConstantMetadataExtractors() {
        return FileFormat.fileConstantMetadataExtractors$(this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public String shortName() {
        return "parquet";
    }

    public String toString() {
        return "Parquet";
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof ParquetFileFormat;
    }

    @Override
    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, scala.collection.immutable.Map<String, String> options, StructType dataSchema) {
        SQLConf sqlConf = sparkSession.sessionState().conf();
        ParquetOptions parquetOptions = new ParquetOptions(options, sqlConf);
        return ParquetUtils$.MODULE$.prepareWrite(sqlConf, job, dataSchema, parquetOptions);
    }

    @Override
    public Option<StructType> inferSchema(SparkSession sparkSession, scala.collection.immutable.Map<String, String> parameters, Seq<FileStatus> files) {
        return ParquetUtils$.MODULE$.inferSchema(sparkSession, parameters, files);
    }

    @Override
    public boolean supportBatch(SparkSession sparkSession, StructType schema) {
        SQLConf conf = sparkSession.sessionState().conf();
        return ParquetUtils$.MODULE$.isBatchReadSupportedForSchema(conf, schema);
    }

    @Override
    public Option<Seq<String>> vectorTypes(StructType requiredSchema, StructType partitionSchema, SQLConf sqlConf) {
        return Option$.MODULE$.apply(((IterableOps)package$.MODULE$.Seq().fill(requiredSchema.fields().length, (Function0 & Serializable)() -> !sqlConf.offHeapColumnVectorEnabled() ? OnHeapColumnVector.class.getName() : OffHeapColumnVector.class.getName())).$plus$plus((IterableOnce)package$.MODULE$.Seq().fill(partitionSchema.fields().length, (Function0 & Serializable)() -> ConstantColumnVector.class.getName())));
    }

    @Override
    public boolean isSplitable(SparkSession sparkSession, scala.collection.immutable.Map<String, String> options, Path path) {
        return true;
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReaderWithPartitionValues(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, scala.collection.immutable.Map<String, String> options, Configuration hadoopConf) {
        boolean returningBatch;
        String int96RebaseModeInRead;
        String datetimeRebaseModeInRead;
        boolean isCaseSensitive;
        int pushDownInFilterThreshold;
        boolean pushDownStringPredicate;
        boolean pushDownDecimal;
        boolean pushDownTimestamp;
        boolean pushDownDate;
        boolean enableParquetFilterPushDown;
        int capacity;
        boolean timestampConversion;
        boolean enableRecordFilter;
        boolean enableVectorizedReader;
        boolean enableOffHeapColumnVector;
        Broadcast broadcastedHadoopConf;
        block0: {
            hadoopConf.set("parquet.read.support.class", ParquetReadSupport.class.getName());
            hadoopConf.set(ParquetReadSupport$.MODULE$.SPARK_ROW_REQUESTED_SCHEMA(), requiredSchema.json());
            hadoopConf.set(ParquetWriteSupport$.MODULE$.SPARK_ROW_SCHEMA(), requiredSchema.json());
            hadoopConf.set(SQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key(), sparkSession.sessionState().conf().sessionLocalTimeZone());
            hadoopConf.setBoolean(SQLConf$.MODULE$.NESTED_SCHEMA_PRUNING_ENABLED().key(), sparkSession.sessionState().conf().nestedSchemaPruningEnabled());
            hadoopConf.setBoolean(SQLConf$.MODULE$.CASE_SENSITIVE().key(), sparkSession.sessionState().conf().caseSensitiveAnalysis());
            hadoopConf.setBoolean(SQLConf$.MODULE$.PARQUET_BINARY_AS_STRING().key(), sparkSession.sessionState().conf().isParquetBinaryAsString());
            hadoopConf.setBoolean(SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP().key(), sparkSession.sessionState().conf().isParquetINT96AsTimestamp());
            hadoopConf.setBoolean(SQLConf$.MODULE$.PARQUET_INFER_TIMESTAMP_NTZ_ENABLED().key(), sparkSession.sessionState().conf().parquetInferTimestampNTZEnabled());
            hadoopConf.setBoolean(SQLConf$.MODULE$.LEGACY_PARQUET_NANOS_AS_LONG().key(), sparkSession.sessionState().conf().legacyParquetNanosAsLong());
            broadcastedHadoopConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
            StructType resultSchema = new StructType((StructField[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])partitionSchema.fields()), (Object)requiredSchema.fields(), ClassTag$.MODULE$.apply(StructField.class)));
            SQLConf sqlConf = sparkSession.sessionState().conf();
            enableOffHeapColumnVector = sqlConf.offHeapColumnVectorEnabled();
            enableVectorizedReader = ParquetUtils$.MODULE$.isBatchReadSupportedForSchema(sqlConf, resultSchema);
            enableRecordFilter = sqlConf.parquetRecordFilterEnabled();
            timestampConversion = sqlConf.isParquetINT96TimestampConversion();
            capacity = sqlConf.parquetVectorizedReaderBatchSize();
            enableParquetFilterPushDown = sqlConf.parquetFilterPushDown();
            pushDownDate = sqlConf.parquetFilterPushDownDate();
            pushDownTimestamp = sqlConf.parquetFilterPushDownTimestamp();
            pushDownDecimal = sqlConf.parquetFilterPushDownDecimal();
            pushDownStringPredicate = sqlConf.parquetFilterPushDownStringPredicate();
            pushDownInFilterThreshold = sqlConf.parquetFilterPushDownInFilterThreshold();
            isCaseSensitive = sqlConf.caseSensitiveAnalysis();
            ParquetOptions parquetOptions = new ParquetOptions(options, sparkSession.sessionState().conf());
            datetimeRebaseModeInRead = parquetOptions.datetimeRebaseModeInRead();
            int96RebaseModeInRead = parquetOptions.int96RebaseModeInRead();
            boolean bl = returningBatch = sparkSession.sessionState().conf().parquetVectorizedReaderEnabled() && ((String)options.getOrElse((Object)FileFormat$.MODULE$.OPTION_RETURNING_BATCH(), (Function0 & Serializable)() -> {
                throw new IllegalArgumentException("OPTION_RETURNING_BATCH should always be set for ParquetFileFormat. To workaround this issue, set spark.sql.parquet.enableVectorizedReader=false.");
            })).equals("true");
            if (!returningBatch) break block0;
            Predef$.MODULE$.assert(this.supportBatch(sparkSession, resultSchema));
        }
        return (Function1 & Serializable)file -> {
            ParquetRecordReader parquetRecordReader;
            RecordReaderIterator<Object> recordReaderIterator;
            None$ none$;
            Predef$.MODULE$.assert(file.partitionValues().numFields() == partitionSchema.size());
            Path filePath = file.toPath();
            FileSplit split = new FileSplit(filePath, file.start(), file.length(), (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
            Configuration sharedConf = ((SerializableConfiguration)broadcastedHadoopConf.value()).value();
            ParquetMetadata fileFooter = enableVectorizedReader ? ParquetFooterReader.readFooter(sharedConf, file, false) : ParquetFooterReader.readFooter(sharedConf, file, true);
            FileMetaData footerFileMetaData = fileFooter.getFileMetaData();
            Map map = footerFileMetaData.getKeyValueMetaData();
            RebaseDateTime.RebaseSpec datetimeRebaseSpec = DataSourceUtils$.MODULE$.datetimeRebaseSpec((Function1<String, String>)(Function1 & Serializable)x$1 -> (String)map.get(x$1), datetimeRebaseModeInRead);
            Map map2 = footerFileMetaData.getKeyValueMetaData();
            RebaseDateTime.RebaseSpec int96RebaseSpec = DataSourceUtils$.MODULE$.int96RebaseSpec((Function1<String, String>)(Function1 & Serializable)x$1 -> (String)map2.get(x$1), int96RebaseModeInRead);
            if (enableParquetFilterPushDown) {
                MessageType parquetSchema = footerFileMetaData.getSchema();
                ParquetFilters parquetFilters = new ParquetFilters(parquetSchema, pushDownDate, pushDownTimestamp, pushDownDecimal, pushDownStringPredicate, pushDownInFilterThreshold, isCaseSensitive, datetimeRebaseSpec);
                none$ = ((IterableOnceOps)filters.flatMap((Function1 & Serializable)x$1 -> parquetFilters.createFilter((Filter)x$1))).reduceOption((Function2 & Serializable)(x$1, x$2) -> FilterApi.and((FilterPredicate)x$1, (FilterPredicate)x$2));
            } else {
                none$ = None$.MODULE$;
            }
            None$ pushed = none$;
            None$ convertTz = timestampConversion && !ParquetFileFormat.isCreatedByParquetMr$1(footerFileMetaData) ? new Some((Object)DateTimeUtils$.MODULE$.getZoneId(sharedConf.get(SQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key()))) : None$.MODULE$;
            TaskAttemptID attemptId = new TaskAttemptID(new TaskID(new JobID(), TaskType.MAP, 0), 0);
            TaskAttemptContextImpl hadoopAttemptContext = new TaskAttemptContextImpl(((SerializableConfiguration)broadcastedHadoopConf.value()).value(), attemptId);
            if (pushed.isDefined()) {
                ParquetInputFormat.setFilterPredicate((Configuration)hadoopAttemptContext.getConfiguration(), (FilterPredicate)((FilterPredicate)pushed.get()));
            }
            Option taskContext = Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get());
            if (enableVectorizedReader) {
                VectorizedParquetRecordReader vectorizedReader = new VectorizedParquetRecordReader((ZoneId)convertTz.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), datetimeRebaseSpec.mode().toString(), datetimeRebaseSpec.timeZone(), int96RebaseSpec.mode().toString(), int96RebaseSpec.timeZone(), enableOffHeapColumnVector && taskContext.isDefined(), capacity);
                RecordReaderIterator<Object> iter = new RecordReaderIterator<Object>(vectorizedReader);
                try {
                    vectorizedReader.initialize((InputSplit)split, (TaskAttemptContext)hadoopAttemptContext, (Option<ParquetMetadata>)Option$.MODULE$.apply((Object)fileFooter));
                    this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(11).append("Appending ").append(partitionSchema).append(" ").append(file.partitionValues()).toString());
                    vectorizedReader.initBatch(partitionSchema, file.partitionValues());
                    if (returningBatch) {
                        vectorizedReader.enableReturningBatches();
                    }
                    recordReaderIterator = iter;
                }
                catch (Throwable e) {
                    iter.close();
                    throw e;
                }
            }
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Falling back to parquet-mr");
            ParquetReadSupport readSupport = new ParquetReadSupport((Option<ZoneId>)convertTz, false, datetimeRebaseSpec, int96RebaseSpec);
            if (pushed.isDefined() && enableRecordFilter) {
                FilterCompat.Filter parquetFilter = FilterCompat.get((FilterPredicate)((FilterPredicate)pushed.get()), null);
                parquetRecordReader = new ParquetRecordReader((ReadSupport)readSupport, parquetFilter);
            } else {
                parquetRecordReader = new ParquetRecordReader((ReadSupport)readSupport);
            }
            ParquetRecordReader reader = parquetRecordReader;
            RecordReader<Void, InternalRow> readerWithRowIndexes = ParquetRowIndexUtil$.MODULE$.addRowIndexToRecordReaderIfNeeded((ParquetRecordReader<InternalRow>)reader, requiredSchema);
            RecordReaderIterator<InternalRow> iter = new RecordReaderIterator<InternalRow>(readerWithRowIndexes);
            try {
                readerWithRowIndexes.initialize((InputSplit)split, (TaskAttemptContext)hadoopAttemptContext);
                Seq fullSchema = (Seq)DataTypeUtils$.MODULE$.toAttributes(requiredSchema).$plus$plus((IterableOnce)DataTypeUtils$.MODULE$.toAttributes(partitionSchema));
                UnsafeProjection unsafeProjection = (UnsafeProjection)GenerateUnsafeProjection$.MODULE$.generate((Object)fullSchema, fullSchema);
                if (partitionSchema.length() == 0) {
                    recordReaderIterator = iter.map(unsafeProjection);
                } else {
                    JoinedRow joinedRow = new JoinedRow();
                    recordReaderIterator = iter.map((Function1 & Serializable)d -> unsafeProjection.apply((InternalRow)joinedRow.apply(d, file.partitionValues())));
                }
            }
            catch (Throwable e) {
                iter.close();
                throw e;
            }
            return recordReaderIterator;
        };
    }

    @Override
    public boolean supportDataType(DataType dataType) {
        boolean bl;
        DataType dataType2 = dataType;
        if (dataType2 instanceof AtomicType) {
            bl = true;
        } else if (dataType2 instanceof StructType) {
            StructType structType = (StructType)dataType2;
            bl = structType.forall((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)this.supportDataType(f.dataType())));
        } else if (dataType2 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            DataType elementType = arrayType.elementType();
            bl = this.supportDataType(elementType);
        } else if (dataType2 instanceof MapType) {
            MapType mapType = (MapType)dataType2;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            bl = this.supportDataType(keyType) && this.supportDataType(valueType);
        } else if (dataType2 instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            bl = this.supportDataType(userDefinedType.sqlType());
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public Seq<StructField> metadataSchemaFields() {
        return (Seq)FileFormat.metadataSchemaFields$(this).$colon$plus((Object)ParquetFileFormat$.MODULE$.ROW_INDEX_FIELD());
    }

    private static final boolean isCreatedByParquetMr$1(FileMetaData footerFileMetaData$1) {
        return footerFileMetaData$1.getCreatedBy().startsWith("parquet-mr");
    }

    public ParquetFileFormat() {
        FileFormat.$init$(this);
        Logging.$init$((Logging)this);
    }
}

