/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.spark.SparkException;
import org.apache.spark.ml.feature.Bucketizer;
import org.apache.spark.ml.util.DefaultParamsReadable;
import org.apache.spark.ml.util.MLReadable;
import org.apache.spark.ml.util.MLReader;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class Bucketizer$
implements DefaultParamsReadable<Bucketizer>,
Serializable {
    public static final Bucketizer$ MODULE$ = new Bucketizer$();
    private static final String SKIP_INVALID;
    private static final String ERROR_INVALID;
    private static final String KEEP_INVALID;
    private static final String[] supportedHandleInvalids;

    static {
        MLReadable.$init$(MODULE$);
        DefaultParamsReadable.$init$(MODULE$);
        SKIP_INVALID = "skip";
        ERROR_INVALID = "error";
        KEEP_INVALID = "keep";
        supportedHandleInvalids = (String[])((Object[])new String[]{MODULE$.SKIP_INVALID(), MODULE$.ERROR_INVALID(), MODULE$.KEEP_INVALID()});
    }

    @Override
    public MLReader<Bucketizer> read() {
        return DefaultParamsReadable.read$(this);
    }

    public String SKIP_INVALID() {
        return SKIP_INVALID;
    }

    public String ERROR_INVALID() {
        return ERROR_INVALID;
    }

    public String KEEP_INVALID() {
        return KEEP_INVALID;
    }

    public String[] supportedHandleInvalids() {
        return supportedHandleInvalids;
    }

    public boolean checkSplits(double[] splits) {
        boolean bl;
        if (splits.length < 3) {
            bl = false;
        } else {
            int n = splits.length - 1;
            for (int i = 0; i < n; ++i) {
                if (!(splits[i] >= splits[i + 1]) && !Double.isNaN(splits[i])) continue;
                return false;
            }
            bl = !Double.isNaN(splits[n]);
        }
        return bl;
    }

    public boolean checkSplitsArray(double[][] splitsArray) {
        return ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.refArrayOps((Object[])splitsArray), (Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)Bucketizer$.MODULE$.checkSplits(x$3)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double binarySearchForBuckets(double[] splits, double feature, boolean keepInvalid) {
        double d;
        if (Double.isNaN(feature)) {
            if (!keepInvalid) throw new SparkException("Bucketizer encountered NaN value. To handle or skip NaNs, try setting Bucketizer.handleInvalid.");
            d = splits.length - 1;
            return d;
        } else if (feature == BoxesRunTime.unboxToDouble((Object)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.doubleArrayOps(splits)))) {
            d = splits.length - 2;
            return d;
        } else {
            int idx = Arrays.binarySearch(splits, feature);
            if (idx >= 0) {
                d = idx;
                return d;
            } else {
                int insertPos = -idx - 1;
                if (insertPos == 0 || insertPos == splits.length) {
                    throw new SparkException(new StringBuilder(0).append(new StringBuilder(39).append("Feature value ").append(feature).append(" out of Bucketizer bounds").toString()).append(new StringBuilder(38).append(" [").append(ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.doubleArrayOps(splits))).append(", ").append(ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.doubleArrayOps(splits))).append("]. Check your features, or loosen ").toString()).append("the lower/upper bound constraints.").toString());
                }
                d = insertPos - 1;
            }
        }
        return d;
    }

    @Override
    public Bucketizer load(String path) {
        return (Bucketizer)MLReadable.load$(this, path);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Bucketizer$.class);
    }

    private Bucketizer$() {
    }
}

