/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.clustering;

import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.clustering.KMeans$;
import org.apache.spark.ml.clustering.KMeansAggregator;
import org.apache.spark.ml.clustering.KMeansModel;
import org.apache.spark.ml.clustering.KMeansParams;
import org.apache.spark.ml.clustering.KMeansSummary;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.feature.InstanceBlock;
import org.apache.spark.ml.feature.InstanceBlock$;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.DenseMatrix;
import org.apache.spark.ml.linalg.DenseMatrix$;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasDistanceMeasure;
import org.apache.spark.ml.param.shared.HasFeaturesCol;
import org.apache.spark.ml.param.shared.HasMaxBlockSizeInMB;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasPredictionCol;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.param.shared.HasSolver;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.stat.Summarizer$;
import org.apache.spark.ml.util.DatasetUtils$;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.Instrumentation;
import org.apache.spark.ml.util.Instrumentation$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.util.DoubleAccumulator;
import org.apache.spark.util.LongAccumulator;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.RichDouble$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\tMf\u0001\u0002\u00192\u0001qB\u0001B\u0014\u0001\u0003\u0006\u0004%\te\u0014\u0005\tM\u0002\u0011\t\u0011)A\u0005!\")\u0001\u000e\u0001C\u0001S\")a\u000e\u0001C!_\")\u0001\u000e\u0001C\u0001s\")1\u0010\u0001C\u0001y\"9\u00111\u0001\u0001\u0005\u0002\u0005\u0015\u0001bBA\u0006\u0001\u0011\u0005\u0011Q\u0002\u0005\b\u00037\u0001A\u0011AA\u000f\u0011\u001d\t\u0019\u0003\u0001C\u0001\u0003KAq!a\f\u0001\t\u0003\t\t\u0004C\u0004\u00028\u0001!\t!!\u000f\t\u000f\u0005}\u0002\u0001\"\u0001\u0002B!9\u0011Q\n\u0001\u0005\u0002\u0005=\u0003bBA.\u0001\u0011\u0005\u0011Q\f\u0005\b\u0003O\u0002A\u0011AA5\u0011\u001d\t\u0019\b\u0001C\u0001\u0003kBq!a\u001f\u0001\t\u0003\ni\bC\u0004\u0002.\u0002!I!a,\t\u000f\u0005\r\u0007\u0001\"\u0003\u0002F\"9\u0011\u0011\u001e\u0001\u0005\n\u0005-\bbBA~\u0001\u0011%\u0011Q \u0005\b\u0005#\u0001A\u0011\u0002B\n\u0011\u001d\u00119\u0003\u0001C!\u0005S9qAa\u00102\u0011\u0003\u0011\tE\u0002\u00041c!\u0005!1\t\u0005\u0007Qj!\tA!\u0019\t\u000f\t\r$\u0004\"\u0011\u0003f!Q!\u0011\u000f\u000eC\u0002\u0013\u0005\u0011Ga\u001d\t\u0011\t}$\u0004)A\u0005\u0005kB!B!!\u001b\u0005\u0004%\t!\rB:\u0011!\u0011\u0019I\u0007Q\u0001\n\tU\u0004B\u0003BC5\t\u0007I\u0011A\u0019\u0003\b\"A!1\u0012\u000e!\u0002\u0013\u0011I\t\u0003\u0006\u0003\u000ej\u0011\r\u0011\"\u00012\u0005gB\u0001Ba$\u001bA\u0003%!Q\u000f\u0005\u000b\u0005#S\"\u0019!C\u0001c\tM\u0004\u0002\u0003BJ5\u0001\u0006IA!\u001e\t\u0015\tU%D1A\u0005\u0002E\u0012\u0019\b\u0003\u0005\u0003\u0018j\u0001\u000b\u0011\u0002B;\u0011)\u0011IJ\u0007b\u0001\n\u0003\t$1\u000f\u0005\t\u00057S\u0002\u0015!\u0003\u0003v!Q!Q\u0014\u000eC\u0002\u0013\u0005\u0011Ga\u001d\t\u0011\t}%\u0004)A\u0005\u0005kB!B!)\u001b\u0005\u0004%\t!\rBD\u0011!\u0011\u0019K\u0007Q\u0001\n\t%\u0005\"\u0003BS5\u0005\u0005I\u0011\u0002BT\u0005\u0019YU*Z1og*\u0011!gM\u0001\u000bG2,8\u000f^3sS:<'B\u0001\u001b6\u0003\tiGN\u0003\u00027o\u0005)1\u000f]1sW*\u0011\u0001(O\u0001\u0007CB\f7\r[3\u000b\u0003i\n1a\u001c:h\u0007\u0001\u0019B\u0001A\u001fF\u0011B\u0019ahP!\u000e\u0003MJ!\u0001Q\u001a\u0003\u0013\u0015\u001bH/[7bi>\u0014\bC\u0001\"D\u001b\u0005\t\u0014B\u0001#2\u0005-YU*Z1og6{G-\u001a7\u0011\u0005\t3\u0015BA$2\u00051YU*Z1ogB\u000b'/Y7t!\tIE*D\u0001K\u0015\tY5'\u0001\u0003vi&d\u0017BA'K\u0005U!UMZ1vYR\u0004\u0016M]1ng^\u0013\u0018\u000e^1cY\u0016\f1!^5e+\u0005\u0001\u0006CA)[\u001d\t\u0011\u0006\f\u0005\u0002T-6\tAK\u0003\u0002Vw\u00051AH]8pizR\u0011aV\u0001\u0006g\u000e\fG.Y\u0005\u00033Z\u000ba\u0001\u0015:fI\u00164\u0017BA.]\u0005\u0019\u0019FO]5oO*\u0011\u0011L\u0016\u0015\u0004\u0003y#\u0007CA0c\u001b\u0005\u0001'BA16\u0003)\tgN\\8uCRLwN\\\u0005\u0003G\u0002\u0014QaU5oG\u0016\f\u0013!Z\u0001\u0006c9*d\u0006M\u0001\u0005k&$\u0007\u0005K\u0002\u0003=\u0012\fa\u0001P5oSRtDC\u00016l!\t\u0011\u0005\u0001C\u0003O\u0007\u0001\u0007\u0001\u000bK\u0002l=\u0012D3a\u00010e\u0003\u0011\u0019w\u000e]=\u0015\u0005)\u0004\b\"B9\u0005\u0001\u0004\u0011\u0018!B3yiJ\f\u0007CA:w\u001b\u0005!(BA;4\u0003\u0015\u0001\u0018M]1n\u0013\t9HO\u0001\u0005QCJ\fW.T1qQ\r!a\f\u001a\u000b\u0002U\"\u001aQA\u00183\u0002\u001dM,GOR3biV\u0014Xm]\"pYR\u0011QP`\u0007\u0002\u0001!)qP\u0002a\u0001!\u0006)a/\u00197vK\"\u001aaA\u00183\u0002!M,G\u000f\u0015:fI&\u001cG/[8o\u0007>dGcA?\u0002\b!)qp\u0002a\u0001!\"\u001aqA\u00183\u0002\tM,Go\u0013\u000b\u0004{\u0006=\u0001BB@\t\u0001\u0004\t\t\u0002\u0005\u0003\u0002\u0014\u0005UQ\"\u0001,\n\u0007\u0005]aKA\u0002J]RD3\u0001\u00030e\u0003-\u0019X\r^%oSRlu\u000eZ3\u0015\u0007u\fy\u0002C\u0003\u0000\u0013\u0001\u0007\u0001\u000bK\u0002\n=\u0012\f!c]3u\t&\u001cH/\u00198dK6+\u0017m];sKR\u0019Q0a\n\t\u000b}T\u0001\u0019\u0001))\t)q\u00161F\u0011\u0003\u0003[\tQA\r\u00185]A\nAb]3u\u0013:LGo\u0015;faN$2!`A\u001a\u0011\u0019y8\u00021\u0001\u0002\u0012!\u001a1B\u00183\u0002\u0015M,G/T1y\u0013R,'\u000fF\u0002~\u0003wAaa \u0007A\u0002\u0005E\u0001f\u0001\u0007_I\u000611/\u001a;U_2$2!`A\"\u0011\u0019yX\u00021\u0001\u0002FA!\u00111CA$\u0013\r\tIE\u0016\u0002\u0007\t>,(\r\\3)\u00075qF-A\u0004tKR\u001cV-\u001a3\u0015\u0007u\f\t\u0006\u0003\u0004\u0000\u001d\u0001\u0007\u00111\u000b\t\u0005\u0003'\t)&C\u0002\u0002XY\u0013A\u0001T8oO\"\u001aaB\u00183\u0002\u0019M,GoV3jO\"$8i\u001c7\u0015\u0007u\fy\u0006C\u0003\u0000\u001f\u0001\u0007\u0001\u000b\u000b\u0003\u0010=\u0006\r\u0014EAA3\u0003\u0015\u0019d\u0006\r\u00181\u0003%\u0019X\r^*pYZ,'\u000fF\u0002~\u0003WBQa \tA\u0002ACC\u0001\u00050\u0002p\u0005\u0012\u0011\u0011O\u0001\u0006g9\"d\u0006M\u0001\u0014g\u0016$X*\u0019=CY>\u001c7nU5{K&sWJ\u0011\u000b\u0004{\u0006]\u0004BB@\u0012\u0001\u0004\t)\u0005\u000b\u0003\u0012=\u0006=\u0014a\u00014jiR\u0019\u0011)a \t\u000f\u0005\u0005%\u00031\u0001\u0002\u0004\u00069A-\u0019;bg\u0016$\b\u0007BAC\u0003+\u0003b!a\"\u0002\u000e\u0006EUBAAE\u0015\r\tY)N\u0001\u0004gFd\u0017\u0002BAH\u0003\u0013\u0013q\u0001R1uCN,G\u000f\u0005\u0003\u0002\u0014\u0006UE\u0002\u0001\u0003\r\u0003/\u000by(!A\u0001\u0002\u000b\u0005\u0011\u0011\u0014\u0002\u0004?\u0012\u0012\u0014\u0003BAN\u0003C\u0003B!a\u0005\u0002\u001e&\u0019\u0011q\u0014,\u0003\u000f9{G\u000f[5oOB!\u00111CAR\u0013\r\t)K\u0016\u0002\u0004\u0003:L\b\u0006\u0002\n_\u0003S\u000b#!a+\u0002\u000bIr\u0003G\f\u0019\u0002#A\u0014XMZ3s\u00052|7m[*pYZ,'\u000f\u0006\u0003\u00022\u0006]\u0006\u0003BA\n\u0003gK1!!.W\u0005\u001d\u0011un\u001c7fC:Dq!!!\u0014\u0001\u0004\tI\f\r\u0003\u0002<\u0006}\u0006CBAD\u0003\u001b\u000bi\f\u0005\u0003\u0002\u0014\u0006}F\u0001DAa\u0003o\u000b\t\u0011!A\u0003\u0002\u0005e%aA0%g\u0005aAO]1j]^KG\u000f\u001b*poR1\u0011qYAj\u0003?\u0004B!!3\u0002R6\u0011\u00111\u001a\u0006\u0004e\u00055'bAAhk\u0005)Q\u000e\u001c7jE&\u0019A)a3\t\u000f\u0005\u0005E\u00031\u0001\u0002VB\"\u0011q[An!\u0019\t9)!$\u0002ZB!\u00111SAn\t1\ti.a5\u0002\u0002\u0003\u0005)\u0011AAM\u0005\ryF\u0005\u000e\u0005\b\u0003C$\u0002\u0019AAr\u0003\u0015Ign\u001d;s!\rI\u0015Q]\u0005\u0004\u0003OT%aD%ogR\u0014X/\\3oi\u0006$\u0018n\u001c8\u0002\u001dQ\u0014\u0018-\u001b8XSRD'\t\\8dWR1\u0011qYAw\u0003sDq!!!\u0016\u0001\u0004\ty\u000f\r\u0003\u0002r\u0006U\bCBAD\u0003\u001b\u000b\u0019\u0010\u0005\u0003\u0002\u0014\u0006UH\u0001DA|\u0003[\f\t\u0011!A\u0003\u0002\u0005e%aA0%k!9\u0011\u0011]\u000bA\u0002\u0005\r\u0018aE4fi\u0012K7\u000f^1oG\u00164UO\\2uS>tWCAA\u0000!)\t\u0019B!\u0001\u0003\u0006\t\u0015\u0011QI\u0005\u0004\u0005\u00071&!\u0003$v]\u000e$\u0018n\u001c83!\u0011\u00119A!\u0004\u000e\u0005\t%!b\u0001B\u0006g\u00051A.\u001b8bY\u001eLAAa\u0004\u0003\n\t1a+Z2u_J\f!\"\u001b8ji&\fG.\u001b>f)\u0011\u0011)Ba\u0007\u0011\r\u0005M!q\u0003B\u0003\u0013\r\u0011IB\u0016\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\b\u0003\u0003;\u0002\u0019\u0001B\u000fa\u0011\u0011yBa\t\u0011\r\u0005\u001d\u0015Q\u0012B\u0011!\u0011\t\u0019Ja\t\u0005\u0019\t\u0015\"1DA\u0001\u0002\u0003\u0015\t!!'\u0003\u0007}#c'A\bue\u0006t7OZ8s[N\u001b\u0007.Z7b)\u0011\u0011YCa\u000e\u0011\t\t5\"1G\u0007\u0003\u0005_QAA!\r\u0002\n\u0006)A/\u001f9fg&!!Q\u0007B\u0018\u0005)\u0019FO];diRK\b/\u001a\u0005\b\u0005sA\u0002\u0019\u0001B\u0016\u0003\u0019\u00198\r[3nC\"\u001a\u0001D\u00183)\u0007\u0001qF-\u0001\u0004L\u001b\u0016\fgn\u001d\t\u0003\u0005j\u0019rA\u0007B#\u0005\u0017\u0012\t\u0006\u0005\u0003\u0002\u0014\t\u001d\u0013b\u0001B%-\n1\u0011I\\=SK\u001a\u0004B!\u0013B'U&\u0019!q\n&\u0003+\u0011+g-Y;miB\u000b'/Y7t%\u0016\fG-\u00192mKB!!1\u000bB/\u001b\t\u0011)F\u0003\u0003\u0003X\te\u0013AA5p\u0015\t\u0011Y&\u0001\u0003kCZ\f\u0017\u0002\u0002B0\u0005+\u0012AbU3sS\u0006d\u0017N_1cY\u0016$\"A!\u0011\u0002\t1|\u0017\r\u001a\u000b\u0004U\n\u001d\u0004B\u0002B59\u0001\u0007\u0001+\u0001\u0003qCRD\u0007\u0006\u0002\u000f_\u0005[\n#Aa\u001c\u0002\u000bErcG\f\u0019\u0002\rI\u000be\nR(N+\t\u0011)\b\u0005\u0003\u0003x\tuTB\u0001B=\u0015\u0011\u0011YH!\u0017\u0002\t1\fgnZ\u0005\u00047\ne\u0014a\u0002*B\u001d\u0012{U\nI\u0001\u0011\u0017~kU)\u0011(T?B\u000b%+\u0011'M\u000b2\u000b\u0011cS0N\u000b\u0006s5k\u0018)B%\u0006cE*\u0012'!\u0003I\u0019X\u000f\u001d9peR,G-\u00138ji6{G-Z:\u0016\u0005\t%\u0005CBA\n\u0005/\u0011)(A\ntkB\u0004xN\u001d;fI&s\u0017\u000e^'pI\u0016\u001c\b%A\u0005F+\u000ec\u0015\nR#B\u001d\u0006QQ)V\"M\u0013\u0012+\u0015I\u0014\u0011\u0002\r\r{5+\u0013(F\u0003\u001d\u0019ujU%O\u000b\u0002\n1AU(X\u0003\u0011\u0011vj\u0016\u0011\u0002\u000b\tcujQ&\u0002\r\tcujQ&!\u0003\u0011\tU\u000bV(\u0002\u000b\u0005+Fk\u0014\u0011\u0002!M,\b\u000f]8si\u0016$7k\u001c7wKJ\u001c\u0018!E:vaB|'\u000f^3e'>dg/\u001a:tA\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011!\u0011\u0016\t\u0005\u0005o\u0012Y+\u0003\u0003\u0003.\ne$AB(cU\u0016\u001cG\u000f\u000b\u0003\u001b=\n5\u0004\u0006B\r_\u0005[\u0002")
public class KMeans
extends Estimator<KMeansModel>
implements KMeansParams,
DefaultParamsWritable {
    private final String uid;
    private IntParam k;
    private Param<String> initMode;
    private IntParam initSteps;
    private Param<String> solver;
    private DoubleParam maxBlockSizeInMB;
    private Param<String> weightCol;
    private Param<String> distanceMeasure;
    private DoubleParam tol;
    private Param<String> predictionCol;
    private LongParam seed;
    private Param<String> featuresCol;
    private IntParam maxIter;

    public static KMeans load(String path) {
        return KMeans$.MODULE$.load(path);
    }

    public static MLReader<KMeans> read() {
        return KMeans$.MODULE$.read();
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable.write$(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public int getK() {
        return KMeansParams.getK$(this);
    }

    @Override
    public String getInitMode() {
        return KMeansParams.getInitMode$(this);
    }

    @Override
    public int getInitSteps() {
        return KMeansParams.getInitSteps$(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema) {
        return KMeansParams.validateAndTransformSchema$(this, schema);
    }

    @Override
    public final double getMaxBlockSizeInMB() {
        return HasMaxBlockSizeInMB.getMaxBlockSizeInMB$(this);
    }

    @Override
    public final String getSolver() {
        return HasSolver.getSolver$(this);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final String getDistanceMeasure() {
        return HasDistanceMeasure.getDistanceMeasure$(this);
    }

    @Override
    public final double getTol() {
        return HasTol.getTol$(this);
    }

    @Override
    public final String getPredictionCol() {
        return HasPredictionCol.getPredictionCol$(this);
    }

    @Override
    public final long getSeed() {
        return HasSeed.getSeed$(this);
    }

    @Override
    public final String getFeaturesCol() {
        return HasFeaturesCol.getFeaturesCol$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final IntParam k() {
        return this.k;
    }

    @Override
    public final Param<String> initMode() {
        return this.initMode;
    }

    @Override
    public final IntParam initSteps() {
        return this.initSteps;
    }

    @Override
    public final Param<String> solver() {
        return this.solver;
    }

    @Override
    public final void org$apache$spark$ml$clustering$KMeansParams$_setter_$k_$eq(IntParam x$1) {
        this.k = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$KMeansParams$_setter_$initMode_$eq(Param<String> x$1) {
        this.initMode = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$KMeansParams$_setter_$initSteps_$eq(IntParam x$1) {
        this.initSteps = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$KMeansParams$_setter_$solver_$eq(Param<String> x$1) {
        this.solver = x$1;
    }

    @Override
    public final DoubleParam maxBlockSizeInMB() {
        return this.maxBlockSizeInMB;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxBlockSizeInMB$_setter_$maxBlockSizeInMB_$eq(DoubleParam x$1) {
        this.maxBlockSizeInMB = x$1;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasSolver$_setter_$solver_$eq(Param<String> x$1) {
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final Param<String> distanceMeasure() {
        return this.distanceMeasure;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasDistanceMeasure$_setter_$distanceMeasure_$eq(Param<String> x$1) {
        this.distanceMeasure = x$1;
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final Param<String> predictionCol() {
        return this.predictionCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasPredictionCol$_setter_$predictionCol_$eq(Param<String> x$1) {
        this.predictionCol = x$1;
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final Param<String> featuresCol() {
        return this.featuresCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFeaturesCol$_setter_$featuresCol_$eq(Param<String> x$1) {
        this.featuresCol = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    @Override
    public KMeans copy(ParamMap extra) {
        return (KMeans)this.defaultCopy(extra);
    }

    public KMeans setFeaturesCol(String value) {
        return (KMeans)this.set(this.featuresCol(), value);
    }

    public KMeans setPredictionCol(String value) {
        return (KMeans)this.set(this.predictionCol(), value);
    }

    public KMeans setK(int value) {
        return (KMeans)this.set(this.k(), BoxesRunTime.boxToInteger((int)value));
    }

    public KMeans setInitMode(String value) {
        return (KMeans)this.set(this.initMode(), value);
    }

    public KMeans setDistanceMeasure(String value) {
        return (KMeans)this.set(this.distanceMeasure(), value);
    }

    public KMeans setInitSteps(int value) {
        return (KMeans)this.set(this.initSteps(), BoxesRunTime.boxToInteger((int)value));
    }

    public KMeans setMaxIter(int value) {
        return (KMeans)this.set(this.maxIter(), BoxesRunTime.boxToInteger((int)value));
    }

    public KMeans setTol(double value) {
        return (KMeans)this.set(this.tol(), BoxesRunTime.boxToDouble((double)value));
    }

    public KMeans setSeed(long value) {
        return (KMeans)this.set(this.seed(), BoxesRunTime.boxToLong((long)value));
    }

    public KMeans setWeightCol(String value) {
        return (KMeans)this.set(this.weightCol(), value);
    }

    public KMeans setSolver(String value) {
        return (KMeans)this.set(this.solver(), value);
    }

    public KMeans setMaxBlockSizeInMB(double value) {
        return (KMeans)this.set(this.maxBlockSizeInMB(), BoxesRunTime.boxToDouble((double)value));
    }

    @Override
    public KMeansModel fit(Dataset<?> dataset) {
        return (KMeansModel)Instrumentation$.MODULE$.instrumented((Function1 & Serializable)instr -> {
            this.transformSchema(dataset.schema(), true);
            instr.logPipelineStage(this);
            instr.logDataset(dataset);
            instr.logParams(this, (Seq<Param<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Param[]{this.featuresCol(), this.predictionCol(), this.k(), this.initMode(), this.initSteps(), this.distanceMeasure(), this.maxIter(), this.seed(), this.tol(), this.weightCol(), this.solver(), this.maxBlockSizeInMB()}));
            org.apache.spark.mllib.clustering.KMeansModel oldModel = this.preferBlockSolver(dataset) ? this.trainWithBlock(dataset, (Instrumentation)instr) : this.trainWithRow(dataset, (Instrumentation)instr);
            KMeansModel model = this.copyValues(new KMeansModel(this.uid(), oldModel).setParent(this), this.copyValues$default$2());
            KMeansSummary summary = new KMeansSummary(model.transform(dataset), this.$(this.predictionCol()), this.$(this.featuresCol()), BoxesRunTime.unboxToInt((Object)this.$(this.k())), oldModel.numIter(), oldModel.trainingCost());
            model.setSummary((Option<KMeansSummary>)new Some((Object)summary));
            instr.logNamedValue("clusterSizes", summary.clusterSizes());
            return model;
        });
    }

    private boolean preferBlockSolver(Dataset<?> dataset) {
        boolean bl;
        block6: {
            String string;
            block8: {
                boolean bl2;
                block12: {
                    DataType dataType;
                    block9: {
                        long l;
                        Object numNonzeros;
                        block11: {
                            Row row;
                            block10: {
                                Some some;
                                block7: {
                                    block5: {
                                        string = this.$(this.solver());
                                        String string2 = KMeans$.MODULE$.ROW();
                                        String string3 = string;
                                        if (string2 != null ? !string2.equals(string3) : string3 != null) break block5;
                                        bl = false;
                                        break block6;
                                    }
                                    String string4 = KMeans$.MODULE$.BLOCK();
                                    String string5 = string;
                                    if (string4 != null ? !string4.equals(string5) : string5 != null) break block7;
                                    bl = true;
                                    break block6;
                                }
                                String string6 = KMeans$.MODULE$.AUTO();
                                String string7 = string;
                                if (string6 != null ? !string6.equals(string7) : string7 != null) break block8;
                                dataType = dataset.schema().apply(this.$(this.featuresCol())).dataType();
                                if (!(dataType instanceof VectorUDT)) break block9;
                                row = (Row)dataset.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{Summarizer$.MODULE$.metrics((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"count", "numNonZeros"})).summary(DatasetUtils$.MODULE$.checkNonNanVectors(functions$.MODULE$.col(this.$(this.featuresCol())))).as("summary")})).select("summary.count", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"summary.numNonZeros"})).first();
                                if (row == null || (some = Row$.MODULE$.unapplySeq(row)).isEmpty() || some.get() == null || ((SeqOps)some.get()).lengthCompare(2) != 0) break block10;
                                Object count = ((SeqOps)some.get()).apply(0);
                                numNonzeros = ((SeqOps)some.get()).apply(1);
                                if (!(count instanceof Long)) break block10;
                                l = BoxesRunTime.unboxToLong((Object)count);
                                if (numNonzeros instanceof org.apache.spark.ml.linalg.Vector) break block11;
                            }
                            throw new MatchError((Object)row);
                        }
                        org.apache.spark.ml.linalg.Vector vector = (org.apache.spark.ml.linalg.Vector)numNonzeros;
                        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToLong((long)l), (Object)vector);
                        Tuple2 tuple22 = tuple2;
                        long count = tuple22._1$mcJ$sp();
                        org.apache.spark.ml.linalg.Vector numNonzeros2 = (org.apache.spark.ml.linalg.Vector)tuple22._2();
                        int numFeatures = numNonzeros2.size();
                        BigDecimal nnz = (BigDecimal)numNonzeros2.activeIterator().map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5._1$mcI$sp())).foldLeft((Object)scala.package$.MODULE$.BigDecimal().apply(0), (Function2 & Serializable)(x$6, x$7) -> x$6.$plus(BigDecimal$.MODULE$.int2bigDecimal(BoxesRunTime.unboxToInt((Object)x$7))));
                        bl2 = nnz.$greater$eq((Object)scala.package$.MODULE$.BigDecimal().apply(count).$times(BigDecimal$.MODULE$.int2bigDecimal(numFeatures)).$times(BigDecimal$.MODULE$.double2bigDecimal(0.5)));
                        break block12;
                    }
                    if (dataType instanceof ArrayType) {
                        ArrayType arrayType = (ArrayType)dataType;
                        DataType dataType2 = arrayType.elementType();
                        boolean bl3 = dataType2 instanceof FloatType ? true : dataType2 instanceof DoubleType;
                        bl2 = bl3;
                    } else {
                        bl2 = false;
                    }
                }
                bl = bl2;
                break block6;
            }
            throw new MatchError((Object)string);
        }
        return bl;
    }

    private org.apache.spark.mllib.clustering.KMeansModel trainWithRow(Dataset<?> dataset, Instrumentation instr) {
        org.apache.spark.mllib.clustering.KMeans algo = new org.apache.spark.mllib.clustering.KMeans().setK(BoxesRunTime.unboxToInt((Object)this.$(this.k()))).setInitializationMode(this.$(this.initMode())).setInitializationSteps(BoxesRunTime.unboxToInt((Object)this.$(this.initSteps()))).setMaxIterations(BoxesRunTime.unboxToInt((Object)this.$(this.maxIter()))).setSeed(BoxesRunTime.unboxToLong((Object)this.$(this.seed()))).setEpsilon(BoxesRunTime.unboxToDouble((Object)this.$(this.tol()))).setDistanceMeasure(this.$(this.distanceMeasure()));
        RDD instances = dataset.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{DatasetUtils$.MODULE$.checkNonNanVectors(DatasetUtils$.MODULE$.columnToVector(dataset, this.$(this.featuresCol()))), DatasetUtils$.MODULE$.checkNonNegativeWeights(this.get(this.weightCol()))})).rdd().map((Function1 & Serializable)x0$1 -> {
            org.apache.spark.ml.linalg.Vector vector;
            Object w;
            block3: {
                Row row;
                block2: {
                    Some some;
                    row = x0$1;
                    if (row == null || (some = Row$.MODULE$.unapplySeq(row)).isEmpty() || some.get() == null || ((SeqOps)some.get()).lengthCompare(2) != 0) break block2;
                    Object f = ((SeqOps)some.get()).apply(0);
                    w = ((SeqOps)some.get()).apply(1);
                    if (!(f instanceof org.apache.spark.ml.linalg.Vector)) break block2;
                    vector = (org.apache.spark.ml.linalg.Vector)f;
                    if (w instanceof Double) break block3;
                }
                throw new MatchError((Object)row);
            }
            double d = BoxesRunTime.unboxToDouble((Object)w);
            Tuple2 tuple2 = new Tuple2((Object)Vectors$.MODULE$.fromML(vector), (Object)BoxesRunTime.boxToDouble((double)d));
            return tuple2;
        }, ClassTag$.MODULE$.apply(Tuple2.class)).setName("training instances");
        StorageLevel storageLevel = dataset.storageLevel();
        StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
        boolean handlePersistence = !(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null);
        return algo.runWithWeight((RDD<Tuple2<Vector, Object>>)instances, handlePersistence, (Option<Instrumentation>)new Some((Object)instr));
    }

    private org.apache.spark.mllib.clustering.KMeansModel trainWithBlock(Dataset<?> dataset, Instrumentation instr) {
        RDD rDD;
        StorageLevel storageLevel = dataset.storageLevel();
        StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
        if (storageLevel == null ? storageLevel2 != null : !storageLevel.equals(storageLevel2)) {
            instr.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append("Input vectors will be blockified to blocks, and ").append("then cached during training. Be careful of double caching!").toString());
        }
        long initStartTime = System.nanoTime();
        org.apache.spark.ml.linalg.Vector[] centers = this.initialize(dataset);
        double initTimeInSeconds = (double)(System.nanoTime() - initStartTime) / 1.0E9;
        instr.logInfo((Function0<String>)(Function0 & Serializable)() -> {
            String arg$macro$1 = this.$(this.initMode());
            double arg$macro$2 = initTimeInSeconds;
            return StringOps$.MODULE$.format$extension("Initialization with %s took %.3f seconds.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, BoxesRunTime.boxToDouble((double)arg$macro$2)}));
        });
        int numFeatures = ((org.apache.spark.ml.linalg.Vector)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])centers))).size();
        instr.logNumFeatures(numFeatures);
        String string = this.$(this.distanceMeasure());
        String string2 = KMeans$.MODULE$.EUCLIDEAN();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            rDD = dataset.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{DatasetUtils$.MODULE$.checkNonNanVectors(DatasetUtils$.MODULE$.columnToVector(dataset, this.$(this.featuresCol()))), DatasetUtils$.MODULE$.checkNonNegativeWeights(this.get(this.weightCol()))})).rdd().map((Function1 & Serializable)x0$1 -> {
                org.apache.spark.ml.linalg.Vector vector;
                Object weight;
                block3: {
                    Row row;
                    block2: {
                        Some some;
                        row = x0$1;
                        if (row == null || (some = Row$.MODULE$.unapplySeq(row)).isEmpty() || some.get() == null || ((SeqOps)some.get()).lengthCompare(2) != 0) break block2;
                        Object features = ((SeqOps)some.get()).apply(0);
                        weight = ((SeqOps)some.get()).apply(1);
                        if (!(features instanceof org.apache.spark.ml.linalg.Vector)) break block2;
                        vector = (org.apache.spark.ml.linalg.Vector)features;
                        if (weight instanceof Double) break block3;
                    }
                    throw new MatchError((Object)row);
                }
                double d = BoxesRunTime.unboxToDouble((Object)weight);
                Instance instance = new Instance(BLAS$.MODULE$.dot(vector, vector), d, vector);
                return instance;
            }, ClassTag$.MODULE$.apply(Instance.class));
        } else {
            String string4 = KMeans$.MODULE$.COSINE();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                rDD = dataset.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{DatasetUtils$.MODULE$.checkNonNanVectors(DatasetUtils$.MODULE$.columnToVector(dataset, this.$(this.featuresCol()))), DatasetUtils$.MODULE$.checkNonNegativeWeights(this.get(this.weightCol()))})).rdd().map((Function1 & Serializable)x0$2 -> {
                    org.apache.spark.ml.linalg.Vector vector;
                    Object weight;
                    block3: {
                        Row row;
                        block2: {
                            Some some;
                            row = x0$2;
                            if (row == null || (some = Row$.MODULE$.unapplySeq(row)).isEmpty() || some.get() == null || ((SeqOps)some.get()).lengthCompare(2) != 0) break block2;
                            Object features = ((SeqOps)some.get()).apply(0);
                            weight = ((SeqOps)some.get()).apply(1);
                            if (!(features instanceof org.apache.spark.ml.linalg.Vector)) break block2;
                            vector = (org.apache.spark.ml.linalg.Vector)features;
                            if (weight instanceof Double) break block3;
                        }
                        throw new MatchError((Object)row);
                    }
                    double d = BoxesRunTime.unboxToDouble((Object)weight);
                    Instance instance = new Instance(1.0, d, org.apache.spark.ml.linalg.Vectors$.MODULE$.normalize(vector, 2.0));
                    return instance;
                }, ClassTag$.MODULE$.apply(Instance.class));
            } else {
                throw new MatchError((Object)string);
            }
        }
        RDD instances = rDD;
        double actualBlockSizeInMB = BoxesRunTime.unboxToDouble((Object)this.$(this.maxBlockSizeInMB()));
        if (actualBlockSizeInMB == 0.0) {
            actualBlockSizeInMB = InstanceBlock$.MODULE$.DefaultBlockSizeInMB();
            Predef$.MODULE$.require(actualBlockSizeInMB > 0.0, (Function0 & Serializable)() -> "inferred actual BlockSizeInMB must > 0");
            instr.logNamedValue("actualBlockSizeInMB", Double.toString(actualBlockSizeInMB));
        }
        long maxMemUsage = (long)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(actualBlockSizeInMB * (double)1024L * (double)1024L));
        RDD blocks = InstanceBlock$.MODULE$.blokifyWithMaxMemUsage((RDD<Instance>)instances, maxMemUsage).persist(StorageLevel$.MODULE$.MEMORY_AND_DISK()).setName(new StringBuilder(34).append(this.uid()).append(": training blocks (blockSizeInMB=").append(actualBlockSizeInMB).append(")").toString());
        Function2<org.apache.spark.ml.linalg.Vector, org.apache.spark.ml.linalg.Vector, Object> distanceFunction = this.getDistanceFunction();
        SparkContext sc = dataset.sparkSession().sparkContext();
        long iterationStartTime = System.nanoTime();
        BooleanRef converged = BooleanRef.create((boolean)false);
        DoubleRef cost = DoubleRef.create((double)0.0);
        IntRef iteration = IntRef.create((int)0);
        while (iteration.elem < BoxesRunTime.unboxToInt((Object)this.$(this.maxIter())) && !converged.elem) {
            Broadcast bcCenters = sc.broadcast((Object)DenseMatrix$.MODULE$.fromVectors((Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)centers)), ClassTag$.MODULE$.apply(DenseMatrix.class));
            LongAccumulator countSumAccum = iteration.elem == 0 ? sc.longAccumulator() : null;
            DoubleAccumulator weightSumAccum = iteration.elem == 0 ? sc.doubleAccumulator() : null;
            DoubleAccumulator costSumAccum = sc.doubleAccumulator();
            Map newCenters = RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(blocks.mapPartitions((Function1 & Serializable)iter -> {
                Iterator iterator;
                if (iter.nonEmpty()) {
                    KMeansAggregator agg = new KMeansAggregator((DenseMatrix)bcCenters.value(), BoxesRunTime.unboxToInt((Object)this.$(this.k())), numFeatures, this.$(this.distanceMeasure()));
                    iter.foreach((Function1 & Serializable)block -> agg.add((InstanceBlock)block));
                    if (iteration$1.elem == 0) {
                        countSumAccum.add(agg.count());
                        weightSumAccum.add(agg.weightSum());
                    }
                    costSumAccum.add(agg.costSum());
                    iterator = agg.weightSumVec().iterator().zip((IterableOnce)agg.sumMat().rowIter()).flatMap((Function1 & Serializable)x0$3 -> {
                        org.apache.spark.ml.linalg.Vector vectorSum;
                        Tuple2 tuple2;
                        block3: {
                            Tuple2 tuple22;
                            block2: {
                                tuple22 = x0$3;
                                if (tuple22 == null) break block2;
                                tuple2 = (Tuple2)tuple22._1();
                                vectorSum = (org.apache.spark.ml.linalg.Vector)tuple22._2();
                                if (tuple2 != null) break block3;
                            }
                            throw new MatchError((Object)tuple22);
                        }
                        int i = tuple2._1$mcI$sp();
                        double weightSum = tuple2._2$mcD$sp();
                        None$ none$ = weightSum > 0.0 ? new Some((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)i), (Object)new Tuple2((Object)BoxesRunTime.boxToDouble((double)weightSum), (Object)vectorSum.toDense()))) : None$.MODULE$;
                        return none$;
                    });
                } else {
                    iterator = scala.package$.MODULE$.Iterator().empty();
                }
                return iterator;
            }, blocks.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), (ClassTag)ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Int$.MODULE$).reduceByKey((Function2 & Serializable)(sum1, sum2) -> {
                BLAS$.MODULE$.axpy(1.0, (org.apache.spark.ml.linalg.Vector)sum2._2(), (org.apache.spark.ml.linalg.Vector)sum1._2());
                return new Tuple2((Object)BoxesRunTime.boxToDouble((double)(sum1._1$mcD$sp() + sum2._1$mcD$sp())), sum1._2());
            }), (ClassTag)ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Int$.MODULE$).mapValues((Function1 & Serializable)x0$4 -> {
                Tuple2 tuple2 = x0$4;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                double weightSum = tuple2._1$mcD$sp();
                DenseVector vectorSum = (DenseVector)tuple2._2();
                BLAS$.MODULE$.scal(1.0 / weightSum, (org.apache.spark.ml.linalg.Vector)vectorSum);
                String string = this.$(this.distanceMeasure());
                String string2 = KMeans$.MODULE$.COSINE();
                String string3 = string;
                Object object = !(string2 != null ? !string2.equals(string3) : string3 != null) ? org.apache.spark.ml.linalg.Vectors$.MODULE$.normalize((org.apache.spark.ml.linalg.Vector)vectorSum, 2.0) : vectorSum;
                DenseVector denseVector = object;
                return denseVector;
            }), (ClassTag)ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(org.apache.spark.ml.linalg.Vector.class), (Ordering)Ordering.Int$.MODULE$).collectAsMap();
            bcCenters.destroy();
            if (iteration.elem == 0) {
                instr.logNumExamples(Predef$.MODULE$.Long2long(countSumAccum.value()));
                instr.logSumOfWeights(Predef$.MODULE$.Double2double(weightSumAccum.value()));
            }
            converged.elem = true;
            newCenters.foreach((Function1 & Serializable)x0$5 -> {
                KMeans.$anonfun$trainWithBlock$11(this, converged, distanceFunction, centers, x0$5);
                return BoxedUnit.UNIT;
            });
            cost.elem = Predef$.MODULE$.Double2double(costSumAccum.value());
            ++iteration.elem;
        }
        blocks.unpersist(blocks.unpersist$default$1());
        double iterationTimeInSeconds = (double)(System.nanoTime() - iterationStartTime) / 1.0E9;
        instr.logInfo((Function0<String>)(Function0 & Serializable)() -> {
            double arg$macro$3 = iterationTimeInSeconds;
            return StringOps$.MODULE$.format$extension("Iterations took %.3f seconds.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$3)}));
        });
        if (iteration.elem == BoxesRunTime.unboxToInt((Object)this.$(this.maxIter()))) {
            instr.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(46).append("KMeans reached the max number of iterations: ").append(this.$(this.maxIter())).append(".").toString());
        } else {
            instr.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(32).append("KMeans converged in ").append(iteration$1.elem).append(" iterations.").toString());
        }
        instr.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(13).append("The cost is ").append(cost$1.elem).append(".").toString());
        return new org.apache.spark.mllib.clustering.KMeansModel((Vector[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])centers), (Function1 & Serializable)v -> Vectors$.MODULE$.fromML((org.apache.spark.ml.linalg.Vector)v), ClassTag$.MODULE$.apply(Vector.class)), this.$(this.distanceMeasure()), cost.elem, iteration.elem);
    }

    private Function2<org.apache.spark.ml.linalg.Vector, org.apache.spark.ml.linalg.Vector, Object> getDistanceFunction() {
        Function2 & Serializable intersect;
        String string = this.$(this.distanceMeasure());
        String string2 = KMeans$.MODULE$.EUCLIDEAN();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            intersect = (Function2 & Serializable)(v1, v2) -> BoxesRunTime.boxToDouble((double)package$.MODULE$.sqrt(org.apache.spark.ml.linalg.Vectors$.MODULE$.sqdist(v1, v2)));
        } else {
            String string4 = KMeans$.MODULE$.COSINE();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                intersect = (Function2 & Serializable)(v1, v2) -> BoxesRunTime.boxToDouble((double)KMeans.$anonfun$getDistanceFunction$2(v1, v2));
            } else {
                throw new MatchError((Object)string);
            }
        }
        return intersect;
    }

    private org.apache.spark.ml.linalg.Vector[] initialize(Dataset<?> dataset) {
        org.apache.spark.ml.linalg.Vector[] vectorArray;
        org.apache.spark.mllib.clustering.KMeans algo = new org.apache.spark.mllib.clustering.KMeans().setK(BoxesRunTime.unboxToInt((Object)this.$(this.k()))).setInitializationMode(this.$(this.initMode())).setInitializationSteps(BoxesRunTime.unboxToInt((Object)this.$(this.initSteps()))).setMaxIterations(BoxesRunTime.unboxToInt((Object)this.$(this.maxIter()))).setSeed(BoxesRunTime.unboxToLong((Object)this.$(this.seed()))).setEpsilon(BoxesRunTime.unboxToDouble((Object)this.$(this.tol()))).setDistanceMeasure(this.$(this.distanceMeasure()));
        RDD vectors = dataset.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{DatasetUtils$.MODULE$.columnToVector(dataset, this.getFeaturesCol())})).rdd().map((Function1 & Serializable)x0$1 -> {
            Object features;
            Some some;
            Row row = x0$1;
            if (row == null || (some = Row$.MODULE$.unapplySeq(row)).isEmpty() || some.get() == null || ((SeqOps)some.get()).lengthCompare(1) != 0 || !((features = ((SeqOps)some.get()).apply(0)) instanceof org.apache.spark.ml.linalg.Vector)) {
                throw new MatchError((Object)row);
            }
            org.apache.spark.ml.linalg.Vector vector = (org.apache.spark.ml.linalg.Vector)features;
            Vector vector2 = Vectors$.MODULE$.fromML(vector);
            return vector2;
        }, ClassTag$.MODULE$.apply(Vector.class));
        org.apache.spark.ml.linalg.Vector[] centers = (org.apache.spark.ml.linalg.Vector[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])algo.initialize((RDD<Vector>)vectors)), (Function1 & Serializable)x$8 -> x$8.asML(), ClassTag$.MODULE$.apply(org.apache.spark.ml.linalg.Vector.class));
        String string = this.$(this.distanceMeasure());
        String string2 = KMeans$.MODULE$.EUCLIDEAN();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            vectorArray = centers;
        } else {
            String string4 = KMeans$.MODULE$.COSINE();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                vectorArray = (org.apache.spark.ml.linalg.Vector[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])centers), (Function1 & Serializable)x$9 -> org.apache.spark.ml.linalg.Vectors$.MODULE$.normalize(x$9, 2.0), ClassTag$.MODULE$.apply(org.apache.spark.ml.linalg.Vector.class));
            } else {
                throw new MatchError((Object)string);
            }
        }
        return vectorArray;
    }

    @Override
    public StructType transformSchema(StructType schema) {
        return this.validateAndTransformSchema(schema);
    }

    public static final /* synthetic */ void $anonfun$trainWithBlock$11(KMeans $this, BooleanRef converged$1, Function2 distanceFunction$1, org.apache.spark.ml.linalg.Vector[] centers$1, Tuple2 x0$5) {
        org.apache.spark.ml.linalg.Vector newCenter;
        Tuple2 tuple2 = x0$5;
        if (tuple2 != null) {
            int i = tuple2._1$mcI$sp();
            newCenter = (org.apache.spark.ml.linalg.Vector)tuple2._2();
            if (converged$1.elem && BoxesRunTime.unboxToDouble((Object)distanceFunction$1.apply((Object)centers$1[i], (Object)newCenter)) > BoxesRunTime.unboxToDouble((Object)$this.$($this.tol()))) {
                converged$1.elem = false;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        centers$1[i] = newCenter;
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ double $anonfun$getDistanceFunction$2(org.apache.spark.ml.linalg.Vector v1, org.apache.spark.ml.linalg.Vector v2) {
        double norm1 = org.apache.spark.ml.linalg.Vectors$.MODULE$.norm(v1, 2.0);
        double norm2 = org.apache.spark.ml.linalg.Vectors$.MODULE$.norm(v2, 2.0);
        Predef$.MODULE$.require(norm1 > 0.0 && norm2 > 0.0, (Function0 & Serializable)() -> "Cosine distance is not defined for zero-length vectors.");
        return 1.0 - BLAS$.MODULE$.dot(v1, v2) / norm1 / norm2;
    }

    public KMeans(String uid) {
        this.uid = uid;
        HasMaxIter.$init$(this);
        HasFeaturesCol.$init$(this);
        HasSeed.$init$(this);
        HasPredictionCol.$init$(this);
        HasTol.$init$(this);
        HasDistanceMeasure.$init$(this);
        HasWeightCol.$init$(this);
        HasSolver.$init$(this);
        HasMaxBlockSizeInMB.$init$(this);
        KMeansParams.$init$(this);
        MLWritable.$init$(this);
        DefaultParamsWritable.$init$(this);
        Statics.releaseFence();
    }

    public KMeans() {
        this(Identifiable$.MODULE$.randomUID("kmeans"));
    }
}

