/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.asynchttpclient.netty.request.body;

import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import org.apache.pulsar.shade.io.netty.channel.FileRegion;
import org.apache.pulsar.shade.io.netty.util.AbstractReferenceCounted;
import org.apache.pulsar.shade.org.asynchttpclient.request.body.RandomAccessBody;
import org.apache.pulsar.shade.org.asynchttpclient.util.Assertions;
import org.apache.pulsar.shade.org.asynchttpclient.util.MiscUtils;

class BodyFileRegion
extends AbstractReferenceCounted
implements FileRegion {
    private final RandomAccessBody body;
    private long transferred;

    BodyFileRegion(RandomAccessBody body) {
        this.body = Assertions.assertNotNull(body, "body");
    }

    @Override
    public long position() {
        return 0L;
    }

    @Override
    public long count() {
        return this.body.getContentLength();
    }

    @Override
    public long transfered() {
        return this.transferred();
    }

    @Override
    public long transferred() {
        return this.transferred;
    }

    @Override
    public FileRegion retain() {
        super.retain();
        return this;
    }

    @Override
    public FileRegion retain(int arg0) {
        super.retain(arg0);
        return this;
    }

    @Override
    public FileRegion touch() {
        return this;
    }

    @Override
    public FileRegion touch(Object arg0) {
        return this;
    }

    @Override
    public long transferTo(WritableByteChannel target, long position) throws IOException {
        long written = this.body.transferTo(target);
        if (written > 0L) {
            this.transferred += written;
        }
        return written;
    }

    @Override
    protected void deallocate() {
        MiscUtils.closeSilently(this.body);
    }
}

