/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.firebird.packet.handshake;

import lombok.Generated;
import org.apache.shardingsphere.database.protocol.firebird.constant.buffer.FirebirdParameterBuffer;
import org.apache.shardingsphere.database.protocol.firebird.constant.buffer.type.FirebirdDatabaseParameterBufferType;
import org.apache.shardingsphere.database.protocol.firebird.packet.FirebirdPacket;
import org.apache.shardingsphere.database.protocol.firebird.payload.FirebirdPacketPayload;

public final class FirebirdAttachPacket
extends FirebirdPacket {
    private final int id;
    private final String database;
    private final FirebirdParameterBuffer dpb = FirebirdDatabaseParameterBufferType.createBuffer();

    public FirebirdAttachPacket(FirebirdPacketPayload payload) {
        this.id = payload.readInt4();
        this.database = payload.readString();
        this.dpb.parseBuffer(payload.readBuffer());
    }

    public String getEncoding() {
        return (String)this.dpb.getValue(FirebirdDatabaseParameterBufferType.LC_CTYPE);
    }

    public String getAuthData() {
        return (String)this.dpb.getValue(FirebirdDatabaseParameterBufferType.SPECIFIC_AUTH_DATA);
    }

    public String getUsername() {
        return (String)this.dpb.getValue(FirebirdDatabaseParameterBufferType.USER_NAME);
    }

    public String getEncPassword() {
        return (String)this.dpb.getValue(FirebirdDatabaseParameterBufferType.PASSWORD_ENC);
    }

    @Override
    protected void write(FirebirdPacketPayload payload) {
    }

    @Generated
    public int getId() {
        return this.id;
    }

    @Generated
    public String getDatabase() {
        return this.database;
    }

    @Generated
    public FirebirdParameterBuffer getDpb() {
        return this.dpb;
    }
}

