/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.firebird.packet.command.query.info.type.sql;

import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.database.protocol.firebird.exception.FirebirdProtocolException;
import org.apache.shardingsphere.database.protocol.firebird.packet.FirebirdPacket;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.info.FirebirdInfoPacketType;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.info.type.common.FirebirdCommonInfoPacketType;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.info.type.sql.FirebirdSQLInfoPacketType;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.info.type.sql.FirebirdSQLInfoReturnValue;
import org.apache.shardingsphere.database.protocol.firebird.payload.FirebirdPacketPayload;

public final class FirebirdSQLInfoReturnPacket
extends FirebirdPacket {
    private final List<FirebirdInfoPacketType> infoItems;

    @Override
    protected void write(FirebirdPacketPayload payload) {
        for (FirebirdInfoPacketType type : this.infoItems) {
            if (type.isCommon()) {
                FirebirdCommonInfoPacketType.parseCommonInfo(payload, (FirebirdCommonInfoPacketType)type);
                continue;
            }
            this.parseSQLInfo(payload, (FirebirdSQLInfoPacketType)type);
        }
    }

    private void parseSQLInfo(FirebirdPacketPayload payload, FirebirdSQLInfoPacketType type) {
        switch (type) {
            case RECORDS: {
                this.processRecords(payload);
                return;
            }
        }
        throw new FirebirdProtocolException("Unknown database information request type %d", type.getCode());
    }

    private void processRecords(FirebirdPacketPayload payload) {
        payload.writeInt1(FirebirdSQLInfoPacketType.RECORDS.getCode());
        payload.writeInt2LE(0);
        payload.writeInt1(FirebirdSQLInfoReturnValue.SELECT.getCode());
        payload.writeInt2LE(4);
        payload.writeInt4LE(0);
        payload.writeInt1(FirebirdSQLInfoReturnValue.INSERT.getCode());
        payload.writeInt2LE(4);
        payload.writeInt4LE(0);
        payload.writeInt1(FirebirdSQLInfoReturnValue.UPDATE.getCode());
        payload.writeInt2LE(4);
        payload.writeInt4LE(0);
        payload.writeInt1(FirebirdSQLInfoReturnValue.DELETE.getCode());
        payload.writeInt2LE(4);
        payload.writeInt4LE(0);
    }

    @Generated
    public FirebirdSQLInfoReturnPacket(List<FirebirdInfoPacketType> infoItems) {
        this.infoItems = infoItems;
    }

    @Generated
    public List<FirebirdInfoPacketType> getInfoItems() {
        return this.infoItems;
    }
}

