/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.firebird.packet.command.query.blob;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import lombok.Generated;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.FirebirdCommandPacket;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.blob.FirebirdBlobRegistry;
import org.apache.shardingsphere.database.protocol.firebird.payload.FirebirdPacketPayload;

public final class FirebirdPutBlobSegmentCommandPacket
extends FirebirdCommandPacket {
    private final int blobHandle;
    private final byte[] segment;
    private final int segmentLength;

    public FirebirdPutBlobSegmentCommandPacket(FirebirdPacketPayload payload) {
        FirebirdBlobRegistry.clearSegment();
        payload.skipReserved(4);
        this.blobHandle = payload.readInt4();
        this.segmentLength = payload.readInt4();
        ByteBuf buffer = payload.readBuffer();
        this.segment = new byte[buffer.readableBytes()];
        buffer.readBytes(this.segment);
        Preconditions.checkArgument((this.segmentLength == this.segment.length ? 1 : 0) != 0, (String)"Segment length mismatch, expected: %s, actual: %s", (int)this.segmentLength, (int)this.segment.length);
        FirebirdBlobRegistry.setSegment(this.segment);
    }

    @Override
    protected void write(FirebirdPacketPayload payload) {
    }

    public static int getLength(FirebirdPacketPayload payload) {
        int length = 12;
        length += payload.getBufferLength(length);
        return length;
    }

    @Generated
    public int getBlobHandle() {
        return this.blobHandle;
    }

    @Generated
    public byte[] getSegment() {
        return this.segment;
    }

    @Generated
    public int getSegmentLength() {
        return this.segmentLength;
    }
}

