/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.tcl.local.type;

import java.sql.SQLException;
import org.apache.shardingsphere.database.connector.core.metadata.database.metadata.DialectDatabaseMetaData;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.proxy.backend.connector.jdbc.transaction.ProxyBackendTransactionManager;
import org.apache.shardingsphere.proxy.backend.handler.ProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.update.UpdateResponseHeader;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.SetAutoCommitStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.TCLStatement;

public final class SetAutoCommitProxyBackendHandler
implements ProxyBackendHandler {
    private final TCLStatement sqlStatement;
    private final ConnectionSession connectionSession;
    private final ProxyBackendTransactionManager transactionManager;
    private final DialectDatabaseMetaData dialectDatabaseMetaData;

    public SetAutoCommitProxyBackendHandler(TCLStatement sqlStatement, ConnectionSession connectionSession) {
        this.sqlStatement = sqlStatement;
        this.connectionSession = connectionSession;
        this.transactionManager = new ProxyBackendTransactionManager(connectionSession.getDatabaseConnectionManager());
        this.dialectDatabaseMetaData = new DatabaseTypeRegistry(connectionSession.getProtocolType()).getDialectDatabaseMetaData();
    }

    @Override
    public ResponseHeader execute() throws SQLException {
        if (this.dialectDatabaseMetaData.getTransactionOption().isSupportAutoCommitInNestedTransaction() && this.connectionSession.getTransactionStatus().isInTransaction() && ((SetAutoCommitStatement)this.sqlStatement).isAutoCommit()) {
            this.transactionManager.commit();
        }
        this.connectionSession.setAutoCommit(((SetAutoCommitStatement)this.sqlStatement).isAutoCommit());
        return new UpdateResponseHeader((SQLStatement)this.sqlStatement);
    }
}

