/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.tcl.local.type;

import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import org.apache.shardingsphere.database.connector.core.metadata.database.metadata.DialectDatabaseMetaData;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.proxy.backend.connector.jdbc.transaction.ProxyBackendTransactionManager;
import org.apache.shardingsphere.proxy.backend.handler.ProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.update.UpdateResponseHeader;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.ReleaseSavepointStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.TCLStatement;

public final class ReleaseSavepointProxyBackendHandler
implements ProxyBackendHandler {
    private final TCLStatement sqlStatement;
    private final ConnectionSession connectionSession;
    private final ProxyBackendTransactionManager transactionManager;
    private final DialectDatabaseMetaData dialectDatabaseMetaData;

    public ReleaseSavepointProxyBackendHandler(TCLStatement sqlStatement, ConnectionSession connectionSession) {
        this.sqlStatement = sqlStatement;
        this.connectionSession = connectionSession;
        this.transactionManager = new ProxyBackendTransactionManager(connectionSession.getDatabaseConnectionManager());
        this.dialectDatabaseMetaData = new DatabaseTypeRegistry(connectionSession.getProtocolType()).getDialectDatabaseMetaData();
    }

    @Override
    public ResponseHeader execute() throws SQLException {
        ShardingSpherePreconditions.checkState((boolean)this.isValidSavepointStatus(), () -> new SQLFeatureNotSupportedException("RELEASE SAVEPOINT can only be used in transaction blocks"));
        this.transactionManager.releaseSavepoint(((ReleaseSavepointStatement)this.sqlStatement).getSavepointName());
        return new UpdateResponseHeader((SQLStatement)this.sqlStatement);
    }

    private boolean isValidSavepointStatus() {
        return this.connectionSession.getTransactionStatus().isInTransaction() || !this.dialectDatabaseMetaData.getSchemaOption().getDefaultSchema().isPresent();
    }
}

