/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql.ral.updatable.refresh;

import java.util.Collection;
import java.util.Collections;
import org.apache.shardingsphere.distsql.handler.engine.update.DistSQLUpdateExecutor;
import org.apache.shardingsphere.distsql.statement.type.ral.updatable.RefreshDatabaseMetaDataStatement;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.util.SystemSchemaUtils;
import org.apache.shardingsphere.mode.manager.ContextManager;

public final class RefreshDatabaseMetaDataExecutor
implements DistSQLUpdateExecutor<RefreshDatabaseMetaDataStatement> {
    public void executeUpdate(RefreshDatabaseMetaDataStatement sqlStatement, ContextManager contextManager) {
        Collection databases = sqlStatement.getDatabaseName().map(optional -> Collections.singleton(contextManager.getDatabase(optional))).orElseGet(() -> contextManager.getMetaDataContexts().getMetaData().getAllDatabases());
        for (ShardingSphereDatabase each : databases) {
            if (SystemSchemaUtils.isSystemSchema((ShardingSphereDatabase)each)) continue;
            contextManager.reloadDatabase(each);
        }
    }

    public Class<RefreshDatabaseMetaDataStatement> getType() {
        return RefreshDatabaseMetaDataStatement.class;
    }
}

