/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.statement.core.extractor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.sql.parser.statement.core.enums.LogicalOperator;
import org.apache.shardingsphere.sql.parser.statement.core.extractor.ColumnExtractor;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.assignment.InsertValuesSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.datetime.DatetimeExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.BetweenExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.CaseWhenExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.FunctionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.InExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ListExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.NotExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.TypeCastExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ValuesExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.subquery.SubqueryExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.subquery.SubquerySegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.AggregationProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ExpressionProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.IntervalExpressionProjection;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.join.OuterJoinExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.multiset.MultisetExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.predicate.AndPredicate;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.match.MatchAgainstExpression;

public final class ExpressionExtractor {
    public static Collection<AndPredicate> extractAndPredicates(ExpressionSegment expression) {
        LinkedList<AndPredicate> result = new LinkedList<AndPredicate>();
        ExpressionExtractor.extractAndPredicates(result, expression);
        return result;
    }

    private static void extractAndPredicates(Collection<AndPredicate> result, ExpressionSegment expression) {
        if (!(expression instanceof BinaryOperationExpression)) {
            result.add(ExpressionExtractor.createAndPredicate(expression));
            return;
        }
        BinaryOperationExpression binaryExpression = (BinaryOperationExpression)expression;
        Optional<LogicalOperator> logicalOperator = LogicalOperator.valueFrom(binaryExpression.getOperator());
        if (logicalOperator.isPresent() && LogicalOperator.OR == logicalOperator.get()) {
            ExpressionExtractor.extractAndPredicates(result, binaryExpression.getLeft());
            ExpressionExtractor.extractAndPredicates(result, binaryExpression.getRight());
        } else if (logicalOperator.isPresent() && LogicalOperator.AND == logicalOperator.get()) {
            Collection<AndPredicate> predicates = ExpressionExtractor.extractAndPredicates(binaryExpression.getRight());
            for (AndPredicate each : ExpressionExtractor.extractAndPredicates(binaryExpression.getLeft())) {
                ExpressionExtractor.extractCombinedAndPredicates(result, each, predicates);
            }
        } else {
            result.add(ExpressionExtractor.createAndPredicate(expression));
        }
    }

    private static void extractCombinedAndPredicates(Collection<AndPredicate> result, AndPredicate current, Collection<AndPredicate> predicates) {
        for (AndPredicate each : predicates) {
            AndPredicate predicate = new AndPredicate();
            predicate.getPredicates().addAll(current.getPredicates());
            predicate.getPredicates().addAll(each.getPredicates());
            result.add(predicate);
        }
    }

    private static AndPredicate createAndPredicate(ExpressionSegment expression) {
        AndPredicate result = new AndPredicate();
        result.getPredicates().add(expression);
        return result;
    }

    public static Collection<ExpressionSegment> extractAllExpressions(ExpressionSegment expression) {
        LinkedList<ExpressionSegment> result = new LinkedList<ExpressionSegment>();
        LinkedList<ExpressionSegment> stack = new LinkedList<ExpressionSegment>();
        stack.push(expression);
        while (!stack.isEmpty()) {
            ExpressionSegment expressionSegment = (ExpressionSegment)stack.pop();
            if (expressionSegment instanceof BinaryOperationExpression) {
                BinaryOperationExpression binaryExpression = (BinaryOperationExpression)expressionSegment;
                Optional<LogicalOperator> logicalOperator = LogicalOperator.valueFrom(binaryExpression.getOperator());
                if (logicalOperator.isPresent()) {
                    stack.push(binaryExpression.getRight());
                    stack.push(binaryExpression.getLeft());
                    continue;
                }
                result.add(expressionSegment);
                continue;
            }
            result.add(expressionSegment);
        }
        return result;
    }

    public static List<ParameterMarkerExpressionSegment> getParameterMarkerExpressions(Collection<ExpressionSegment> expressions) {
        ArrayList<ParameterMarkerExpressionSegment> result = new ArrayList<ParameterMarkerExpressionSegment>();
        ExpressionExtractor.extractParameterMarkerExpressions(result, expressions);
        return result;
    }

    private static void extractParameterMarkerExpressions(List<ParameterMarkerExpressionSegment> segments, Collection<ExpressionSegment> expressions) {
        for (ExpressionSegment each : expressions) {
            if (each instanceof ParameterMarkerExpressionSegment) {
                segments.add((ParameterMarkerExpressionSegment)each);
            }
            if (each instanceof BinaryOperationExpression) {
                ExpressionExtractor.extractParameterMarkerExpressions(segments, Collections.singleton(((BinaryOperationExpression)each).getLeft()));
                ExpressionExtractor.extractParameterMarkerExpressions(segments, Collections.singleton(((BinaryOperationExpression)each).getRight()));
            }
            if (each instanceof FunctionSegment) {
                ExpressionExtractor.extractParameterMarkerExpressions(segments, ((FunctionSegment)each).getParameters());
            }
            if (each instanceof TypeCastExpression) {
                ExpressionExtractor.extractParameterMarkerExpressions(segments, Collections.singleton(((TypeCastExpression)each).getExpression()));
            }
            if (each instanceof InExpression) {
                ExpressionExtractor.extractParameterMarkerExpressions(segments, ((InExpression)each).getExpressionList());
            }
            if (!(each instanceof CaseWhenExpression)) continue;
            ExpressionExtractor.extractParameterMarkerInCaseWhenExpression(segments, (CaseWhenExpression)each);
        }
    }

    private static void extractParameterMarkerInCaseWhenExpression(List<ParameterMarkerExpressionSegment> segments, CaseWhenExpression expression) {
        if (null != expression.getCaseExpr()) {
            ExpressionExtractor.extractParameterMarkerExpressions(segments, Collections.singletonList(expression.getCaseExpr()));
        }
        if (null != expression.getWhenExprs()) {
            ExpressionExtractor.extractParameterMarkerExpressions(segments, expression.getWhenExprs());
        }
        if (null != expression.getThenExprs()) {
            ExpressionExtractor.extractParameterMarkerExpressions(segments, expression.getThenExprs());
        }
        if (null != expression.getElseExpr()) {
            ExpressionExtractor.extractParameterMarkerExpressions(segments, Collections.singletonList(expression.getElseExpr()));
        }
    }

    public static void extractJoinConditions(Collection<BinaryOperationExpression> joinConditions, Collection<WhereSegment> whereSegments) {
        for (WhereSegment each : whereSegments) {
            if (!(each.getExpr() instanceof BinaryOperationExpression)) continue;
            ExpressionExtractor.extractJoinConditions(joinConditions, (BinaryOperationExpression)each.getExpr());
        }
    }

    private static void extractJoinConditions(Collection<BinaryOperationExpression> joinConditions, BinaryOperationExpression binaryOperationExpression) {
        if (binaryOperationExpression.getLeft() instanceof ColumnSegment && binaryOperationExpression.getRight() instanceof ColumnSegment) {
            joinConditions.add(binaryOperationExpression);
        }
        if (binaryOperationExpression.getLeft() instanceof BinaryOperationExpression) {
            ExpressionExtractor.extractJoinConditions(joinConditions, (BinaryOperationExpression)binaryOperationExpression.getLeft());
        }
        if (binaryOperationExpression.getRight() instanceof BinaryOperationExpression) {
            ExpressionExtractor.extractJoinConditions(joinConditions, (BinaryOperationExpression)binaryOperationExpression.getRight());
        }
    }

    public static Collection<ColumnSegment> extractColumns(ExpressionSegment expression, boolean containsSubQuery) {
        if (expression instanceof ColumnSegment) {
            return Collections.singletonList((ColumnSegment)expression);
        }
        LinkedList<ColumnSegment> result = new LinkedList<ColumnSegment>();
        if (expression instanceof AggregationProjectionSegment) {
            for (ExpressionSegment expressionSegment : ((AggregationProjectionSegment)expression).getParameters()) {
                result.addAll(ExpressionExtractor.extractColumns(expressionSegment, containsSubQuery));
            }
        }
        if (expression instanceof BetweenExpression) {
            result.addAll(ExpressionExtractor.extractColumns(((BetweenExpression)expression).getLeft(), containsSubQuery));
            result.addAll(ExpressionExtractor.extractColumns(((BetweenExpression)expression).getBetweenExpr(), containsSubQuery));
            result.addAll(ExpressionExtractor.extractColumns(((BetweenExpression)expression).getAndExpr(), containsSubQuery));
        }
        if (expression instanceof BinaryOperationExpression) {
            result.addAll(ExpressionExtractor.extractColumns(((BinaryOperationExpression)expression).getLeft(), containsSubQuery));
            result.addAll(ExpressionExtractor.extractColumns(((BinaryOperationExpression)expression).getRight(), containsSubQuery));
        }
        if (expression instanceof CaseWhenExpression) {
            result.addAll(ExpressionExtractor.extractColumns(((CaseWhenExpression)expression).getCaseExpr(), containsSubQuery));
            result.addAll(ExpressionExtractor.extractColumns(((CaseWhenExpression)expression).getElseExpr(), containsSubQuery));
            ((CaseWhenExpression)expression).getWhenExprs().forEach(each -> result.addAll(ExpressionExtractor.extractColumns(each, containsSubQuery)));
            ((CaseWhenExpression)expression).getThenExprs().forEach(each -> result.addAll(ExpressionExtractor.extractColumns(each, containsSubQuery)));
        }
        if (expression instanceof OuterJoinExpression) {
            result.add(((OuterJoinExpression)expression).getColumnName());
        }
        if (expression instanceof DatetimeExpression) {
            result.addAll(ExpressionExtractor.extractColumns(((DatetimeExpression)expression).getLeft(), containsSubQuery));
            result.addAll(ExpressionExtractor.extractColumns(((DatetimeExpression)expression).getRight(), containsSubQuery));
        }
        if (expression instanceof ExpressionProjectionSegment) {
            result.addAll(ExpressionExtractor.extractColumns(((ExpressionProjectionSegment)expression).getExpr(), containsSubQuery));
        }
        if (expression instanceof FunctionSegment) {
            for (ExpressionSegment expressionSegment : ((FunctionSegment)expression).getParameters()) {
                result.addAll(ExpressionExtractor.extractColumns(expressionSegment, containsSubQuery));
            }
        }
        if (expression instanceof InExpression) {
            result.addAll(ExpressionExtractor.extractColumns(((InExpression)expression).getLeft(), containsSubQuery));
            result.addAll(ExpressionExtractor.extractColumns(((InExpression)expression).getRight(), containsSubQuery));
        }
        if (expression instanceof IntervalExpressionProjection) {
            result.addAll(ExpressionExtractor.extractColumns(((IntervalExpressionProjection)expression).getLeft(), containsSubQuery));
            result.addAll(ExpressionExtractor.extractColumns(((IntervalExpressionProjection)expression).getRight(), containsSubQuery));
            result.addAll(ExpressionExtractor.extractColumns(((IntervalExpressionProjection)expression).getMinus(), containsSubQuery));
        }
        if (expression instanceof ListExpression) {
            for (ExpressionSegment expressionSegment : ((ListExpression)expression).getItems()) {
                result.addAll(ExpressionExtractor.extractColumns(expressionSegment, containsSubQuery));
            }
        }
        if (expression instanceof MatchAgainstExpression) {
            result.addAll(((MatchAgainstExpression)expression).getColumns());
            result.addAll(ExpressionExtractor.extractColumns(((MatchAgainstExpression)expression).getExpr(), containsSubQuery));
        }
        if (expression instanceof MultisetExpression) {
            result.addAll(ExpressionExtractor.extractColumns(((MultisetExpression)expression).getLeft(), containsSubQuery));
            result.addAll(ExpressionExtractor.extractColumns(((MultisetExpression)expression).getRight(), containsSubQuery));
        }
        if (expression instanceof NotExpression) {
            result.addAll(ExpressionExtractor.extractColumns(((NotExpression)expression).getExpression(), containsSubQuery));
        }
        if (expression instanceof ValuesExpression) {
            for (InsertValuesSegment insertValuesSegment : ((ValuesExpression)expression).getRowConstructorList()) {
                insertValuesSegment.getValues().forEach(value -> result.addAll(ExpressionExtractor.extractColumns(value, containsSubQuery)));
            }
        }
        if (expression instanceof SubquerySegment && containsSubQuery) {
            ColumnExtractor.extractFromSelectStatement(result, ((SubquerySegment)expression).getSelect(), true);
        }
        if (expression instanceof SubqueryExpressionSegment && containsSubQuery) {
            ColumnExtractor.extractFromSelectStatement(result, ((SubqueryExpressionSegment)expression).getSubquery().getSelect(), true);
        }
        return result;
    }

    @Generated
    private ExpressionExtractor() {
    }
}

