/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.checker.ddl;

import com.cedarsoftware.util.CaseInsensitiveSet;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.context.RouteMapper;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.sharding.checker.sql.util.ShardingSupportedCheckUtils;
import org.apache.shardingsphere.sharding.exception.connection.ShardingDDLRouteException;
import org.apache.shardingsphere.sharding.exception.metadata.InUsedTablesException;
import org.apache.shardingsphere.sharding.route.engine.checker.ShardingRouteContextChecker;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.table.DropTableStatement;

public final class ShardingDropTableRouteContextChecker
implements ShardingRouteContextChecker {
    @Override
    public void check(ShardingRule shardingRule, QueryContext queryContext, ShardingSphereDatabase database, ConfigurationProperties props, RouteContext routeContext) {
        this.checkTableInUsed(shardingRule, queryContext.getSqlStatementContext(), routeContext);
        for (SimpleTableSegment each : ((DropTableStatement)queryContext.getSqlStatementContext().getSqlStatement()).getTables()) {
            ShardingSpherePreconditions.checkState((!ShardingSupportedCheckUtils.isRouteUnitDataNodeDifferentSize(shardingRule, routeContext, each.getTableName().getIdentifier().getValue()) ? 1 : 0) != 0, () -> new ShardingDDLRouteException("DROP", "TABLE", queryContext.getSqlStatementContext().getTablesContext().getTableNames()));
        }
    }

    private void checkTableInUsed(ShardingRule shardingRule, SQLStatementContext sqlStatementContext, RouteContext routeContext) {
        Collection dropTables = sqlStatementContext.getTablesContext().getTableNames();
        Collection otherRuleActualTables = (Collection)shardingRule.getShardingTables().values().stream().filter(each -> !dropTables.contains(each.getLogicTable())).flatMap(each -> each.getActualDataNodes().stream().map(DataNode::getTableName)).collect(Collectors.toCollection(CaseInsensitiveSet::new));
        if (otherRuleActualTables.isEmpty()) {
            return;
        }
        Set actualTables = routeContext.getRouteUnits().stream().flatMap(each -> each.getTableMappers().stream().map(RouteMapper::getActualName)).collect(Collectors.toSet());
        Collection inUsedTables = actualTables.stream().filter(otherRuleActualTables::contains).collect(Collectors.toList());
        ShardingSpherePreconditions.checkMustEmpty((Collection)inUsedTables, () -> new InUsedTablesException(inUsedTables));
    }
}

