/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rewrite.token.pojo;

import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.metadata.database.schema.util.IndexMetaDataUtils;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.RouteUnitAware;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.SQLToken;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.Substitutable;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.sharding.rewrite.token.pojo.ShardingTokenUtils;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.index.CreateIndexStatement;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class IndexToken
extends SQLToken
implements Substitutable,
RouteUnitAware {
    private final int stopIndex;
    private final IdentifierValue identifier;
    private final SQLStatementContext sqlStatementContext;
    private final ShardingRule rule;
    private final ShardingSphereSchema schema;

    public IndexToken(int startIndex, int stopIndex, IdentifierValue identifier, SQLStatementContext sqlStatementContext, ShardingRule shardingRule, ShardingSphereSchema schema) {
        super(startIndex);
        this.stopIndex = stopIndex;
        this.identifier = identifier;
        this.sqlStatementContext = sqlStatementContext;
        this.rule = shardingRule;
        this.schema = schema;
    }

    public String toString(RouteUnit routeUnit) {
        String quotedIndexName = this.identifier.getQuoteCharacter().wrap(this.getIndexValue(routeUnit));
        return this.isGeneratedIndex() ? " " + quotedIndexName + " " : quotedIndexName;
    }

    private boolean isGeneratedIndex() {
        return this.sqlStatementContext.getSqlStatement() instanceof CreateIndexStatement && null == ((CreateIndexStatement)this.sqlStatementContext.getSqlStatement()).getIndex();
    }

    private String getIndexValue(RouteUnit routeUnit) {
        Optional<String> logicTableName = this.findLogicTableNameFromMetaData(this.identifier.getValue());
        if (logicTableName.isPresent() && !this.rule.isShardingTable(logicTableName.get())) {
            return this.identifier.getValue();
        }
        Map<String, String> logicAndActualTables = ShardingTokenUtils.getLogicAndActualTableMap(routeUnit, this.sqlStatementContext, this.rule);
        String actualTableName = logicTableName.map(logicAndActualTables::get).orElseGet(() -> logicAndActualTables.isEmpty() ? null : (String)logicAndActualTables.values().iterator().next());
        return IndexMetaDataUtils.getActualIndexName((String)this.identifier.getValue(), (String)actualTableName);
    }

    private Optional<String> findLogicTableNameFromMetaData(String logicIndexName) {
        for (ShardingSphereTable each : this.schema.getAllTables()) {
            if (!each.containsIndex(logicIndexName)) continue;
            return Optional.of(each.getName());
        }
        return Optional.empty();
    }

    @Generated
    public int getStopIndex() {
        return this.stopIndex;
    }
}

