/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.scenario.migration.distsql.handler.update;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.PipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.api.type.StandardPipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.core.context.PipelineContextKey;
import org.apache.shardingsphere.data.pipeline.core.exception.job.MissingRequiredTargetDatabaseException;
import org.apache.shardingsphere.data.pipeline.core.job.api.TransmissionJobAPI;
import org.apache.shardingsphere.data.pipeline.core.metadata.PipelineDataSourcePersistService;
import org.apache.shardingsphere.data.pipeline.core.metadata.loader.PipelineSchemaUtils;
import org.apache.shardingsphere.data.pipeline.scenario.migration.api.MigrationJobAPI;
import org.apache.shardingsphere.data.pipeline.scenario.migration.api.MigrationSourceTargetEntry;
import org.apache.shardingsphere.data.pipeline.scenario.migration.distsql.segment.MigrationSourceTargetSegment;
import org.apache.shardingsphere.data.pipeline.scenario.migration.distsql.statement.updatable.MigrateTableStatement;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.distsql.handler.aware.DistSQLExecutorDatabaseAware;
import org.apache.shardingsphere.distsql.handler.engine.update.DistSQLUpdateExecutor;
import org.apache.shardingsphere.distsql.handler.required.DistSQLExecutorClusterModeRequired;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.datasource.pool.props.domain.DataSourcePoolProperties;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.instance.metadata.InstanceType;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.infra.yaml.config.swapper.resource.YamlDataSourceConfigurationSwapper;
import org.apache.shardingsphere.mode.manager.ContextManager;

@DistSQLExecutorClusterModeRequired
public final class MigrateTableExecutor
implements DistSQLUpdateExecutor<MigrateTableStatement>,
DistSQLExecutorDatabaseAware {
    private ShardingSphereDatabase database;

    public void executeUpdate(MigrateTableStatement sqlStatement, ContextManager contextManager) {
        String targetDatabaseName = null == sqlStatement.getTargetDatabaseName() ? this.database.getName() : sqlStatement.getTargetDatabaseName();
        ShardingSpherePreconditions.checkState((boolean)contextManager.getMetaDataContexts().getMetaData().containsDatabase(targetDatabaseName), () -> new MissingRequiredTargetDatabaseException(targetDatabaseName));
        MigrationJobAPI jobAPI = (MigrationJobAPI)TypedSPILoader.getService(TransmissionJobAPI.class, (Object)"MIGRATION");
        PipelineContextKey contextKey = new PipelineContextKey(InstanceType.PROXY);
        jobAPI.schedule(contextKey, this.getMigrationSourceTargetEntries(contextKey, sqlStatement), targetDatabaseName);
    }

    private Collection<MigrationSourceTargetEntry> getMigrationSourceTargetEntries(PipelineContextKey contextKey, MigrateTableStatement sqlStatement) {
        LinkedList<MigrationSourceTargetEntry> result = new LinkedList<MigrationSourceTargetEntry>();
        for (MigrationSourceTargetSegment each : sqlStatement.getSourceTargetEntries()) {
            String schemaName = null == each.getSourceSchemaName() ? (String)this.getDefaultSchemaName(contextKey, each.getSourceDatabaseName()).orElse(null) : each.getSourceSchemaName();
            result.add(new MigrationSourceTargetEntry(new DataNode(each.getSourceDatabaseName(), schemaName, each.getSourceTableName()), each.getTargetTableName()));
        }
        return result;
    }

    private Optional<String> getDefaultSchemaName(PipelineContextKey contextKey, String sourceDatabaseName) {
        if (new DatabaseTypeRegistry(this.database.getProtocolType()).getDialectDatabaseMetaData().getSchemaOption().isSchemaAvailable()) {
            Map metaDataDataSource = new PipelineDataSourcePersistService().load(contextKey, "MIGRATION");
            Map sourceDataSourcePoolProps = new YamlDataSourceConfigurationSwapper().swapToMap((DataSourcePoolProperties)metaDataDataSource.get(sourceDatabaseName));
            return Optional.of(PipelineSchemaUtils.getDefaultSchema((PipelineDataSourceConfiguration)new StandardPipelineDataSourceConfiguration(sourceDataSourcePoolProps)));
        }
        return Optional.empty();
    }

    public Class<MigrateTableStatement> getType() {
        return MigrateTableStatement.class;
    }

    @Generated
    public void setDatabase(ShardingSphereDatabase database) {
        this.database = database;
    }
}

