/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.scenario.migration.distsql.handler.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.pojo.ConsistencyCheckJobItemInfo;
import org.apache.shardingsphere.data.pipeline.scenario.consistencycheck.ConsistencyCheckJobType;
import org.apache.shardingsphere.data.pipeline.scenario.consistencycheck.api.ConsistencyCheckJobAPI;
import org.apache.shardingsphere.data.pipeline.scenario.migration.distsql.statement.queryable.ShowMigrationCheckStatusStatement;
import org.apache.shardingsphere.distsql.handler.engine.query.DistSQLQueryExecutor;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.mode.manager.ContextManager;

public final class ShowMigrationCheckStatusExecutor
implements DistSQLQueryExecutor<ShowMigrationCheckStatusStatement> {
    private final ConsistencyCheckJobAPI jobAPI = new ConsistencyCheckJobAPI(new ConsistencyCheckJobType());

    public Collection<String> getColumnNames(ShowMigrationCheckStatusStatement sqlStatement) {
        return Arrays.asList("tables", "result", "check_failed_tables", "ignored_tables", "active", "inventory_finished_percentage", "inventory_remaining_seconds", "incremental_idle_seconds", "check_begin_time", "check_end_time", "duration_seconds", "algorithm_type", "algorithm_props", "error_message");
    }

    public Collection<LocalDataQueryResultRow> getRows(ShowMigrationCheckStatusStatement sqlStatement, ContextManager contextManager) {
        ConsistencyCheckJobItemInfo jobItemInfo = this.jobAPI.getJobItemInfo(sqlStatement.getJobId());
        return Collections.singletonList(this.convert(jobItemInfo));
    }

    private LocalDataQueryResultRow convert(ConsistencyCheckJobItemInfo info) {
        String incrementalIdleSeconds = null == info.getIncrementalIdleSeconds() ? "" : String.valueOf(info.getIncrementalIdleSeconds());
        return new LocalDataQueryResultRow(new Object[]{info.getTableNames(), info.getCheckSuccess(), info.getCheckFailedTableNames(), info.getIgnoredTableNames(), info.isActive(), info.getInventoryFinishedPercentage(), info.getInventoryRemainingSeconds(), incrementalIdleSeconds, info.getCheckBeginTime(), info.getCheckEndTime(), info.getDurationSeconds(), info.getAlgorithmType(), info.getAlgorithmProps(), info.getErrorMessage()});
    }

    public Class<ShowMigrationCheckStatusStatement> getType() {
        return ShowMigrationCheckStatusStatement.class;
    }
}

