/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.mysql.handler.admin;

import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.type.dml.SelectStatementContext;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.DatabaseAdminExecutor;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.DatabaseAdminExecutorCreator;
import org.apache.shardingsphere.proxy.backend.mysql.handler.admin.executor.MySQLKillProcessExecutor;
import org.apache.shardingsphere.proxy.backend.mysql.handler.admin.executor.MySQLSetVariableAdminExecutor;
import org.apache.shardingsphere.proxy.backend.mysql.handler.admin.executor.MySQLUseDatabaseExecutor;
import org.apache.shardingsphere.proxy.backend.mysql.handler.admin.factory.MySQLSelectAdminExecutorFactory;
import org.apache.shardingsphere.proxy.backend.mysql.handler.admin.factory.MySQLShowAdminExecutorFactory;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dal.SetStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.MySQLKillStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.MySQLUseStatement;

public final class MySQLAdminExecutorCreator
implements DatabaseAdminExecutorCreator {
    public Optional<DatabaseAdminExecutor> create(SQLStatementContext sqlStatementContext, String sql, String databaseName, List<Object> parameters) {
        if (sqlStatementContext instanceof SelectStatementContext) {
            return MySQLSelectAdminExecutorFactory.newInstance((SelectStatementContext)sqlStatementContext, sql, parameters, databaseName, ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData());
        }
        SQLStatement sqlStatement = sqlStatementContext.getSqlStatement();
        Optional<DatabaseAdminExecutor> showExecutor = MySQLShowAdminExecutorFactory.newInstance(sqlStatement);
        if (showExecutor.isPresent()) {
            return showExecutor;
        }
        if (sqlStatement instanceof MySQLUseStatement) {
            return Optional.of(new MySQLUseDatabaseExecutor((MySQLUseStatement)sqlStatement));
        }
        if (sqlStatement instanceof MySQLKillStatement) {
            return Optional.of(new MySQLKillProcessExecutor((MySQLKillStatement)sqlStatement));
        }
        if (sqlStatement instanceof SetStatement) {
            return Optional.of(new MySQLSetVariableAdminExecutor((SetStatement)sqlStatement));
        }
        return Optional.empty();
    }

    public String getDatabaseType() {
        return "MySQL";
    }
}

