/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.engine.opengauss.visitor.statement.type;

import java.util.Collection;
import java.util.Collections;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.sql.parser.api.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.statement.type.DCLStatementVisitor;
import org.apache.shardingsphere.sql.parser.autogen.OpenGaussStatementParser;
import org.apache.shardingsphere.sql.parser.engine.opengauss.visitor.statement.OpenGaussStatementVisitor;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dcl.GrantStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dcl.RevokeStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dcl.role.AlterRoleStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dcl.role.CreateRoleStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dcl.role.DropRoleStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dcl.user.AlterUserStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dcl.user.CreateUserStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dcl.user.DropUserStatement;
import org.apache.shardingsphere.sql.parser.statement.core.value.collection.CollectionValue;

public final class OpenGaussDCLStatementVisitor
extends OpenGaussStatementVisitor
implements DCLStatementVisitor {
    public OpenGaussDCLStatementVisitor(DatabaseType databaseType) {
        super(databaseType);
    }

    @Override
    public ASTNode visitGrant(OpenGaussStatementParser.GrantContext ctx) {
        GrantStatement result = new GrantStatement(this.getDatabaseType());
        if (this.containsTableSegment(ctx.privilegeClause())) {
            result.getTables().addAll(this.getTableSegments(ctx.privilegeClause()));
        }
        return result;
    }

    @Override
    public ASTNode visitRevoke(OpenGaussStatementParser.RevokeContext ctx) {
        RevokeStatement result = new RevokeStatement(this.getDatabaseType());
        if (this.containsTableSegment(ctx.privilegeClause())) {
            result.getTables().addAll(this.getTableSegments(ctx.privilegeClause()));
        }
        return result;
    }

    private boolean containsTableSegment(OpenGaussStatementParser.PrivilegeClauseContext ctx) {
        return null != ctx && null != ctx.onObjectClause() && null != ctx.onObjectClause().privilegeLevel() && null != ctx.onObjectClause().privilegeLevel().tableNames();
    }

    private Collection<SimpleTableSegment> getTableSegments(OpenGaussStatementParser.PrivilegeClauseContext ctx) {
        return ((CollectionValue)this.visit((ParseTree)ctx.onObjectClause().privilegeLevel().tableNames())).getValue();
    }

    @Override
    public ASTNode visitCreateUser(OpenGaussStatementParser.CreateUserContext ctx) {
        return new CreateUserStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropUser(OpenGaussStatementParser.DropUserContext ctx) {
        return new DropUserStatement(this.getDatabaseType(), Collections.emptyList());
    }

    @Override
    public ASTNode visitAlterUser(OpenGaussStatementParser.AlterUserContext ctx) {
        return new AlterUserStatement(this.getDatabaseType(), null);
    }

    @Override
    public ASTNode visitCreateRole(OpenGaussStatementParser.CreateRoleContext ctx) {
        return new CreateRoleStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterRole(OpenGaussStatementParser.AlterRoleContext ctx) {
        return new AlterRoleStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropRole(OpenGaussStatementParser.DropRoleContext ctx) {
        return new DropRoleStatement(this.getDatabaseType());
    }
}

